---
language: javascript
exerciseType: 1
difficulty: 1
title: Raindrops
---

# --description--

Your task is to convert a number into a string that contains raindrop sounds corresponding to certain potential factors.
A factor is a number that evenly divides into another number, leaving no remainder.
The simplest way to test if a number is a factor of another is to use the modulo operation.
The rules of raindrops are the followings:

- has 3 as a factor, add 'Pling' to the result.
- has 5 as a factor, add 'Plang' to the result.
- has 7 as a factor, add 'Plong' to the result.
- does not have any of 3, 5, or 7 as a factor, the result should be the digits of the number.

# --instructions--

Write a function that returns the correct string, examples:

- 28 has 7 as a factor, but not 3 or 5, so the result would be `"Plong"`.
- 30 has both 3 and 5 as factors, but not 7, so the result would be `"PlingPlang"`.
- 34 is not factored by 3, 5, or 7, so the result would be `"34"`.

# --before-seed--

```javascript
// DO NOT EDIT FROM HERE
var _testFailedCount = 0;
var _testCount = 0;
var assert = require('assert')
const tryCatch = (...args) => {
  _testCount++
  try { assert(...args) }
  catch (e) {
    _testFailedCount++
    console.log(`Test Case '--err-t${_testCount}--' failed`);
  }
};
// DO NOT EDIT UNTIL HERE
```

# --seed--

```javascript
function convert(number) {
  
}
```

# --asserts--

The sound for 1 is "1"

```javascript
tryCatch(convert(1) === "1");
```

The sound for 3 is "Pling"

```javascript
tryCatch(convert(3) === "Pling");
```

The sound for 5 is "Plang"

```javascript
tryCatch(convert(5) === "Plang");
```

The sound for 7 is "Plong"

```javascript
tryCatch(convert(7) === "Plong");
```

The sound for 6 is "Pling"

```javascript
tryCatch(convert(6) === "Pling");
```

The sound for 8 is "8"

```javascript
tryCatch(convert(8) === "8");
```

The sound for 9 is "Pling"

```javascript
tryCatch(convert(9) === "Pling");
```

The sound for 10 is "Plang"

```javascript
tryCatch(convert(10) === "Plang");
```

The sound for 14 is "Plong"

```javascript
tryCatch(convert(14) === "Plong");
```

The sound for 15 is "PlingPlang"

```javascript
tryCatch(convert(15) === "PlingPlang");
```

The sound for 21 is "PlingPlong"

```javascript
tryCatch(convert(21) === "PlingPlong");
```

The sound for 25 is "Plang"

```javascript
tryCatch(convert(25) === "Plang");
```

The sound for 27 is "Pling"

```javascript
tryCatch(convert(27) === "Pling");
```

The sound for 35 is "PlangPlong"

```javascript
tryCatch(convert(35) === "PlangPlong");
```

The sound for 49 is "Plong"

```javascript
tryCatch(convert(49) === "Plong");
```

The sound for 52 is "52"

```javascript
tryCatch(convert(52) === "52");
```

The sound for 105 is "PlingPlangPlong"

```javascript
tryCatch(convert(105) === "PlingPlangPlong");
```

The sound for 3125 is "Plang"

```javascript
tryCatch(convert(3125) === "Plang");
```

# --after-asserts--

```javascript
// DO NOT EDIT FROM HERE 
console.log(`Executed ${_testCount} tests, with ${_testFailedCount} failures`);
// DO NOT EDIT UNTIL HERE
```

# --solutions--

```javascript
function convert(number) {
  var result = ""
  if (number % 3 == 0) {
    result += "Pling"
  }
  if (number % 5 == 0) {
    result += "Plang"
  }
  if (number % 7 == 0) {
    result += "Plong"
  }
  if (!result) {
    result = number.toString()
  }
  return result
}
```
