---
language: javascript
exerciseType: 2
---

# --description--

Sometimes you need to search for an item in an array.
In JavaScript we can use the `indexOf()` method:
```javascript
var names = ["Trevor", "Zac", "Glenn"];
console.log(names.indexOf('Zac'));
// prints 1
```
The code above prints the first index that contains the string `"Zac"`, `1` in this case.
We can also insert items into an array in a specific index, using the `splice()` method:
```javascript
names.splice(1, 0, "Ali");
// prints ["Trevor", "Ali", "Zac", "Glenn"]
```
The code above inserts `"Ali"` at index `1`, which moves everything, after this index, down by 1.
The second value `0` means _deleteCount_, in this case, we don't delete any item in the array; but if we had specified `1` the value `Zac` would have been removed from the array

# --instructions--

- Use the `indexOf()` method to print the index of `"dog"`.
- Then use the `splice()` method to add `"bear"` as first item of the array

# --seed--

```javascript
var animals = ["cat", "monkey", "dog"];
console.log(animals.[/]([/]));
animals.[/]([/], 0, "bear");
console.log(animals);
```

# --answers--

- index
- indexOf
- dog
- "dog"
- insert
- append
- add
- 0
- 1
- splice

# --solutions--

```javascript
var animals = ["cat", "monkey", "dog"];
console.log(animals.indexOf("dog"));
animals.splice(0, 0, "bear");
console.log(animals);
```

# --output--

2
["bear", "cat", "monkey", "dog"]
