---
language: dart
exerciseType: 2
---

# --description--

When you have declared a constant variable, you can no longer change its value. For example:

```dart
const number = 2;
number = 3; // Error
```

This code produces the error:
> Constant variables can't be assigned a value.

That is, it is not possible to change the value of a constant variable.

# --instructions--

Try changing the value of the constant `number` and observe the error you get.

# --seed--

```dart
void main() {
    const number = 1;
    [/][/][/];
}
```

# --answers--

- number
-  = 
- 2
-  == 
- const

# --solutions--

```dart
void main() {
    const number = 1;
    number = 2;
}
```

# --output--

Constant variables can't be assigned a value.
Try removing the assignment, or remove the modifier 'const' from the variable.
