---
language: dart
exerciseType: 1
---

# --description--

Dart supports two different types of "_variables_" whose value never changes. They are declared with the keywords `const` and `final`.
Let's start by seeing what is meant by `const`.

## const (constants)

Variables whose value you can change are known as __mutable_data__. Mutable data is often overused and can present problems. It is easy to lose track of all the points in the code that can change the value of a variable.

For this reason, you should use `const`ants instead of `var`iables whenever possible. These variables that cannot change value are also called __immutable data__.

To create a constant in Dart we use the `const` keyword:

```dart
const number = 5;
```

Just like `var`, Dart with the __type inference__ determines that `number` is of type `int`.

# --instructions--

Declare a constant `name` and assign it your name.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`nome` must be a constant.

```dart
  test('test1', () {
    expect(name, TypeMatcher<String>(), reason: '--err-t1--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
const name = "Ale"; // any name is ok
```
