---
language: dart
exerciseType: 1
---

# --description--

Dart supports __type inference__.
It is not necessary to indicate the type of a variable as Dart can infer its type.
The `var` keyword tells Dart to use the most appropriate type.

```dart
var number = 5;
```

It is not necessary to tell Dart that the number `5` is of type `int`.
Dart infers the type and makes `number` of type `int`.

# --instructions--

Initialise the variable `x` with the number `3.14159` and let Dart infer the type.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` must be equal to `3.14159`.

```dart
  test('test1', () {
    expect(number(), 3.14159, reason: '--err-t1--');
  });
```

`x` must be of type `double`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<double>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
var x = 3.14159;
```
