---
language: dart
exerciseType: 1
---

# --description--

If you like to live by risk, we can completely ignore the __type-safety__ of the language by using the `dynamic` type.
This allows you to assign any type of value to the variable.

```dart
dynamic number;
number = 1; // OK
number = 3.14159; // OK
number = '10'; // OK
```

This approach is strongly discouraged as errors are no longer intercepted by the code's _analyzer_, but only _runtime_ (when the programme is running).

# --instructions--

Initialise the variable `x` with the number `10` and the type `dynamic`.
Update the variable with the string `Hello`.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` must be equal to `"Hello"`.

```dart
  test('test1', () {
    expect(number(), "Hello", reason: '--err-t1--');
  });
```

`x` must be of type `dynamic`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<dynamic>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
dynamic x = 10;
x = "Hello";
```
