---
language: dart
exerciseType: 1
---

# --description--

Dart is a __type-safe__ language.
This means that when you assign a type to a variable, you cannot change it afterwards. Here is an example:

```dart
int integerNumber = 1;
integerNumber = 3.14159; // Error
```

3.14159` is of type `double`, but you've already defined `integerNumber` with type `int`.

Of course, occasionally it might be useful to assign related types to the same variable. For example you might want a variable `integerNumber` which accepts both `int` and `double` numbers, like here:

```dart
num number;
number = 1; // OK
number = 3.14159; // OK
number = '10'; // Error
```

Both `int` and `double` extend `num`, so both types are accepted.
However, if we try to assign a `String` the compiler returns an error.

# --instructions--

Initialise the variable `x` with the number `15` and the type `num`.
Update the variable with the number `3.14159`.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` must be equal to `3.14159`.

```dart
  test('test1', () {
    expect(number(), 3.14159, reason: '--err-t1--');
  });
```

`x` must be of type `num`

```dart
  test('test2', () {
    expect(number(), TypeMatcher<num>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
num x = 15;
x = 3.14159;
```
