---
language: dart
exerciseType: 1
---

# --description--

The `int` type allows whole numbers to be stored.
To save decimal numbers instead, we can use the `double` type:

```dart
double pi = 3.14159;
```

This example is similar to the previous one. This time, however, the variable is of type `double`, a type which allows decimal numbers to be stored with high precision.


# --instructions--

Assign the variable `x` the value `6.28`.

# --before-seed--

```dart
dynamic number() {
```

# --after-seed--

```dart
  return x;
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`x` must be equal to `6.28`.

```dart
  test('test1', () {
    expect(number(), 6.28, reason: '--err-t1--');
  });
```

`x` must be of type `double`

```dart
    test('test2', () {
      expect(number(), TypeMatcher<double>(), reason: '--err-t2--');
    });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
double x = 6.28;
```
