---
language: dart
exerciseType: 2
---

# --description--

Here is an example of a value that can only be obtained at runtime:

```dart
final currentHour = DateTime.now().hour;
```

`DateTime.now()` is a function to get the current date and time of when the code is executed.
With the `hour` field we access the number of hours that have passed since the start of the day.

Since the value of `hour` is different depending on when the code is executed, this can be defined as the _runtime_ value.

If you try to change the value of a `final` variable, you get an error.

# --instructions--

Try changing the value of the constant `number` and observe the error you get.

# --seed--

```dart
void main() {
    final number = 1;
    [/][/][/];
}
```

# --answers--

- number
-  = 
- 2
-  == 
- const
- final

# --solutions--

```dart
void main() {
    final number = 1;
    number = 2;
}
```

# --output--

The final variable `number` can only be set once.
