---
language: dart
exerciseType: 1
---

# --description--

You will often find yourself in the situation of wanting to use a constant but not knowing the value at compile time. You will only know the value after the program has started execution.
This type of constant is known as a __runtime constant__.

In Dart `const` is only used for __compile-time constants__ for values that can be determined by the compiler before the programme is executed.

If you cannot create a constant variable because you do not know its compile-time value, then you must use the `final` keyword to make the variable a __runtime constant__.

There are many reasons why you cannot know the value of a variable before running the program. For example, you would have to get the value from the server, or ask the user for it.

# --instructions--

Declare a __runtime constant__ `age` and assign it your age.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`age` must be a __runtime constant__.

```dart
  test('test1', () {
    expect(age, TypeMatcher<int>(), reason: '--err-t1--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
final age = 26; // any age is ok
```
