---
language: dart
exerciseType: 1
---

# --description--

Variables are containers for storing values.
Every variable in Dart is an object (`Object`).
To create a variable, we have to give it a __name__ taking into account the fact that it must not contain spaces.
Take a look at the following:

```dart
int number = 1;
```

This statement declares a variable called `number` of type `int`.
It then sets the value of the variable to number `1`.
The `int` part of the declaration is known as __type annotation__, and tells Dart explicitly the type of the variable.

# --instructions--

Assign the variable `y` the value `2`.

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

`y` must be equal to `2`

```dart
  test('test1', () {
    expect(y, 2, reason: '--err-t1--');
  });
```

`y` must be of type `int`

```dart
  test('test2', () {
    expect(y, TypeMatcher<int>(), reason: '--err-t2--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
int y = 2;
```
