---
language: dart
exerciseType: 2
---

# --description--

So far we have seen the operators used independently on integers or decimals. What if you have 
an integer and need to multiply it with a decimal number? Let's see an example:
```dart
const radius = 5;
const pi = 3.14;
const circumference = 2 * pi * radius;
```

`radius` is of type `int` while `pi` is of type `double`. What will be the type of `circumference`? Dart will assign the type `double` to the variable `circumference`. This is the safer choice as if I had made it of type `int` it could have caused a loss of precision.

If you want an `int` as a result, you have to do the conversion explicitly:
```dart
const circumference = (2 * pi * radius).toInt();
```

The parentheses tell Dart to multiply first, and then take the result and convert it to an integer value. Unfortunately the analyzer will not like this code:
 > Const variables must be initialized with a constant value.

The problem is that the `toInt` method is a runtime-only method. This means that the `circumference` variable cannot be determined at compile time, so it is not possible for the variable to be constant. To fix replace `const` with `final`:

```dart
final circumference = (2 * pi * radius).toInt();
```

Now `circumference` is a __runtime constant__ variable of type `int`.

# --instructions--

Create a __runtime constant__ variable of type `int`.

# --seed--

```dart
const hourlyRate = 10.40;
const hoursWorked = 8;
[/] total = ([/] * hoursWorked).[/];
print(total);
```

# --answers--

- final
- Const
- const
- hourlyRate
- toInt()
- [
- {

# --solutions--

```dart
const hourlyRate = 10.40;
const hoursWorked = 8;
final total = (hourlyRate * hoursWorked).toInt();
print(total);
```

# --output--

83
