---
language: dart
exerciseType: 2
---

# --description--

Sometimes you will find yourself in the situation of having one type, but needing to convert it to another. You might be tempted to do:

```dart
var integer = 5;
var decimal = 3.14;
integer = decimal;
```

But Dart will complain and give you the error:
> Error: A value of type 'double' can't be assigned to a variable of type 'int'.

Some programming languages are not that restrictive and will silently convert. Experience shows that this type of silent implicit conversion is a frequent source of bugs and performance problems. Dart has disabled this feature to avoid these problems.

Remember, computers rely on programmers to figure out what to do. In Dart this includes being explicit about the type of conversion.

Instead of expecting an implicit conversion from Dart, you need to explicitly say that you want Dart to convert the type to you. Here's how to convert a `double` number to an `int` one:
```dart
var integer = decimal.toInt();
```

The assignment tells Dart, unequivocally, that you want to convert from the original type `double` to the new type `double`.

> NOTES: In this case, assigning a decimal value to an integer loses precision. The variable `integer` has the value __3__ instead of __3.14__. This is why it's important to be explicit. Dart wants to be sure of what you are doing and lets you know that you will lose information by converting.

# --instructions--

Convert the variable `number` to a string

# --seed--

```dart
const number = 5;
print([/][/][/]);
```

# --answers--

- number
- .
- toString()
- toStr()
- toString
- string
- as String

# --solutions--

```dart
const number = 5;
print(number.toString());
```

# --output--

5
