---
language: dart
exerciseType: 2
---

# --description--

While it is possible to note the type of a variable, this is redundant. You know that `10` is of type `int` and `3.14` is of type `double`. The Dart compiler is able to infer it thanks to __type inference__. Not all programming languages have _type inference_, and this makes Dart a very powerful programming language.

You can simply remove the type from the variables, for example:
```dart
const integerNumber = 2;
final decimalNumber = 3.14;
```

When the type of a variable is not explicitly noted, Dart will try to infer its type.

# --instructions--

Let Dart infer the type of the variable you will make as __compile-time constants__.

# --seed--

```dart
[/] a = 4;
[/] b = "Hello";
[/] c = false;
```

# --answers--

- const
- const
- const
- final
- final
- Const
- Final
- immutable

# --solutions--

```dart
const a = 4;
const b = "Hello";
const c = false;
```
