---
language: dart
exerciseType: 2
---

# --description--

Variables with explicit type can also be constants, just add the `const` or `final` keyword before the type:
```dart
const int integerNumber = 2;
final double decimalNumber = 3.14;
```

> Note: Mutable data allows you to change it whenever you want in an easy way. However, many experienced programmers appreciate the benefits of immutable data. When a value is immutable, you can trust that no one will be able to change the value after you create it. Limiting your data this way prevents many hard-to-find bugs and makes the program easier to think about and test.

# --instructions--

Make all variables _runtime constants_.

# --seed--

```dart
[/] int a = 4;
[/] String b = "Hello";
[/] bool c = false;
```

# --answers--

- const
- final
- const
- const
- final
- final
- Const
- Final
- immutable

# --solutions--

```dart
final int a = 4;
final String b = "Hello";
final bool c = false;
```
