---
language: dart
exerciseType: 2
---

# --description--

Sometimes you might have a variable with a generic type, but you need functionality that only exists in a subtype. If you are sure that the type of the variable is the subtype you need, then you can use the `as` keyword to change its type. This prodecure is also known as __type casting__, here is an example:

```dart
num number = 3;
```

Let's say we want to check if the number is even, and the functionality in question is present only on the `int` subtype.
```dart
print(number.isEven);
```

The code above should return you a type error:
> The getter `isEven` isn't defined for the type 'num'.

The `num` type is a too general type to know if a number is even or odd. Only integers can be even or odd.
The problem occurs if `num` contains a `double` value, since `num` includes both `double` and `int` types. In this case, we are sure that __3__ is an integer, so we can cast to `int`

```dart
final integer = number as int;
print(integer.isEven); // false
```

The `as` keyword causes the compiler to recognize the variable `integer` as having the type `int`. This allows you to use the `isEven` property which is present on integers. Since the number __3__ is not an integer, the result is false.

You have to wait when casting. If you incorrectly cast the type you will get a runtime error:
```dart
num numero = 3;
final decimale = numero as double;
```

This will crash the program with the following error:
> CastError (type 'int' is not a subtype of type 'double' in type cast)

The runtime type of `number` is `int` and not `double`. In Dart, you cannot cast with same-level types, such as `int` and `double`. You can only cast sub-types.

# --instructions--

Type-cast to make the variable `number` integer type and figure out if the number is odd.

# --seed--

```dart
const num number = 5;
final castedNum = [/][/][/];
print(castedNum.[/]);
```

# --answers--

- number
-  as 
- double
- String
- int
- isOdd
- isEven

# --solutions--

```dart
const num number = 5;
final castedNum = number as int;
print(castedNum.isOdd);
```

# --output--

true

