---
language: dart
exerciseType: 2
---

# --description--

In addition to these two ways of writing comments, Dart includes _documentation comments_.

_Documentation comments_ are multi-line or single-line comments that begin with `///` or `/**.` The use of `///` on consecutive lines has the same effect as a multi-line documentation comment.

_Documentation comments_ are very useful because they allow documentation to be generated. 
You will want to add _documentation comments_ to your code to make it clear what a particular block of code does.

Within a _documentation comment_, the analyser ignores all text unless it is enclosed in square brackets.
Using square brackets one can refer to _classes_, _methods_, _fields_, _variables_, _functions_ and _parameters_.

Here is an example:
```dart
/// A domesticated South American camelid (Lama glama).
///
/// Just like any other animal, llamas need to eat,
/// so don't forget to [feed] them some [Food].
class Llama {
  String? name;

  /// Feeds your llama [food].
  ///
  /// The typical llama eats one bale of hay per week.
  void feed(Food food) {
    // ...
  }

  /// Exercises your llama with an [activity] for
  /// [timeLimit] minutes.
  void exercise(Activity activity, int timeLimit) {
    // ...
  }
}
```

In the generated documentation, `[feed]` becomes a link to the documentation for the `feed` method, and `[Food]` becomes a link to the documentation for the `Food` class.
While `[activity]` and `[timeLimit]` become a link to the documentation for `activity` and `timeLimit` respectively.

# --instructions--

Uses _documentation comments_ correctly.

# --seed--

```dart
[/]
///
/// The [User] must always have a [name].
class User {
  [/]
  const User({
    required this.name,
  });

  [/]
  final String name;
}
```

# --answers--

- /// Identifies the user of the app.
- /// Constructor for creating a [User] with a given [name].
- /// Identifies the name of the user.
- /* Identifies the user of the app.
- /** Identifies the user of the app.
- // Identifies the user of the app.

# --solutions--

```dart
/// Identifies the user of the app.
///
/// The [User] must always have a [name].
class User {
  /// Constructor for creating a [User] with a given [name].
  const User({
    required this.name,
  });

  /// Identifies the name of the user.
  final String name;
}
```
