---
language: dart
exerciseType: 1
difficulty: 1
title: Arithmetic mean
---

# --description--

Write a function called `mean` to find the _arithmetic average_ of a numeric vector.

# --instructions--

Write a function that returns the mean of a numeric vector.

Example of function call:
```dart
print(mean([1, 2, 3]));
// prints 2.0
```

# --seed--

```dart
num mean() {
  
}
```

# --before-asserts--

```dart
import 'package:dart_runner/main.dart';
import 'package:test/test.dart';

void main() {
  group('MainTest -', () {
```

# --asserts--

The mean of `[1, 2, 3, 4, 5, 6, 7]` must be equal to 4.0

```dart
  test('test1', () {
    expect(mean([1, 2, 3, 4, 5, 6, 7]), 4.0, reason: '--err-t1--');
  });
```

The mean of `[4, 5, 6]` must be equal to 5.0

```dart
  test('test2', () {
    expect(mean([4, 5, 6]), 5.0, reason: '--err-t2--');
  });
```

The mean of `[12, 34, 56, 78]` must be equal to 45.0

```dart
  test('test3', () {
    expect(mean([12, 34, 56, 78]), 45.0, reason: '--err-t3--');
  });
```

# --after-asserts--

```dart
  }, timeout: Timeout(const Duration(seconds: 1)));
}
```

# --solutions--

```dart
num mean(List<num> numbers) {
  return numbers.reduce((prev, next) => prev + next) / numbers.length;
}
```
