---
language: c
exerciseType: 2
---

# --description--

Often in programming, we need to repeat a block of code, for example:
```c
printf("2 seconds\n");
printf("3 seconds\n");
printf("4 seconds\n");
printf("5 seconds\n");
```
This produces the following output:
```c
2 seconds
3 seconds
4 seconds
5 seconds
```
Obviously, for long statements we would spend a lot of time writing the code, but fortunately, we can use loops.
Let's learn the `while` loop, getting the same output above.
```c
int count = 2;
while (count <= 5) {
    printf("%d seconds\n", count);
    count++;
}
```
So we created a variable `count` assigning `2`, the initial value.
Then we have used the `while` statement that will run the block of code until the condition `count <= 5` is `true`.
Inside the block of code, we should **NOT** miss to add the line `count++;`.
It increments the `count` value, otherwise, our loop will be infinite

# --instructions--

Fill in the blanks with the `while` loop to repeat the block of code

# --seed--

```c
[/] (true) {
    printf("repeat\n");
}
```

# --answers--

- while
- "while"
- for
- loop

# --solutions--

```c
while (true) {
    printf("repeat\n");
}
```

# --output--

repeat
repeat
repeat
repeat
...
