---
language: c
exerciseType: 2
---

# --description--

Functions can have multiple input parameters, which are written within the function's parentheses, separated by commas.
```c
void say_hello(char *name, bool new_user) {
  char greet[40] = "Hello ";
  strcat(greet, name);
  if (new_user) {
    strcat(greet, "! Welcome on board :)");
  }
  printf("%s\n", greet);
}

int main() {
    // prints "Hello Tom"
    say_hello("Tom", true);
    return 0;
};
```

# --instructions--

Complete the code in order to create a valid function called `say_hello` passing `true` to the second parameter and print the result

# --seed--

```c
void [/](char *name, [/][/]) {
    char greet[40] = "Hello ";
    // used to concatenate the strings
    strcat(greet, name);
    if (new_user) {
      strcat(greet, "! Welcome on board :)");
    }
    printf("%s\n", greet);
}

int main() {
    say_hello("Smith", true);
    return 0;
}
```

# --answers--

- say_hello
- bool 
- string 
- new_user

# --solutions--

```c
void say_hello(char *name, bool new_user) {
    char greet[40] = "Hello ";
    // used to concatenate the strings
    strcat(greet, name);
    if (new_user) {
      strcat(greet, "! Welcome on board :)");
    }
    printf("%s\n", greet);
}

int main() {
    say_hello("Smith", true);
    return 0;
}
```

# --output--

Hello Tom! Welcome on board :)
