---
language: c
exerciseType: 2
---

# --description--

You might have considered the situation where you would like to reuse a piece of code, just with a few different values.
Instead of rewriting the whole code, it's much cleaner to define a function, which can then be used repeatedly.
In C we use the `return_type` followed by the `function` name, for example:
```c
void say_hello() {
    printf("Hello!\n");
}

int main() {
    say_hello();
    // prints "Hello!"
    return 0;
}
```

# --instructions--

Complete the code in order to create a valid function called `say_hello` to a specific name

# --seed--

```c
[/][/]([/]*name) {
    printf("Hello [/]!\n", name);
}

int main() {
    say_hello([/]);
    return 0;
}
```

# --answers--

- void 
- say_hello
- char 
- string 
- %s
- %c
- name
- *name
- "Tom"

# --solutions--

```c
void say_hello(char *name) {
    printf("Hello %s!\n", name);
}

int main() {
    say_hello("Tom");
    return 0;
}
```

# --output--

Hello Tom!
