import React, { useEffect, useState } from "react";
import style from "./Nav.module.css";
import CustomNavLink from "./CustomNavLink";
import useFetchWrapper from "../../utils/fetchWrapper";

export default function Nav() {
  const [summary, setSummary] = useState(null);
  const [loading, setLoading] = useState(true);
  const fetchFunction = useFetchWrapper();

  useEffect(() => {
    const getSummary = async () => {
      try {
        const response = await fetchFunction({
          url: "/api/notifications/summary",
        });
        const data = await response.json();
        if (data.HAS === true) {
          setSummary(data.SUMMARY);
        }
      } catch (error) {}
      setLoading(false);
    };
    if (loading) {
      getSummary();
    }
  }, [summary]);

  return (
    <div className={`${style.navOuter} d-flex justify-content-center`}>
      <div
        className={`${style.innerNav} d-flex justify-content-between align-items-center`}
      >
        <CustomNavLink
          path="/"
          svg={
            <path d="M575.8 255.5c0 18-15 32.1-32 32.1h-32l.7 160.2c0 2.7-.2 5.4-.5 8.1V472c0 22.1-17.9 40-40 40H456c-1.1 0-2.2 0-3.3-.1c-1.4 .1-2.8 .1-4.2 .1H416 392c-22.1 0-40-17.9-40-40V448 384c0-17.7-14.3-32-32-32H256c-17.7 0-32 14.3-32 32v64 24c0 22.1-17.9 40-40 40H160 128.1c-1.5 0-3-.1-4.5-.2c-1.2 .1-2.4 .2-3.6 .2H104c-22.1 0-40-17.9-40-40V360c0-.9 0-1.9 .1-2.8V287.6H32c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L564.8 231.5c8 7 12 15 11 24z" />
          }
        />
        <CustomNavLink
          path="/user"
          svg={
            <path d="M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512H418.3c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304H178.3z" />
          }
        />
        <CustomNavLink
          path="/notifications"
          svg={
            <path d="M224 0c-17.7 0-32 14.3-32 32V51.2C119 66 64 130.6 64 208v18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4S19.4 416 32 416H416c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C401.3 319.2 384 273.9 384 226.8V208c0-77.4-55-142-128-156.8V32c0-17.7-14.3-32-32-32zm45.3 493.3c12-12 18.7-28.3 18.7-45.3H224 160c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7z" />
          }
          summary={true}
          summaryValue={summary}
        />
        <CustomNavLink
          path="/search"
          svg={
            <path d="M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM208 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288z" />
          }
        />

        <CustomNavLink
          path="/create"
          svg={
            <path d="M256 80c0-17.7-14.3-32-32-32s-32 14.3-32 32V224H48c-17.7 0-32 14.3-32 32s14.3 32 32 32H192V432c0 17.7 14.3 32 32 32s32-14.3 32-32V288H400c17.7 0 32-14.3 32-32s-14.3-32-32-32H256V80z" />
          }
        />
      </div>
    </div>
  );
}
