import React, { useContext, useEffect, useRef, useState } from "react";
import style from "../styles/Post.module.css";
import useFetchWrapper from "../../../utils/fetchWrapper";
import likingContext from "./context/likingContext";

export default function Dislike({ id, counter }) {
  const [totalDislikes, setTotalDisLikes] = counter;

  const fetchFunction = useFetchWrapper();
  const dislikebutton = useRef(null);
  const { likingState, setLikingStateWrapper } = useContext(likingContext);

  const likingHandle = async () => {
    dislikebutton.current.disabled = true;

    const action = likingState.disliked ? "undislike" : "dislike";

    try {
      const response = await fetchFunction({
        url: "/api/post/dislike",
        method: "post",
        body: JSON.stringify({
          action: action,
          user: 1,
          post: id,
        }),
      });

      const data = await response.json();
      if (data.status === "success") {
        if (action === "dislike") {
          setTotalDisLikes((pre) => pre + 1);
        } else {
          setTotalDisLikes((pre) => pre - 1);
        }
        setLikingStateWrapper("dislike", !likingState.disliked);
      } else {
      }
    } catch (error) {}
    dislikebutton.current.disabled = false;
  };

  return (
    <>
      <button
        ref={dislikebutton}
        className={`${style.interaction} ${
          likingState.disliked && style.likedButton
        }`}
        onClick={likingHandle}
      >
        <svg
          xmlns="http://www.w3.org/2000/svg"
          height="16"
          width="16"
          viewBox="0 0 512 512"
        >
          <path d="M313.4 479.1c26-5.2 42.9-30.5 37.7-56.5l-2.3-11.4c-5.3-26.7-15.1-52.1-28.8-75.2H464c26.5 0 48-21.5 48-48c0-18.5-10.5-34.6-25.9-42.6C497 236.6 504 223.1 504 208c0-23.4-16.8-42.9-38.9-47.1c4.4-7.3 6.9-15.8 6.9-24.9c0-21.3-13.9-39.4-33.1-45.6c.7-3.3 1.1-6.8 1.1-10.4c0-26.5-21.5-48-48-48H294.5c-19 0-37.5 5.6-53.3 16.1L202.7 73.8C176 91.6 160 121.6 160 153.7V192v48 24.9c0 29.2 13.3 56.7 36 75l7.4 5.9c26.5 21.2 44.6 51 51.2 84.2l2.3 11.4c5.2 26 30.5 42.9 56.5 37.7zM32 384H96c17.7 0 32-14.3 32-32V128c0-17.7-14.3-32-32-32H32C14.3 96 0 110.3 0 128V352c0 17.7 14.3 32 32 32z" />
        </svg>

        <span className={style.interactionNumber}>({totalDislikes})</span>
      </button>
    </>
  );
}
