import React from "react";
import Main from "../../hoc/layout/Main/Main";

export default function CategoriesMain() {
  return (
    <>
      <Main>
        <h1>Content Categories</h1>
        <p>
          At Sociiity, we have organized our entire content into specific
          categories, and we strictly enforce content submissions within these
          categories.
        </p>
        <p>Below is a comprehensive list of all the allowed categories:</p>
        <h2>1. Negligence in Duty (ڈیوٹی میں غفلت)</h2>
        <p>
          This category is dedicated to addressing situations where individuals
          fail to fulfill their responsibilities.
        </p>

        <p>
          For example, you can use this category to post about instances such as
          an electricity officer not addressing issues or taking appropriate
          actions, a police officer neglecting their duties, a private service
          provider failing to deliver, or any other person not fulfilling their
          job responsibilities.
        </p>
        <p>
          In simpler terms, if someone is not doing their job properly, you can
          share your experiences or concerns in this category.
        </p>
        <p className="highlighNote">
          <span className="font-weight-bold">Note: </span>
          Make your you have strong evidence for this type of posts.
        </p>
        <h2>2. Bribery Incident (رشوت)</h2>
        <p>
          This category is intended for reporting incidents involving
          individuals who are demanding bribes from you.
        </p>
        <p>
          For example, if a clerk is asking for a bribe to resolve
          salary-related issues, if a police officer is demanding a bribe, or if
          anyone else is making unwarranted requests for bribes, you can share
          your experiences in this category.
        </p>
        <p className="highlighNote">
          <span className="font-weight-bold">Note: </span>
          Make your you have strong evidence for this type of posts.
        </p>
        <h2>3. Fraudulent Activity (دھوکہ دہی)</h2>
        <p>
          This category is designated for reporting instances where someone has
          engaged in fraudulent activities against you.
        </p>
        <p>
          Fraud can occur in various forms, both in the physical world and
          online.
        </p>
        <p>For example:</p>
        <ul>
          <li>
            <p>
              If you purchased a product online, but it turned out to be fake or
              misrepresented.
            </p>
          </li>
          <li>
            <p>If you were misled into investing in a fraudulent scheme.</p>
          </li>
          <li>
            <p>
              If someone tricked you into sharing personal information for
              malicious purposes.
            </p>
          </li>
        </ul>
        <p>
          Feel free to share your experiences related to fraudulent activities
          in this category, whether they involve physical or online incidents.
        </p>
        <p className="highlighNote">
          <span className="font-weight-bold">Note: </span>
          Make your you have strong evidence for this type of posts.
        </p>

        <h2>4. Harassment Case (ہراساں کرنا)</h2>
        <p>
          This category is for addressing incidents of harassment, particularly
          relevant for females. If you experience harassment at your workplace,
          educational institution, or any other location, feel free to share
          your concerns in this category.
        </p>
        <p className="highlighNote">
          <span className="font-weight-bold">Note: </span>
          Make your you have strong evidence for this type of posts.
        </p>

        <h2>5. Corruption</h2>
        <p>You can post any type of corruption under this category.</p>
        <p className="highlighNote">
          <span className="font-weight-bold">Note: </span>
          Make your you have strong evidence for this type of posts.
        </p>
        <h2>6. Bullying (غنڈہ گردی)</h2>
        <p>
          This category is for reporting situations where someone tries to
          scare, intimidate, or physically harm you without any good reason. It
          covers incidents like bullying, beating, or any unwarranted
          aggression, whether it happens in your neighborhood or anywhere else.
        </p>
      </Main>
    </>
  );
}
