
### 下载模型，放置于models目录
- 链接: https://pan.baidu.com/s/1pGHMzUH5Kyc_LhTDRc-laA?pwd=amfh

### AI 训练平台
AI训练平台提供分类模型训练能力。并以REST API形式为上层应用提供接口。
当前版包含功能如下：
-分类模型训练 （imagenet数据集预训练的resnet50模型）
-模型训练可视化
-图片分类推理
-图片特征提取（512维特征）
-图片 1:1 比对

## 前端部署

#### nginx部署运行：
```bash
cd /usr/local/etc/nginx/
vi /usr/local/etc/nginx/nginx.conf
# 编辑nginx.conf

    server {
        listen       8080;
        server_name  localhost;

        location / {
            root   /Users/calvin/platform/dist/;
            index  index.html index.htm;
        }
     ......
     
# 重新加载配置：
sudo nginx -s reload 

# 部署应用后，重启：
cd /usr/local/Cellar/nginx/1.19.6/bin

# 快速停止
sudo nginx -s stop

# 启动
sudo nginx     
```

#### 配置hosts文件：
```bash
# 客户端(浏览器)机器的hosts文件添加映射< 127.0.0.1	train.aias.me>, 
# 其中127.0.0.1替换成jar包运行的服务器ip地址

127.0.0.1	train.aias.me
```

## 后端部署
```bash
# 编译 & 运行程序
java -jar aais-platform-train-0.1.0.jar

```

## 打开浏览器

输入地址： http://localhost:8080

#### 1. 训练数据准备-ZIP格式压缩包:
压缩包内需包含2个目录（名字需严格一致）：    
-TRAIN ：包含训练数据，每个文件夹对应一个分类（每个分类图片数量尽量保持平衡）    
-VALIDATION ：包含验证数据，每个文件夹对应一个分类

![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/folder.png)

-[320张车辆图片测试数据下载](https://pan.baidu.com/s/1Mcj3r097M0m7VnZWfpEm3g?pwd=7vpq)   

#### 2. 上传数据并开始训练:
-选择zip文件并上传
-点击训练按钮开始训练
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/storage.png)

#### 3. 查看训练过程:  
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/training.png)
  
#### 4. 图片分类测试:  
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/classification.png)
  
#### 5. 特征提取测试: 
图片特征提取使用的是新训练的模型。特征来自模型的特征提取层。 
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/feature.png)

#### 6. 图片比对测试:  
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/comparision.png)

#### 7. API文档： 
http://127.0.0.1:8089/swagger-ui.html
![Screenshot](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/train_platform/images/swagger.png)
  
#### 编辑jar包中的application.yml
根据需要编辑application.yml中的图片上传路径,模型保存路径
（windows环境可以使用7-zip直接编辑，无需对jar包解压缩重新压缩）
```bash
# 文件存储路径
file:
  mac:
    path: ~/file/
    imageRootPath: ~/file/image_root/ #压缩包解压缩文件夹
    newModelPath: ~/file/model/ #模型训练好后存放的文件夹
  linux:
    path: /home/aias/file/
    imageRootPath: /home/aias/file/image_root/ #压缩包解压缩文件夹
    newModelPath: /home/aias/file//model/ #模型训练好后存放的文件夹
  windows:
    path: C:\aias\file\
    imageRootPath: C:\aias\file\image_root\ #压缩包解压缩文件夹
    newModelPath: C:\aias\file\modelv2\ #模型训练好后存放的文件夹
  # 文件大小 /M
  maxSize: 3000
```


### 官网：
[官网链接](http://www.aias.top/)

### Git地址：   
[Github链接](https://github.com/mymagicpower/AIAS)    
[Gitee链接](https://gitee.com/mymagicpower/AIAS)   



#### 帮助文档：
- http://aias.top/guides.html
- 1.性能优化常见问题:
- http://aias.top/AIAS/guides/performance.html
- 2.引擎配置（包括CPU，GPU在线自动加载，及本地配置）:
- http://aias.top/AIAS/guides/engine_config.html
- 3.模型加载方式（在线自动加载，及本地配置）:
- http://aias.top/AIAS/guides/load_model.html
- 4.Windows环境常见问题:
- http://aias.top/AIAS/guides/windows.html

