# 解析npy/npz文件
在NumPy中提供了多种文件操作函数，我们可以通过这些文件操作函数，快速地对nump数组进行存取，
在python环境使用十分方便，但是如何在java中读取呢？
本sdk的作用就是说明如何读取python numpy保存的npz、npy文件。

![img](https://aias-home.oss-cn-beijing.aliyuncs.com/AIAS/nlp_sdks/numpy.png)

### 功能：
- 读取npy
- 读取npz

#### 运行例子 NpyNpzExample 
运行成功后，命令行应该看到下面的信息:
```text
[INFO ] - npy读取测试: 
[INFO ] - [0.22508514, 0.04280323, 0.19131854]
[INFO ] - [0.45975712, 0.40147442, 0.79315627]
[INFO ] - [0.5796399, 0.7162576, 0.5530666]

[INFO ] - npz读取测试: 
[INFO ] - 数组名: a1
[INFO ] - [0.97348356, 0.8709949, 0.39316362]
[INFO ] - [0.91646147, 0.97359747, 0.033147745]
[INFO ] - [0.847903, 0.6300699, 0.18596496]
[INFO ] - 数组名: a2
[INFO ] - [0.17477338, 0.47092265, 0.88105553, 0.83607906]
[INFO ] - [0.5729625, 0.26714775, 0.22172394, 0.9828551]
[INFO ] - [0.5134504, 0.64939636, 0.7347055, 0.23717967]
[INFO ] - [0.9169525, 0.5242542, 0.38289344, 0.5917738]

 ```

### 帮助
在NumPy中提供了多种文件操作函数，我们可以通过这些文件操作函数，快速地对nump数组进行存取，
十分方便，本节我们来介绍如何生成和读取npz、npy文件:

#### np.save()函数
**np.save()**函数可以存储一个np.array()数组，并生成npy文件。

```text
import numpy as np

array = np.random.rand(3, 3)

# 储存数组
np.save('/Users/calvin/data.npy',array)

print(array)
# 输出：
[[0.22508514 0.04280323 0.19131854]
 [0.45975712 0.40147442 0.79315626]
 [0.57963991 0.7162576  0.5530666 ]]
 ```
 
#### np.savez()函数 
如果需要存储多个数组，我们需要用到np.savez()函数。savez函数的第一个参数是文件名，
其后的参数都是需要保存的数组，也可以使用关键字参数为数组起一个名字，非关键字参数传递的数组会自动起名为arr_0, arr_1, …。 

```text
import numpy as np

array1 = np.random.rand(3, 3)
array2 = np.random.rand(4, 4)

# 储存数组
np.savez('/Users/calvin/data.npz',a1 = array1, a2 = array2)

print(array1)
# 输出：
[[0.97348357 0.87099493 0.39316362]
 [0.91646146 0.97359747 0.03314774]
 [0.84790304 0.63006991 0.18596496]]
print(array2)
# 输出：
[[0.17477338 0.47092266 0.88105552 0.83607907]
 [0.57296254 0.26714775 0.22172394 0.98285511]
 [0.51345037 0.64939636 0.73470548 0.23717967]
 [0.91695247 0.52425418 0.38289345 0.5917738 ]]
 ```
 
 ### 官网：
 [官网链接](http://www.aias.top/)
 
 ### Git地址：   
 [Github链接](https://github.com/mymagicpower/AIAS)    
 [Gitee链接](https://gitee.com/mymagicpower/AIAS)   
