<div align="center">
  <a href="http://aias.top/">点击返回网站首页</a>
</div>  


#### 性能优化常见问题


1. 是否支持多线程？
```text
答：支持多线程，每个线程一个predictor。
```

2. 多线程环境，设置多少个predictor合适？
```text
答：一般单机有多个predictor，predictor数目可以和核心数相同，这样请求来了就可以打满。但是如果并发数超过单机核心数，而且没法批处理，那么这时候多机会派上用场帮忙分流... 
```

3. 创建多个predictor，做一个推理实例池，有意义吗？
```text
答：推理实例池要看你们的调用，每个机器都有自己的物理算力极限。
建议先测试下多线程环境下单机能够达到最大的吞吐量和延迟。
这里实例池的作用就是**限制并发数**，同一个模型只加载一份，所以没有加载开销。
```

4. 多线程环境 translator, predictor 线程安全如何保证的？
```text
答：Translator这个是个interface，用户自己实现的，线程安全需要用户自己保证。如果多线程调用predictor，predictor会多线程调用translator的function。ctx的那个manager是随预处理开始产生，后处理结束自动销毁，帮助用户清理输入和输出ndarray用的。
```

5. 多线程环境，并行数如何设置？
```text
答：深度学习框架默认的并行数就是核心的数目。
比如：单机两个gpu，模型需要load两份，一份load在gpu0，一份在gpu1
之后从两个model分别开多个predictor，每个predictor会绑定在最初model读到的gpu设备上。
此时因为CPU计算量变小，可以开多于CPU核心数的线程（具体多少看GPU性能）。
具体数字多少，可以测试多线程推理，什么时候gpu或者cpu利用率打满。
https://docs.djl.ai/extensions/benchmark/index.html
为此之前很多用户都要一个能够测物理极限的工具，djl提供了一个专门测试多线程吞吐量和延迟的。
```

6. 多个predictor如果使用GPU，会占用多份显存（一个实例大约一个模型的存储）吗（或者CPU占用多份内存）？
```text
答：DJL从0.9.0版本开始，可以保证 tf/mx/pt 三个框架多线程使用时不会额外复制模型。相当于是就算你开100个线程，内存里也只有一个模型的占用，GPU也是同理。
**这算是一个多线程推理吊打python的多进程推理的核心优势。**
    从0.10.0开始，从一个model创建的多个predictor会共享一份模型内存，不会造成过多占用。
    所以，Model可以复用，如果是要多线程下使用，建议建立多个predictor，每个线程一个predictor这
    样用但是最近几版predictor本身也是线程安全的，你直接多线程复用一个也不会出问题。
```

7. 一个GPU的一份model，如果没有其它模型的话，是不会再继续占用显存了吗（不管创建多少个predictor）？
```text
答：模型本身不会，但是目前深度学习框架配置不太好，就算没用那么多显存，只要在gpu上做运算，会强制占用很多显存资源用来塞临时计算数据或者就放着... 
那么什么时候有问题：
1). 你在一个gpu上同时使用两个深度学习引擎，比如tf和pt。那么它们会争夺显存资源而打架…
2). 系统有多进程在使用同一个gpu，进程间的深度学习引擎也会打架…

举个例子：比如我有一个模型 600mb大，然后在一张单卡 8gb显存上跑，可能你会发现这个进程占用了超过6g的显存... 但是实际用量比这个少得多。
```


补充说明：
```text
1. 性能调优文档
   http://docs.djl.ai/docs/development/inference_performance_optimization.html

2. Java本身是多线程的，DJL其实也是调用了相关引擎的C++ API。多线程本身知识就不赘述了，我们在调用这些api上下了点功夫，保证使用过程是线程安全的。推理任务来了以后，每个线程同时调用这个C++ API。然后到底层每个cpu核心会操作一个请求，每个核心之前计算是互不影响的，之后处理完返回到java端。

3. pytorch mxnet tensorflow都有指定多少核心算子可以调用的参数。

4. graph在推理时是read only的，每个核心去使用内存计算相互结果不影响，所以最后也没事。
```



<div align="center">
  <a href="http://aias.top/">点击返回网站首页</a>
</div>  

