<div align="center">
  <a href="http://aias.top/AIAS/guides/tutorials/ndarray/index.html">点击返回目录</a>
</div>  


### NDArray IO

#### 1. 将数组保存到以 .npy 为扩展名的文件
- Python
Numpy 可以读写磁盘上的文本数据或二进制数据。
NumPy 为 ndarray 对象引入了一个简单的文件格式：npy。
npy 文件用于存储重建 ndarray 所需的数据、图形、dtype 和其他信息。
常用的 IO 函数有：
load() 和 save() 函数是读写文件数组数据的两个主要函数，默认情况下，数组是以未压缩的原始二进制格式保存在扩展名为 .npy 的文件中。
savez() 函数用于将多个数组写入文件，默认情况下，数组是以未压缩的原始二进制格式保存在扩展名为 .npz 的文件中。

```text
import numpy as np 
 
a = np.array([1,2,3,4,5]) 
 
# 保存到 outfile.npy 文件上
np.save('outfile.npy',a) 

# 我们可以查看文件内容：
$ cat outfile.npy 
?NUMPYv{'descr': '<i8', 'fortran_order': False, 'shape': (5,), }  

# 可以看出文件是乱码的，因为它们是 Numpy 专用的二进制格式后的数据。
```

- Java
```text
NDArray a = manager.create(new int[]{1,2,3,4,5});
NDList encoded = new NDList(a);
encoded.encode();
OutputStream os = Files.newOutputStream(Paths.get("src/test/resources/outfile.npy"));
encoded.encode(os, true);

# 输出结果如下：
src/test/resources/outfile.npy
```

#### 2. 读取 .npy 文件
- Python
我们可以使用 load() 函数来读取数据就可以正常显示了：
```text
import numpy as np 
 
b = np.load('outfile.npy')  
print (b)

# 输出结果如下：
[1 2 3 4 5]
```

- Java
```text
byte[] data = readFile("arr.npy");
NDList decoded = NDList.decode(manager, data);
NDArray array = decoded.get(0);
System.out.println(array.toDebugString(100, 10, 100, 100));

# 输出结果如下：
ND: (5) cpu() int32
[ 1,  2,  3,  4,  5]
```

#### 3. 将多个数组保存到以 npz 为扩展名的文件
- Python
numpy.savez() 函数将多个数组保存到以 npz 为扩展名的文件中。

```text
import numpy as np 
 
a = np.array([[1,2,3],[4,5,6]])
b = np.arange(0, 1.0, 0.1)

np.savez("runoob.npz", a, b)

# 输出结果如下：
runoob.npz
```

- Java
```text
a = manager.create(new int[][]{{1, 2, 3}, {4, 5, 6}});
NDArray b = manager.arange(0f, 1f, 0.1f);
encoded = new NDList(a, b);
encoded.encode();
os = Files.newOutputStream(Paths.get("src/test/resources/runoob.npz"));
encoded.encode(os, true);
        
# 输出结果如下：
src/test/resources/runoob.npz
```

#### 4. 读取 npz 文件
- Python
```text
import numpy as np 

r = np.load("runoob.npz")  
print(r.files) # 查看各个数组名称
print(r["arr_0"]) # 数组 a
print(r["arr_1"]) # 数组 b

# 输出结果如下：
['sin_array', 'arr_0', 'arr_1']
[[1 2 3]
 [4 5 6]]
[0.  0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9]
```

- Java
```text
data = readFile("runoob.npz");
decoded = NDList.decode(manager, data);
a = decoded.get(0);
b = decoded.get(1);
System.out.println(a.toDebugString(100, 10, 100, 100));
System.out.println(b.toDebugString(100, 10, 100, 100));
       
# 输出结果如下：
ND: (2, 3) cpu() int32
[[ 1,  2,  3],
 [ 4,  5,  6],
]

ND: (10) cpu() float32
[0. , 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9]

```



### 代码下载地址：    
[Github链接](https://github.com/mymagicpower/AIAS/blob/main/0_tutorials/ndarray_lessons/src/main/java/me/aias/example/No10IOExample.java)    

[Gitee链接](https://gitee.com/mymagicpower/AIAS/blob/main/0_tutorials/ndarray_lessons/src/main/java/me/aias/example/No10IOExample.java)   


<div align="center">
  <a href="http://aias.top/AIAS/guides/tutorials/ndarray/index.html">点击返回目录</a>
</div>  
