/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.webrtcvadwrapper.audio;

import java.util.List;
import org.jitsi.webrtcvadwrapper.audio.AudioSegment;

public class ByteSignedPcmAudioSegment
implements AudioSegment {
    private byte[] audio;

    private static int[] convertByteArrayTo16bitIntArray(byte[] audio) {
        int[] converted = new int[audio.length / 2];
        int i = 0;
        while (i < converted.length) {
            byte b1 = audio[i * 2];
            byte b2 = audio[i * 2 + 1];
            converted[i] = b1 | b2 << 8;
            ++i;
        }
        return converted;
    }

    public static ByteSignedPcmAudioSegment merge(List<ByteSignedPcmAudioSegment> segments) {
        int totalLength = 0;
        int i = 0;
        while (i < segments.size()) {
            totalLength += segments.get(i).getAudio().length;
            ++i;
        }
        byte[] merged = new byte[totalLength];
        int marker = 0;
        for (ByteSignedPcmAudioSegment segment : segments) {
            byte[] audio = segment.getAudio();
            System.arraycopy(audio, 0, merged, marker, audio.length);
            marker += audio.length;
        }
        return new ByteSignedPcmAudioSegment(merged);
    }

    public ByteSignedPcmAudioSegment(byte[] audio) {
        this.audio = audio;
    }

    @Override
    public int[] to16bitPCM() {
        return ByteSignedPcmAudioSegment.convertByteArrayTo16bitIntArray(this.audio);
    }

    public byte[] getAudio() {
        return this.audio;
    }
}

