/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.webrtcvadwrapper;

import java.util.Arrays;
import org.jitsi.webrtcvadwrapper.Exceptions.NativeLibraryException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedSampleRateException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedSegmentLengthException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedVadModeException;
import org.jitsi.webrtcvadwrapper.Exceptions.VadClosedException;
import org.jitsi.webrtcvadwrapper.JNIUtils;

public class WebRTCVad {
    public static final int[] VALID_VAD_MODES;
    public static final int[] VALID_SAMPLE_RATES;
    private long nativeVadPointer;
    private final int[] validAudioSampleLengths;

    static {
        block4: {
            try {
                String os = System.getProperty("os.name");
                if (os.toLowerCase().contains("linux")) {
                    JNIUtils.loadLibrary("fvad", WebRTCVad.class);
                    JNIUtils.loadLibrary("webrtcvadwrapper", WebRTCVad.class);
                    break block4;
                }
                if (os.toLowerCase().startsWith("win")) {
                    JNIUtils.loadLibrary("libfvad", WebRTCVad.class);
                    JNIUtils.loadLibrary("libwebrtcvadwrapper", WebRTCVad.class);
                    break block4;
                }
                throw new Exception("Unsupported OS: " + os);
            }
            catch (Exception e) {
                System.out.println("Error loading native library: " + e);
            }
        }
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        VALID_VAD_MODES = nArray;
        VALID_SAMPLE_RATES = new int[]{8000, 16000, 32000, 48000};
    }

    public static boolean isValidVadMode(int mode) {
        return Arrays.stream(VALID_VAD_MODES).anyMatch(validMode -> validMode == mode);
    }

    public static boolean isValidSampleRate(int sampleRate) {
        return Arrays.stream(VALID_SAMPLE_RATES).anyMatch(rate -> rate == sampleRate);
    }

    public static int[] getValidAudioSegmentLengths(int sampleRate) throws UnsupportedSampleRateException {
        if (!WebRTCVad.isValidSampleRate(sampleRate)) {
            throw new UnsupportedSampleRateException(sampleRate, VALID_SAMPLE_RATES);
        }
        int ms10Length = sampleRate / 100;
        return new int[]{ms10Length, ms10Length * 2, ms10Length * 3};
    }

    public static int[] convertPCMAudioTo16bitInt(double[] doubleArray) {
        int[] intArray = new int[doubleArray.length];
        int i = 0;
        while (i < doubleArray.length) {
            intArray[i] = WebRTCVad.convertDoubleToSigned16BitInt(doubleArray[i]);
            ++i;
        }
        return intArray;
    }

    public static int convertDoubleToSigned16BitInt(double d) {
        if ((d *= 32768.0) > 32767.0) {
            d = 32767.0;
        } else if (d < -32768.0) {
            d = -32768.0;
        }
        return (int)d;
    }

    public WebRTCVad(int sampleRate, int mode) throws UnsupportedSampleRateException, UnsupportedVadModeException {
        if (!WebRTCVad.isValidSampleRate(sampleRate)) {
            throw new UnsupportedSampleRateException(sampleRate, VALID_SAMPLE_RATES);
        }
        if (!WebRTCVad.isValidVadMode(mode)) {
            throw new UnsupportedVadModeException(mode, VALID_VAD_MODES);
        }
        this.validAudioSampleLengths = WebRTCVad.getValidAudioSegmentLengths(sampleRate);
        this.nativeOpen(sampleRate, mode);
    }

    protected void finalize() throws Throwable {
        this.nativeClose();
    }

    private native void nativeOpen(int var1, int var2);

    private native void nativeClose();

    private native boolean nativeIsOpen();

    private native int nativeIsSpeech(int[] var1);

    public boolean isSpeech(int[] audioSample) throws UnsupportedSegmentLengthException, NativeLibraryException, VadClosedException {
        if (!this.nativeIsOpen()) {
            throw new VadClosedException();
        }
        if (!this.isValidLength(audioSample)) {
            throw new UnsupportedSegmentLengthException(audioSample.length, this.validAudioSampleLengths);
        }
        int result = this.nativeIsSpeech(audioSample);
        if (result < 0) {
            throw new NativeLibraryException();
        }
        return result == 1;
    }

    public boolean isSpeech(double[] audioSample) throws UnsupportedSegmentLengthException, NativeLibraryException, VadClosedException {
        return this.isSpeech(WebRTCVad.convertPCMAudioTo16bitInt(audioSample));
    }

    protected boolean isValidLength(int[] audioSegment) {
        return this.isValidLength(audioSegment.length);
    }

    protected boolean isValidLength(int length) {
        return Arrays.stream(this.validAudioSampleLengths).anyMatch(validLength -> validLength == length);
    }
}

