/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.webrtcvadwrapper;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedSampleRateException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedSegmentLengthException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedThresholdException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedVadModeException;
import org.jitsi.webrtcvadwrapper.Exceptions.UnsupportedWindowSizeException;
import org.jitsi.webrtcvadwrapper.WebRTCVad;
import org.jitsi.webrtcvadwrapper.audio.AudioSegment;

public class SpeechDetector<T extends AudioSegment> {
    private final WebRTCVad vad;
    private final CircularFifoQueue<T> window;
    private final int segmentSize;
    private final int threshold;
    private final int windowSizeInSegments;
    private final int sampleRate;
    private int speechSegmentCount = 0;

    public SpeechDetector(int sampleRate, int vadMode, int segmentSizeInMs, int windowSizeInMs, int threshold) throws UnsupportedSampleRateException, UnsupportedVadModeException, UnsupportedSegmentLengthException, UnsupportedWindowSizeException, UnsupportedThresholdException {
        this.vad = new WebRTCVad(sampleRate, vadMode);
        this.sampleRate = sampleRate;
        this.segmentSize = (int)((double)sampleRate * ((double)segmentSizeInMs / 1000.0));
        if (!this.vad.isValidLength(this.segmentSize)) {
            throw new UnsupportedSegmentLengthException(this.segmentSize, WebRTCVad.getValidAudioSegmentLengths(sampleRate));
        }
        if (windowSizeInMs % segmentSizeInMs != 0 || windowSizeInMs < segmentSizeInMs) {
            throw new UnsupportedWindowSizeException(windowSizeInMs, segmentSizeInMs);
        }
        this.windowSizeInSegments = windowSizeInMs / segmentSizeInMs;
        this.window = new CircularFifoQueue(this.windowSizeInSegments * segmentSizeInMs);
        if (threshold < 0 || threshold > this.windowSizeInSegments) {
            throw new UnsupportedThresholdException(threshold, 0, this.windowSizeInSegments);
        }
        this.threshold = threshold;
    }

    public void nextSegment(T segmentHolder) {
        int[] segment = segmentHolder.to16bitPCM();
        if (segment.length != this.segmentSize) {
            throw new UnsupportedSegmentLengthException(segment.length, WebRTCVad.getValidAudioSegmentLengths(this.sampleRate));
        }
        this.speechSegmentCount = this.vad.isSpeech(segment) ? Math.min(this.windowSizeInSegments, this.speechSegmentCount + 1) : Math.max(0, this.speechSegmentCount - 1);
        this.window.add(segmentHolder);
    }

    public List<T> getLatestSegments() {
        return new ArrayList<T>(this.window);
    }

    public boolean isSpeech() {
        return this.speechSegmentCount >= this.threshold;
    }
}

