/*
 * Decompiled with CFR 0.152.
 */
package me.aias;

import com.github.houbb.pinyin.constant.enums.PinyinStyleEnum;
import com.github.houbb.pinyin.util.PinyinHelper;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.rnkrsoft.bopomofo4j.Bopomofo4j;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.aias.ConvertUtils;
import me.aias.NumberUtils;
import me.aias.PhonemeUtils;
import me.aias.SymbolUtils;

public class SequenceUtils {
    static Map<Integer, String> k;
    static Pattern D;
    static Map<String, Integer> ALLATORIxDEMO;

    public static List<Integer> phoneme2sequence(List<String> a) {
        ArrayList arrayList = Lists.newArrayList();
        for (String string : a) {
            if (!ALLATORIxDEMO.containsKey(string)) continue;
            arrayList.add(ALLATORIxDEMO.get(string));
        }
        return arrayList;
    }

    static {
        int n;
        D = Pattern.compile(ConvertUtils.ALLATORIxDEMO("M\u0015\u0004c\u001f\u000fH\u00148eL"));
        ALLATORIxDEMO = Maps.newHashMap();
        k = Maps.newHashMap();
        int n2 = SymbolUtils.c.length;
        int n3 = n = 0;
        while (n3 < n2) {
            ALLATORIxDEMO.put(SymbolUtils.c[n], n);
            k.put(n, SymbolUtils.c[n++]);
            n3 = n;
        }
    }

    public static List<Integer> text2sequence(String a) {
        return SequenceUtils.phoneme2sequence(SequenceUtils.text2phoneme(a));
    }

    static List<String> ALLATORIxDEMO(String a) {
        int n;
        ArrayList arrayList = Lists.newArrayList();
        String[] stringArray = a.split("");
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            String string = stringArray[n];
            if (PhonemeUtils.l.containsKey((Object)string)) {
                arrayList.add((String)PhonemeUtils.l.get((Object)string));
            }
            n3 = ++n;
        }
        return arrayList;
    }

    public static List<String> text2phoneme(String a) {
        a = SequenceUtils.A(a);
        a = SequenceUtils.ALLATORIxDEMO(a);
        List<String> list = SequenceUtils.pinyin2phoneme(SequenceUtils.text2pinyin(a));
        list = SequenceUtils.changeDiao(list);
        return list;
    }

    static String A(String a) {
        a = ConvertUtils.quan2ban(a);
        a = ConvertUtils.fan2jian(a);
        a = NumberUtils.convertNumber(a);
        return a;
    }

    public SequenceUtils() {
        SequenceUtils a;
    }

    static String ALLATORIxDEMO(String a) {
        Iterator<String> iterator = D.matcher(a);
        Object object = new LinkedList<Integer>();
        Object object2 = iterator;
        while (((Matcher)object2).find()) {
            Iterator<String> iterator2 = iterator;
            ((LinkedList)object).add(((Matcher)((Object)iterator)).start());
            object2 = iterator2;
            ((LinkedList)object).add(((Matcher)((Object)iterator2)).end());
        }
        if (((LinkedList)object).size() == 0) {
            return a;
        }
        iterator = Lists.newArrayList();
        iterator.add(a.substring(0, (Integer)((LinkedList)object).getFirst()));
        int n = ((LinkedList)object).size() - 1;
        int n2 = 0;
        int n3 = n2;
        while (n3 < n) {
            int n4 = (Integer)((LinkedList)object).get(n2);
            Integer n5 = (Integer)((LinkedList)object).get(n2 + 1);
            iterator.add(a.substring(n4, n5));
            n3 = ++n2;
        }
        iterator.add(a.substring((Integer)((LinkedList)object).getLast()));
        LinkedList<String> linkedList = new LinkedList<String>();
        iterator = iterator.iterator();
        Iterator<String> iterator3 = iterator;
        while (iterator3.hasNext()) {
            object = (String)iterator.next();
            iterator3 = iterator;
            linkedList.add(((String)object).toLowerCase());
        }
        return Joiner.on((String)"").join(linkedList);
    }

    public static String text2pinyin(String a) {
        Bopomofo4j.local();
        return PinyinHelper.toPinyin((String)a, (PinyinStyleEnum)PinyinStyleEnum.NUM_LAST, (String)ConvertUtils.ALLATORIxDEMO("E"));
    }

    public static void main(String[] a) {
        System.out.println(ConvertUtils.ALLATORIxDEMO("omFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFDFnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEmomEnEnEnEnFmEmEnEmEnEnFmEmFmEmFmEmFnEmFmEnEnEnEnFDFnEnEnEnFnFnFnEnFnEnFnFnEmEnFnFnFnFnEmEnEnEnEnEmomEnEnEnEmFmEmEnEmEnEmFmEnFnEmEmEmFnEnFnEnEnEnEnFDFnEnEnEnFnFnFmFnFmFnFnFnEmEnFmFnFnFnFmFnEnEnEnEmomEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnFDFn*,\u0003;\u0016-\u0004:\f!\u000bn\u00077E\u000f\t\"\u0004:\n<\fn*,\u0003;\u0016-\u0004:\n<E8R`]n!\u000b(\u0001EmomEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnFDFnEnEnEnEnEn\r:\u0011>_aJ9\u00129K/\t\"\u0004:\n<\f`\u0006!\bnEnEnEnEnEnEmomEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnEnFDFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmFmo"));
        System.out.println(SequenceUtils.ALLATORIxDEMO(ConvertUtils.ALLATORIxDEMO("\u6274&\u0000\"\t!I\u0007E\"\n8\u0000n\u001c!\u0010n\u6274\u6661\u4f05")));
        System.out.println(SequenceUtils.text2pinyin(ConvertUtils.ALLATORIxDEMO("\u8f97\u664a\u5bd0\u52fe\u5fc6\u723e\u9072I")));
        System.out.println(SequenceUtils.text2phoneme(ConvertUtils.ALLATORIxDEMO("\u8f97\u664a\u5bd0\u52fe\u5fc6\u723e\u9072I")));
        System.out.println(SequenceUtils.text2sequence(ConvertUtils.ALLATORIxDEMO("\u8f97\u664a\u5bd0\u52fe\u5fc6\u723e\u9072I")));
    }

    public static List<String> pinyin2phoneme(String a) {
        int n;
        String[] stringArray = a.split(ConvertUtils.ALLATORIxDEMO("E"));
        ArrayList arrayList = Lists.newArrayList();
        int n2 = stringArray.length;
        int n3 = n = 0;
        while (n3 < n2) {
            ArrayList arrayList2;
            Object object;
            String[] stringArray2;
            String string = stringArray[n];
            ArrayList arrayList3 = Lists.newArrayList();
            if (PhonemeUtils.i.containsKey(string)) {
                stringArray2 = PhonemeUtils.i.get(string).split(ConvertUtils.ALLATORIxDEMO("E"));
                object = new ArrayList(stringArray2.length);
                ArrayList arrayList4 = arrayList3;
                Collections.addAll(object, stringArray2);
                arrayList2 = arrayList4;
                arrayList4.addAll(object);
            } else {
                int n4;
                object = stringArray2 = string.split("");
                int n5 = ((String[])object).length;
                int n6 = n4 = 0;
                while (n6 < n5) {
                    List<String> list = SequenceUtils.ALLATORIxDEMO(object[n4]);
                    arrayList3.addAll(list);
                    n6 = ++n4;
                }
                arrayList2 = arrayList3;
            }
            arrayList2.add(SymbolUtils.k);
            arrayList.addAll(arrayList3);
            n3 = ++n;
        }
        ArrayList arrayList5 = arrayList;
        arrayList5.add(SymbolUtils.J);
        arrayList.add(SymbolUtils.f);
        return arrayList5;
    }

    public static List<String> changeDiao(List<String> a) {
        int n;
        int n2 = -5;
        ArrayList arrayList = Lists.newArrayList();
        List<String> list = a;
        Collections.reverse(list);
        int n3 = list.size();
        int n4 = n = 0;
        while (n4 < n3) {
            String string = a.get(n);
            if (string.equals(ConvertUtils.ALLATORIxDEMO("V"))) {
                if (n - n2 == 4) {
                    arrayList.add(ConvertUtils.ALLATORIxDEMO("W"));
                } else {
                    n2 = n;
                    arrayList.add(string);
                }
            } else {
                arrayList.add(string);
            }
            n4 = ++n;
        }
        ArrayList arrayList2 = arrayList;
        Collections.reverse(arrayList2);
        return arrayList2;
    }
}

