/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d.android;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import javax.microedition.khronos.opengles.GL10;
import javax.microedition.khronos.opengles.GL11;
import jp.live2d.util.UtDebug;

public class UtOpenGL {
    static FloatBuffer a = null;
    static FloatBuffer b = null;
    static ShortBuffer c = null;
    static final int d = 999;
    static int e = 0;
    static FloatBuffer f;
    static ByteBuffer g;
    static float[] h;
    static byte[] i;

    static {
        h = new float[8];
        i = new byte[16];
    }

    public static int genTexture(GL10 gl) {
        int n = 0;
        int n2 = 0;
        while (n2 < 999) {
            int[] nArray = new int[1];
            gl.glGenTextures(1, nArray, 0);
            n = nArray[0];
            if (n >= 0) break;
            gl.glDeleteTextures(1, nArray, 0);
            ++n2;
        }
        if (n2 == 999) {
            UtDebug.error("gen texture loops over 999times @UtOpenGL", new Object[0]);
            n = 0;
        }
        return n;
    }

    public static FloatBuffer createFloatBuffer(int floatCount) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(floatCount * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    public static FloatBuffer setupFloatBuffer(FloatBuffer preBuffer, float[] array) {
        if (preBuffer == null || preBuffer.capacity() < array.length) {
            preBuffer = UtOpenGL.createFloatBuffer(array.length * 2);
        } else {
            preBuffer.clear();
        }
        preBuffer.put(array);
        preBuffer.position(0);
        return preBuffer;
    }

    public static ShortBuffer createShortBuffer(int shortCount) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(shortCount * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        return shortBuffer;
    }

    private static ShortBuffer a(ShortBuffer shortBuffer, short[] sArray) {
        if (shortBuffer == null || shortBuffer.capacity() < sArray.length) {
            shortBuffer = UtOpenGL.createShortBuffer(sArray.length * 2);
        } else {
            shortBuffer.clear();
        }
        shortBuffer.clear();
        shortBuffer.put(sArray);
        shortBuffer.position(0);
        return shortBuffer;
    }

    public static ByteBuffer createByteBuffer(int count) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(count * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        return byteBuffer;
    }

    public static ByteBuffer setupByteBuffer(ByteBuffer preBuffer, byte[] array) {
        if (preBuffer == null || preBuffer.capacity() < array.length) {
            preBuffer = UtOpenGL.createByteBuffer(array.length * 2);
        } else {
            preBuffer.clear();
        }
        preBuffer.put(array);
        preBuffer.position(0);
        return preBuffer;
    }

    public static void drawImage(GL10 gl, int img, float x, float y, float w, float h) {
        UtOpenGL.drawImage(gl, img, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void drawImage(GL10 gl, int img, float x, float y, float w, float h, float uvx, float uvy, float uvw, float uvh) {
        float[] fArray = new float[]{uvx, uvy, uvx + uvw, uvy, uvx + uvw, uvy + uvh, uvx, uvy + uvh};
        float[] fArray2 = new float[]{x, y, x + w, y, x + w, y + h, x, y + h};
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[4] = 2;
        sArray[5] = 3;
        short[] sArray2 = sArray;
        a = UtOpenGL.setupFloatBuffer(a, fArray);
        b = UtOpenGL.setupFloatBuffer(b, fArray2);
        c = UtOpenGL.a(c, sArray2);
        gl.glTexCoordPointer(2, 5126, 0, (Buffer)a);
        gl.glVertexPointer(2, 5126, 0, (Buffer)b);
        gl.glBindTexture(3553, img);
        gl.glDrawElements(4, 6, 5123, (Buffer)c);
    }

    public static int loadTexture(GL10 gl, Context context, String path, boolean mipmap) {
        InputStream inputStream = context.getAssets().open(path);
        return UtOpenGL.loadTexture(gl, inputStream, mipmap);
    }

    public static int loadTexture(GL10 gl, InputStream in, boolean mipmap) {
        int n;
        Bitmap bitmap = BitmapFactory.decodeStream((InputStream)in);
        if (mipmap) {
            n = UtOpenGL.buildMipmap(gl, bitmap);
        } else {
            n = UtOpenGL.genTexture(gl);
            gl.glBindTexture(3553, n);
            gl.glTexParameterf(3553, 10241, 9729.0f);
            gl.glTexParameterf(3553, 10240, 9729.0f);
            gl.glTexParameterf(3553, 10242, 33071.0f);
            gl.glTexParameterf(3553, 10243, 33071.0f);
            gl.glTexEnvf(8960, 8704, 8448.0f);
            GLUtils.texImage2D((int)3553, (int)0, (Bitmap)bitmap, (int)0);
            bitmap.recycle();
        }
        return n;
    }

    public static int buildMipmap(GL10 gl, Bitmap bitmap) {
        return UtOpenGL.buildMipmap(gl, bitmap, true);
    }

    public static int buildMipmap(GL10 gl, Bitmap srcBitmap, boolean recycle) {
        Bitmap bitmap = srcBitmap;
        int n = 0;
        int n2 = bitmap.getHeight();
        int n3 = bitmap.getWidth();
        int n4 = UtOpenGL.genTexture(gl);
        gl.glBindTexture(3553, n4);
        try {
            ((GL11)gl).glTexParameteri(3553, 33169, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        gl.glTexParameterf(3553, 10241, 9729.0f);
        gl.glTexParameterf(3553, 10241, 9987.0f);
        gl.glTexParameterf(3553, 10240, 9729.0f);
        gl.glTexParameterf(3553, 10242, 33071.0f);
        gl.glTexParameterf(3553, 10243, 33071.0f);
        gl.glTexEnvf(8960, 8704, 8448.0f);
        while (n2 >= 1 && n3 >= 1) {
            GLUtils.texImage2D((int)3553, (int)n, (Bitmap)bitmap, (int)0);
            if (n2 == 1 || n3 == 1) {
                if (!recycle && bitmap == srcBitmap) break;
                bitmap.recycle();
                break;
            }
            ++n;
            Bitmap bitmap2 = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)(n3 /= 2), (int)(n2 /= 2), (boolean)true);
            if (recycle || bitmap != srcBitmap) {
                bitmap.recycle();
            }
            bitmap = bitmap2;
        }
        return n4;
    }

    public static void drawClippedRect(GL10 gl, float x, float y, float w, float h, float clipx, float clipy, float clipw, float cliph, int color) {
        UtOpenGL.drawRect(gl, x, y, clipx - x, h, color);
        UtOpenGL.drawRect(gl, clipx + clipw, y, x + w - (clipx + clipw), h, color);
        UtOpenGL.drawRect(gl, clipx, y, clipw, clipy - y, color);
        UtOpenGL.drawRect(gl, clipx, clipy + cliph, clipw, y + h - (clipy + cliph), color);
    }

    public static void drawRect(GL10 gl, float x, float y, float w, float h, int argb) {
        if (w == 0.0f || h == 0.0f) {
            return;
        }
        int n = argb >> 24 & 0xFF;
        int n2 = argb >> 16 & 0xFF;
        int n3 = argb >> 8 & 0xFF;
        int n4 = argb & 0xFF;
        UtOpenGL.h[0] = x;
        UtOpenGL.h[1] = y;
        UtOpenGL.h[2] = x + w;
        UtOpenGL.h[3] = y;
        UtOpenGL.h[4] = x;
        UtOpenGL.h[5] = y + h;
        UtOpenGL.h[6] = x + w;
        UtOpenGL.h[7] = y + h;
        UtOpenGL.i[0] = (byte)n2;
        UtOpenGL.i[4] = (byte)n2;
        UtOpenGL.i[8] = (byte)n2;
        UtOpenGL.i[12] = (byte)n2;
        UtOpenGL.i[1] = (byte)n3;
        UtOpenGL.i[5] = (byte)n3;
        UtOpenGL.i[9] = (byte)n3;
        UtOpenGL.i[13] = (byte)n3;
        UtOpenGL.i[2] = (byte)n4;
        UtOpenGL.i[6] = (byte)n4;
        UtOpenGL.i[10] = (byte)n4;
        UtOpenGL.i[14] = (byte)n4;
        UtOpenGL.i[3] = (byte)n;
        UtOpenGL.i[7] = (byte)n;
        UtOpenGL.i[11] = (byte)n;
        UtOpenGL.i[15] = (byte)n;
        f = UtOpenGL.setupFloatBuffer(f, UtOpenGL.h);
        g = UtOpenGL.setupByteBuffer(g, i);
        gl.glDisable(3553);
        gl.glEnableClientState(32884);
        gl.glEnableClientState(32886);
        gl.glVertexPointer(2, 5126, 0, (Buffer)f);
        gl.glColorPointer(4, 5121, 0, (Buffer)g);
        gl.glDrawArrays(5, 0, 4);
        gl.glDisableClientState(32886);
        gl.glDisableClientState(32884);
    }
}

