/*
 * Decompiled with CFR 0.152.
 */
package jp.live2d;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import jp.live2d.ModelContext;
import jp.live2d.draw.IDrawContext;
import jp.live2d.draw.IDrawData;
import jp.live2d.draw.a;
import jp.live2d.error.Live2DException;
import jp.live2d.graphics.DrawParam;
import jp.live2d.id.DrawDataID;
import jp.live2d.id.ParamID;
import jp.live2d.id.PartsDataID;
import jp.live2d.io.BReader;
import jp.live2d.model.ModelImpl;
import jp.live2d.util.UtDebug;

public abstract class ALive2DModel {
    public static final int a = 1;
    public static final int b = 2;
    protected static int c = 0;
    protected ModelImpl d = null;
    protected ModelContext e = null;
    protected int f = 0;
    ModelDrawMethodVersion g = ModelDrawMethodVersion.NOT_SPECIFIED;

    public ALive2DModel() {
        ++c;
        this.e = new ModelContext(this);
    }

    public void setModelImpl(ModelImpl m) {
        this.d = m;
    }

    public ModelImpl getModelImpl() {
        if (this.d == null) {
            this.d = new ModelImpl();
            this.d.initDirect();
        }
        return this.d;
    }

    public float getCanvasWidth() {
        if (this.d == null) {
            return 0.0f;
        }
        return this.d.getCanvasWidth();
    }

    public float getCanvasHeight() {
        if (this.d == null) {
            return 0.0f;
        }
        return this.d.getCanvasHeight();
    }

    public float getParamFloat(String paramID) {
        return this.e.getParamFloat(this.e.getParamIndex(ParamID.getID(paramID)));
    }

    public void setParamFloat(String paramID, float value) {
        this.e.setParamFloat(this.e.getParamIndex(ParamID.getID(paramID)), value);
    }

    public void setParamFloat(String paramID, float value, float weight) {
        int n = this.e.getParamIndex(ParamID.getID(paramID));
        this.setParamFloat(n, value, weight);
    }

    public void addToParamFloat(String paramID, float value) {
        this.addToParamFloat(paramID, value, 1.0f);
    }

    public void addToParamFloat(String paramID, float value, float weight) {
        int n = this.e.getParamIndex(ParamID.getID(paramID));
        this.addToParamFloat(n, value, weight);
    }

    public void multParamFloat(String paramID, float mult) {
        this.multParamFloat(paramID, mult, 1.0f);
    }

    public void multParamFloat(String paramID, float mult, float weight) {
        int n = this.e.getParamIndex(ParamID.getID(paramID));
        this.multParamFloat(n, mult, weight);
    }

    public void loadParam() {
        this.e.loadParam();
    }

    public void saveParam() {
        this.e.saveParam();
    }

    public void init() {
        this.e.init();
    }

    public void update() {
        this.e.update();
    }

    public int generateModelTextureNo() {
        UtDebug.error("please override generateModelTextureNo()", new Object[0]);
        return -1;
    }

    public void releaseModelTextureNo(int no) {
        UtDebug.error("please override ALive2DModel#releaseModelTextureNo() \n", new Object[0]);
    }

    public abstract void deleteTextures();

    public abstract void draw();

    public static void loadModel_exe(ALive2DModel ret, String filepath) {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(filepath), 8192);
        ALive2DModel.loadModel_exe(ret, bufferedInputStream);
        bufferedInputStream.close();
    }

    public static void loadModel_exe(ALive2DModel ret, InputStream bin) {
        try {
            int n;
            BReader bReader = new BReader(bin);
            byte by = bReader.f();
            byte by2 = bReader.f();
            byte by3 = bReader.f();
            if (by != 109 || by2 != 111 || by3 != 99) {
                throw new Live2DException("Model load error , Unknown fomart.");
            }
            byte by4 = bReader.f();
            bReader.a(by4);
            if (by4 > 11) {
                ret.f |= 2;
                String string = String.format("Model load error , Illegal data version error ( available : %d < loaded . %d )@ALive2DModel#loadModel()\n", 11, (int)by4);
                throw new Live2DException(string);
            }
            ModelImpl modelImpl = (ModelImpl)bReader.n();
            if (by4 >= 8 && (n = bReader.e()) != -2004318072) {
                ret.f |= 1;
                throw new Live2DException("Model load error , EOF not found.");
            }
            ret.setModelImpl(modelImpl);
            ModelContext modelContext = ret.getModelContext();
            modelContext.init();
        }
        catch (Exception exception) {
            throw new Live2DException(exception, "Model load error , Unknown error ");
        }
    }

    public int getParamIndex(String paramID) {
        return this.e.getParamIndex(ParamID.getID(paramID));
    }

    public float getParamFloat(int paramIndex) {
        return this.e.getParamFloat(paramIndex);
    }

    public void setParamFloat(int paramIndex, float value) {
        this.e.setParamFloat(paramIndex, value);
    }

    public void setParamFloat(int paramIndex, float value, float weight) {
        this.e.setParamFloat(paramIndex, this.e.getParamFloat(paramIndex) * (1.0f - weight) + value * weight);
    }

    public void addToParamFloat(int paramIndex, float value) {
        this.addToParamFloat(paramIndex, value, 1.0f);
    }

    public void addToParamFloat(int paramIndex, float value, float weight) {
        this.e.setParamFloat(paramIndex, this.e.getParamFloat(paramIndex) + value * weight);
    }

    public void multParamFloat(int paramIndex, float mult) {
        this.multParamFloat(paramIndex, mult, 1.0f);
    }

    public void multParamFloat(int paramIndex, float mult, float weight) {
        this.e.setParamFloat(paramIndex, this.e.getParamFloat(paramIndex) * (1.0f + (mult - 1.0f) * weight));
    }

    public ModelContext getModelContext() {
        return this.e;
    }

    public int getErrorFlags() {
        return this.f;
    }

    public void setupPartsOpacityGroup_alphaImpl(String[] paramGroup, String[] partsIDGroup, float deltaTimeSec, float CLEAR_TIME_SEC) {
        int n = -1;
        float f = 0.0f;
        ALive2DModel aLive2DModel = this;
        float f2 = 0.5f;
        float f3 = 0.15f;
        boolean bl = true;
        if (deltaTimeSec == 0.0f) {
            int n2 = 0;
            while (n2 < paramGroup.length) {
                String string = paramGroup[n2];
                String string2 = partsIDGroup[n2];
                boolean bl2 = aLive2DModel.getParamFloat(string) != 0.0f;
                aLive2DModel.setPartsOpacity(string2, (float)(bl2 ? 1 : 0));
                ++n2;
            }
            return;
        }
        if (paramGroup.length == 1) {
            String string = paramGroup[0];
            boolean bl3 = aLive2DModel.getParamFloat(string) != 0.0f;
            String string3 = partsIDGroup[0];
            float f4 = aLive2DModel.getPartsOpacity(string3);
            float f5 = deltaTimeSec / CLEAR_TIME_SEC;
            if (bl3) {
                if ((f4 += f5) > 1.0f) {
                    f4 = 1.0f;
                }
            } else if ((f4 -= f5) < 0.0f) {
                f4 = 0.0f;
            }
            aLive2DModel.setPartsOpacity(string3, f4);
        } else {
            String string;
            int n3 = 0;
            while (n3 < paramGroup.length) {
                boolean bl4;
                string = paramGroup[n3];
                boolean bl5 = bl4 = aLive2DModel.getParamFloat(string) != 0.0f;
                if (bl4) {
                    if (n >= 0) break;
                    n = n3;
                    String string4 = partsIDGroup[n3];
                    f = aLive2DModel.getPartsOpacity(string4);
                    if ((f += deltaTimeSec / CLEAR_TIME_SEC) > 1.0f) {
                        f = 1.0f;
                    }
                }
                ++n3;
            }
            if (n < 0) {
                System.out.printf("No Parts Visible/ use default[%s]", paramGroup[0]);
                n = 0;
                f = 1.0f;
                aLive2DModel.loadParam();
                aLive2DModel.setParamFloat(paramGroup[n], f);
                aLive2DModel.saveParam();
            }
            n3 = 0;
            while (n3 < paramGroup.length) {
                string = partsIDGroup[n3];
                if (n == n3) {
                    aLive2DModel.setPartsOpacity(string, f);
                } else {
                    float f6 = aLive2DModel.getPartsOpacity(string);
                    float f7 = f < f2 ? f * (f2 - 1.0f) / f2 + 1.0f : (1.0f - f) * f2 / (1.0f - f2);
                    float f8 = (1.0f - f7) * (1.0f - f);
                    if (f8 > f3) {
                        f7 = 1.0f - f3 / (1.0f - f);
                    }
                    if (f6 > f7) {
                        f6 = f7;
                    }
                    aLive2DModel.setPartsOpacity(string, f6);
                }
                ++n3;
            }
        }
    }

    public void setPartsOpacity(String partsID, float opacity) {
        int n = this.e.getPartsDataIndex(PartsDataID.getID(partsID));
        if (n < 0) {
            return;
        }
        this.setPartsOpacity(n, opacity);
    }

    public void setPartsOpacity(int partsIndex, float opacity) {
        this.e.setPartsOpacity(partsIndex, opacity);
    }

    public int getPartsDataIndex(String partsID) {
        return this.e.getPartsDataIndex(PartsDataID.getID(partsID));
    }

    public int getPartsDataIndex(PartsDataID partsID) {
        return this.e.getPartsDataIndex(partsID);
    }

    public float getPartsOpacity(String partsID) {
        int n = this.e.getPartsDataIndex(PartsDataID.getID(partsID));
        if (n < 0) {
            return 0.0f;
        }
        return this.getPartsOpacity(n);
    }

    public float getPartsOpacity(int partsIndex) {
        return this.e.getPartsOpacity(partsIndex);
    }

    public abstract DrawParam getDrawParam();

    public int getDrawDataIndex(String drawDataID) {
        return this.e.getDrawDataIndex(DrawDataID.getID(drawDataID));
    }

    public IDrawData getDrawData(int drawIndex) {
        return this.e.getDrawData(drawIndex);
    }

    public float[] getTransformedPoints(int drawIndex) {
        IDrawContext iDrawContext = this.e.getDrawContext(drawIndex);
        if (iDrawContext instanceof a.a) {
            return ((a.a)iDrawContext).a();
        }
        return null;
    }

    public short[] getIndexArray(int drawIndex) {
        IDrawData iDrawData = this.e.getDrawData(drawIndex);
        if (iDrawData instanceof a) {
            return ((a)iDrawData).h();
        }
        return null;
    }

    public void setPremultipliedAlpha(boolean b2) {
        this.getDrawParam().setPremultipliedAlpha(b2);
    }

    public boolean isPremultipliedAlpha() {
        return this.getDrawParam().isPremultipliedAlpha();
    }

    public void setModelDrawMethodVersion(ModelDrawMethodVersion userSetting) {
        this.g = userSetting;
    }

    public ModelDrawMethodVersion getModelDrawMethodVersion() {
        return this.g;
    }

    public static enum ModelDrawMethodVersion {
        NOT_SPECIFIED,
        DRAW_2_0,
        DRAW_2_1;

    }
}

