/***************************************************************************
 *  Copyright 1991, 1992, 1993, 1994, 1995, 1996, 2001, 2002               *
 *    David R. Hill, Leonard Manzara, Craig Schock                         *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/
// 2014-09
// This file was copied from Gnuspeech and modified by Marcelo Y. Matuda.

#ifndef TEXT_PARSER_ENGLISH_NUMBER_PRONUNCIATIONS_H_
#define TEXT_PARSER_ENGLISH_NUMBER_PRONUNCIATIONS_H_

// Contains pronunciations for NumberParser AND LetterToSound.

/*  CARDINAL NUMBER NAMES  */
#define OH                     "'uh_uu "
#define ZERO                   "'z_i_r.uh_uu "
#define ONE                    "'w_a_n "
#define TWO                    "'t_uu "
#define THREE                  "'th_r_ee "
#define FOUR                   "'f_aw_r "
#define FIVE                   "'f_ah_i_v "
#define SIX                    "'s_i_k_s "
#define SEVEN                  "'s_e.v_uh_n "
#define EIGHT                  "'e_i_t "
#define NINE                   "'n_ah_i_n "
#define TEN                    "'t_e_n "
#define ELEVEN                 "i.'l_e.v_uh_n "
#define TWELVE                 "'t_w_e_l_v "
#define THIRTEEN               "'th_uh_r.t_ee_n "
#define FOURTEEN               "'f_aw_r.t_ee_n "
#define FIFTEEN                "'f_i_f.t_ee_n "
#define SIXTEEN                "'s_i_k_s.t_ee_n "
#define SEVENTEEN              "'s_e.v_uh_n.t_ee_n "
#define EIGHTEEN               "'e_i.t_ee_n "
#define NINETEEN               "'n_ah_i_n.t_ee_n "
#define TWENTY                 "'t_w_e_n.t_ee "
#define THIRTY                 "'th_uh_r.t_ee "
#define FORTY                  "'f_aw_r.t_ee "
#define FIFTY                  "'f_i_f.t_ee "
#define SIXTY                  "'s_i_k_s.t_ee "
#define SEVENTY                "'s_e.v_uh_n.t_ee "
#define EIGHTY                 "'e_i.t_ee "
#define NINETY                 "'n_ah_i.t_ee "

#define TRIADS_MAX             22
/*  THERE MUST BE THIS MANY TRIAD NAMES BELOW  */
#define HUNDRED                "'h_a_n.d_r_uh_d "
#define THOUSAND               "'th_ah_uu.z_uh_n_d "
#define MILLION                "'m_i_l.i_uh_n "
#define BILLION                "'b_i_l.i_uh_n "
#define TRILLION               "'t_r_i_l.i_uh_n "
#define QUADRILLION            "k_w_uh.'d_r_i_l.i_uh_n "
#define QUINTILLION            "k_w_i_n.'t_i_l.i_uh_n "
#define SEXTILLION             "s_e_k_s.'t_i_l.i_uh_n "
#define SEPTILLION             "s_e_p.'t_i_l.i_uh_n "
#define OCTILLION              "o_k.'t_i_l.i_uh_n "
#define NONILLION              "n_o.'n_i_l.i_uh_n "
#define DECILLION              "d_e.'s_i_l.i_uh_n "
#define UNDECILLION            "\"a_n.d_e.'s_i_l.i_uh_n "
#define DUODECILLION           "\"d_uu.uh_uu.d_e.'s_i_l.i_uh_n "
#define TREDECILLION           "\"t_r_e_i.d_e.'s_i_l.i_uh_n "
#define QUATTUORDECILLION      "k_w_uh.\"t_aw_r.d_e.'s_i_l.i_uh_n "
#define QUINDECILLION          "\"k_w_i_n.d_e.'s_i_l.i_uh_n "
#define SEXDECILLION           "\"s_e_k_s.d_e.'s_i_l.i_uh_n "
#define SEPTENDECILLION        "\"s_e_p.t_e_n.d_e.'s_i_l.i_uh_n "
#define OCTODECILLION          "\"o_k.t_uh_uu.d_e.'s_i_l.i_uh_n "
#define NOVEMDECILLION         "\"n_uh_uu.v_e_m.d_e.'s_i_l.i_uh_n "
#define VIGINTILLION           "\"v_i.j_i_n.'t_i_l.i_uh_n "

/*  ORDINAL NUMBER NAMES  */
#define ZEROETH                "'z_i_r.uh_uu.e_th "
#define FIRST                  "'f_uh_r_s_t "
#define SECOND                 "'s_e.k_uh_n_d "
#define THIRD                  "'th_uh_r_d "
#define FOURTH                 "'f_aw_r_th "
#define FIFTH                  "'f_i_f_th "
#define SIXTH                  "'s_i_k_s_th "
#define SEVENTH                "'s_e.v_uh_n_th "
#define EIGHTH                 "'e_i_t_th "
#define NINTH                  "'n_ah_i_n_th "
#define TENTH                  "'t_e_n_th "
#define ELEVENTH               "i.'l_e.v_uh_n_th "
#define TWELFTH                "'t_w_e_l_f_th "
#define THIRTEENTH             "'th_uh_r.t_ee_n_th "
#define FOURTEENTH             "'f_aw_r.t_ee_n_th "
#define FIFTEENTH              "'f_i_f.t_ee_n_th "
#define SIXTEENTH              "'s_i_k_s.t_ee_n_th "
#define SEVENTEENTH            "'s_e.v_uh_n.t_ee_n_th "
#define EIGHTEENTH             "'e_i.t_ee_n_th "
#define NINETEENTH             "'n_ah_i_n.t_ee_n_th "
#define TWENTIETH              "'t_w_e_n.t_ee.uh_th "
#define THIRTIETH              "'th_uh_r.t_ee.uh_th "
#define FORTIETH               "'f_aw_r.t_ee.uh_th "
#define FIFTIETH               "'f_i_f.t_ee.uh_th "
#define SIXTIETH               "'s_i_k_s.t_ee.uh_th "
#define SEVENTIETH             "'s_e.v_uh_n.t_ee.uh_th "
#define EIGHTIETH              "'e_i.t_ee.uh_th "
#define NINETIETH              "'n_ah_i.t_ee.uh_th "

/* THESE MUST MATCH THE TRIAD NAMES ABOVE */
#define HUNDREDTH              "'h_a_n.d_r_uh_d_th "
#define THOUSANDTH             "'th_ah_uu.z_uh_n_th "
#define MILLIONTH              "'m_i_l.i_uh_n_th "
#define BILLIONTH              "'b_i_l.i_uh_n_th "
#define TRILLIONTH             "'t_r_i_l.i_uh_n_th "
#define QUADRILLIONTH          "k_w_uh.'d_r_i_l.i_uh_n_th "
#define QUINTILLIONTH          "k_w_i_n.'t_i_l.i_uh_n_th "
#define SEXTILLIONTH           "s_e_k_s.'t_i_l.i_uh_n_th "
#define SEPTILLIONTH           "s_e_p.'t_i_l.i_uh_n_th "
#define OCTILLIONTH            "o_k.'t_i_l.i_uh_n_th "
#define NONILLIONTH            "n_o.'n_i_l.i_uh_n_th "
#define DECILLIONTH            "d_e.'s_i_l.i_uh_n_th "
#define UNDECILLIONTH          "\"a_n.d_e.'s_i_l.i_uh_n_th "
#define DUODECILLIONTH         "\"d_uu.uh_uu.d_e.'s_i_l.i_uh_n_th "
#define TREDECILLIONTH         "\"t_r_e_i.d_e.'s_i_l.i_uh_n_th "
#define QUATTUORDECILLIONTH    "k_w_uh.\"t_aw_r.d_e.'s_i_l.i_uh_n_th "
#define QUINDECILLIONTH        "\"k_w_i_n.d_e.'s_i_l.i_uh_n_th "
#define SEXDECILLIONTH         "\"s_e_k_s.d_e.'s_i_l.i_uh_n_th "
#define SEPTENDECILLIONTH      "\"s_e_p.t_e_n.d_e.'s_i_l.i_uh_n_th "
#define OCTODECILLIONTH        "\"o_k.t_uh_uu.d_e.'s_i_l.i_uh_n_th "
#define NOVEMDECILLIONTH       "\"n_uh_uu.v_e_m.d_e.'s_i_l.i_uh_n_th "
#define VIGINTILLIONTH         "\"v_i.j_i_n.'t_i_l.i_uh_n_th "

/*  PLURAL ORDINAL NUMBER NAMES FOR FRACTIONS  */
#define HALF                   "'h_aa_f "
#define HALVES                 "'h_aa_v_z "
#define SECONDTH               "'s_e.k_uh_n_th "
#define SECONDTHS              "'s_e.k_uh_n_th_s "
#define THIRDS                 "'th_uh_r_d_z "
#define QUARTER                "'k_w_aw_r.t_uh_r "
#define QUARTERS               "'k_w_aw_r.t_uh_r_z "
#define FOURTHS                "'f_aw_r_th_s "
#define FIFTHS                 "'f_i_f_s "
#define SIXTHS                 "'s_i_k_s_th_s "
#define SEVENTHS               "'s_e.v_uh_n_th_s "
#define EIGHTHS                "'e_i_t_th_s "
#define NINTHS                 "'n_ah_i_n_th_s "
#define TENTHS                 "'t_e_n_th_s "
#define ELEVENTHS              "i.'l_e.v_e_n_th_s "
#define TWELFTHS               "'t_w_e_l_f_s "
#define THIRTEENTHS            "'th_uh_r.t_ee_n_th_s "
#define FOURTEENTHS            "'f_aw_r.t_ee_n_th_s "
#define FIFTEENTHS             "'f_i_f.t_ee_n_th_s "
#define SIXTEENTHS             "'s_i_k_s.t_ee_n_th_s "
#define SEVENTEENTHS           "'s_e.v_uh_n.t_ee_n_th_s "
#define EIGHTEENTHS            "'e_i.t_ee_n_th_s "
#define NINETEENTHS            "'n_ah_i_n.t_ee_n_th_s "
#define TWENTIETHS             "'t_w_e_n.t_ee.uh_th_s "
#define THIRTIETHS             "'th_uh_r.t_ee.uh_th_s "
#define FORTIETHS              "'f_aw_r.t_ee.uh_th_s "
#define FIFTIETHS              "'f_i_f.t_ee.uh_th_s "
#define SIXTIETHS              "'s_i_k_s.t_ee.uh_th_s "
#define SEVENTIETHS            "'s_e.v_uh_n.t_ee.uh_th_s "
#define EIGHTIETHS             "'e_i.t_ee.uh_th_s "
#define NINETIETHS             "'n_ah_i.t_ee.uh_th_s "

/* THESE MUST MATCH THE TRIAD NAMES ABOVE */
#define HUNDREDTHS             "'h_a_n.d_r_uh_d_th_s "
#define THOUSANDTHS            "'th_ah_uu.z_uh_n_th_s "
#define MILLIONTHS             "'m_i_l.i_uh_n_th_s "
#define BILLIONTHS             "'b_i_l.i_uh_n_th_s "
#define TRILLIONTHS            "'t_r_i_l.i_uh_n_th_s "
#define QUADRILLIONTHS         "k_w_uh.'d_r_i_l.i_uh_n_th_s "
#define QUINTILLIONTHS         "k_w_i_n.'t_i_l.i_uh_n_th_s "
#define SEXTILLIONTHS          "s_e_k_s.'t_i_l.i_uh_n_th_s "
#define SEPTILLIONTHS          "s_e_p.'t_i_l.i_uh_n_th_s "
#define OCTILLIONTHS           "o_k.'t_i_l.i_uh_n_th_s "
#define NONILLIONTHS           "n_o.'n_i_l.i_uh_n_th_s "
#define DECILLIONTHS           "d_e.'s_i_l.i_uh_n_th_s "
#define UNDECILLIONTHS         "\"a_n.d_e.'s_i_l.i_uh_n_th_s "
#define DUODECILLIONTHS        "\"d_uu.uh_uu.d_e.'s_i_l.i_uh_n_th_s "
#define TREDECILLIONTHS        "\"t_r_e_i.d_e.'s_i_l.i_uh_n_th_s "
#define QUATTUORDECILLIONTHS   "k_w_uh.\"t_aw_r.d_e.'s_i_l.i_uh_n_th_s "
#define QUINDECILLIONTHS       "\"k_w_i_n.d_e.'s_i_l.i_uh_n_th_s "
#define SEXDECILLIONTHS        "\"s_e_k_s.d_e.'s_i_l.i_uh_n_th_s "
#define SEPTENDECILLIONTHS     "\"s_e_p.t_e_n.d_e.'s_i_l.i_uh_n_th_s "
#define OCTODECILLIONTHS       "\"o_k.t_uh_uu.d_e.'s_i_l.i_uh_n_th_s "
#define NOVEMDECILLIONTHS      "\"n_uh_uu.v_e_m.d_e.'s_i_l.i_uh_n_th_s "
#define VIGINTILLIONTHS        "\"v_i.j_i_n.'t_i_l.i_uh_n_th_s "

/*  MISCELLANEOUS SYMBOL NAMES  */
#define AND                    "aa_n_d "
#define DOLLAR                 "'d_o.l_uh_r "
#define DOLLARS                "'d_o.l_uh_r_z "
#define NEGATIVE               "'n_e.g_uh.t_i_v "
#define POSITIVE               "'p_o.z_i.t_i_v "
#define POINT                  "'p_o_i_n_t "
#define CENT                   "'s_e_n_t "
#define CENTS                  "'s_e_n_t_s "
#define PERCENT                "p_uh_r.'s_e_n_t "
#define OVER                   "'uh_uu.v_uh_r "
#define AREA                   "'e_r.ee.uh "
#define CODE                   "'k_uh_uu_d "
#define PAUSE                  "^ "
#define SECONDS                "'s_e.k_uh_n_d_z "
#define OCLOCK                 "uh_uu.'k_l_o_k "
#define NULL_STRING            ""

#define BLANK                  "'b_l_aa_n_k "
#define EXCLAMATION_POINT      "\"e_k_s.k_l_uh.'m_e_i.sh_uh_n 'p_o_i_n_t "
#define DOUBLE_QUOTE           "'d_a.b_uh_l 'k_w_uh_uu_t "
#define NUMBER_SIGN            "'n_a_m.b_uh_r 's_ah_i_n "
#define DOLLAR_SIGN            "'d_o.l_uh_r 's_ah_i_n "
#define PERCENT_SIGN           "p_uh_r.'s_e_n_t 's_ah_i_n "
#define AMPERSAND              "'aa_m.p_uh_r.s_aa_n_d "
#define SINGLE_QUOTE           "'s_i_ng.g_uh_l 'k_w_uh_uu_t "
#define OPEN_PARENTHESIS       "'uh_uu.p_uh_n p_uh.'r_e_n.th_uh.s_i_s "
#define CLOSE_PARENTHESIS      "'k_l_uh_uu_z p_uh.'r_e_n.th_uh.s_i_s "
#define ASTERISK               "'aa_s.t_uh_r.i_s_k "
#define PLUS_SIGN              "'p_l_a_s 's_ah_i_n "
#define COMMA                  "'k_o.m_uh "
#define HYPHEN                 "'h_ah_i.f_uh_n "
#define PERIOD                 "'p_i_r.ee.uh_d "
#define SLASH                  "'s_l_aa_sh "
#define COLON                  "'k_uh_uu.l_uh_n "
#define SEMICOLON              "'s_e.m_ee.\"k_uh_uu.l_uh_n "
#define OPEN_ANGLE_BRACKET     "'uh_uu.p_uh_n 'aa_ng.g_uh_l 'b_r_aa.k_uh_t "
#define EQUAL_SIGN             "'ee.k_w_uh_l 's_ah_i_n "
#define CLOSE_ANGLE_BRACKET    "'k_l_uh_uu_z 'aa_ng.g_uh_l 'b_r_aa.k_uh_t "
#define QUESTION_MARK          "'k_w_e_s.ch_uh_n 'm_aw_r_k "
#define AT_SIGN                "'aa_t 's_ah_i_n "
#define A                      "'e_i "
#define B                      "'b_ee "
#define C                      "'s_ee "
#define D                      "'d_ee "
#define E                      "'ee "
#define F                      "'e_f "
#define G                      "'j_ee "
#define H                      "'e_i_ch "
#define I                      "'ah_i "
#define J                      "'j_e_i "
#define K                      "'k_e_i "
#define L                      "'e_l "
#define M                      "'e_m "
#define N                      "'e_n "
#define O                      "'uh_uu "
#define P                      "'p_ee "
#define Q                      "'k_y_uu "
#define R                      "'ar_r "
#define S                      "'e_s "
#define T                      "'t_ee "
#define U                      "'y_uu "
#define V                      "'v_ee "
#define W                      "'d_a.b_uh_l.y_uu "
#define X                      "'e_k_s "
#define Y                      "'w_ah_i "
#define Z                      "'z_ee "
#define OPEN_SQUARE_BRACKET    "'uh_uu.p_uh_n 's_k_w_e_r 'b_r_aa.k_uh_t "
#define BACKSLASH              "'b_aa_k.s_l_aa_sh "
#define CLOSE_SQUARE_BRACKET   "'k_l_uh_uu_z 's_k_w_e_r 'b_r_aa.k_uh_t "
#define CARET                  "'k_e.r_uh_t "
#define UNDERSCORE             "'a_n.d_uh_r.\"s_k_aw_r "
#define GRAVE_ACCENT           "'g_r_e_i_v 'aa_k.s_e_n_t "
#define OPEN_BRACE             "'uh_uu.p_uh_n 'b_r_e_i_s "
#define VERTICAL_BAR           "'v_uh_r.t_i.k_uh_l 'b_a_r "
#define CLOSE_BRACE            "'k_l_uh_uu_z 'b_r_e_i_s "
#define TILDE                  "'t_i_l.d_uh "
#define UNKNOWN                "uh_n.'n_uh_uu_n "

#endif /* TEXT_PARSER_ENGLISH_NUMBER_PRONUNCIATIONS_H_ */
