/***************************************************************************
 *  Copyright 1991, 1992, 1993, 1994, 1995, 1996, 2001, 2002               *
 *    David R. Hill, Leonard Manzara, Craig Schock                         *
 *                                                                         *
 *  This program is free software: you can redistribute it and/or modify   *
 *  it under the terms of the GNU General Public License as published by   *
 *  the Free Software Foundation, either version 3 of the License, or      *
 *  (at your option) any later version.                                    *
 *                                                                         *
 *  This program is distributed in the hope that it will be useful,        *
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of         *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          *
 *  GNU General Public License for more details.                           *
 *                                                                         *
 *  You should have received a copy of the GNU General Public License      *
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/
// 2014-09
// This file was copied from Gnuspeech and modified by Marcelo Y. Matuda.

#include "english/IspTrans.h"

#include <string.h>



/*  LOCAL DEFINES  ***********************************************************/
//#define MAX_TERM_VAL    622
//#define MAX_ORIGIN      1316
#define TRIE_NODES      1399
#define MIN_INDEX       '!'
#define INDEX(x)        (x - MIN_INDEX)



namespace {

/*  DATA TYPES  **************************************************************/
typedef struct _pktrie {
	char  val;
	short term_state;
	short next_org;
} pktrie;
/*  STRUCTURE MAY BE MODIFIED IF MAX_ORGIN OR MAX_TERM_VAL CAN BE CONTAINED
    IN LESS THAN AN INT  */

/*  GLOBAL VARIABLES (LOCAL TO THIS FILE)  ***********************************/
const char* m_string[] = {
	/* [!] = */ "e_k_s.k_l_uh_m_e_i_sh_uh_n_m_ar_r_k",
	/* ["] = */ "d_uh_b_uh_l_k_w_uh_uu_t",
	/* [#] = */ "X",
	/* [##] = */ "n_a_m_b_uh_r_s_ah_i_n",
	/* [#ITHer] = */ "ah_i_dh_Xer",
	/* [#Un] = */ "Xun",
	/* [#UnI] = */ "XUnI",
	/* [#Uni] = */ "XUni",
	/* [#agen] = */ "Xagen",
	/* [#alk] = */ "aa_l_k",
	/* [#allow] = */ "uh_l_Xow",
	/* [#any] = */ "e_n_ee",
	/* [#argue] = */ "XargUe",
	/* [#bUSI] = */ "b_i_XI",
	/* [#cyc] = */ "s_XYk",
	/* [#eq] = */ "XEq",
	/* [#esamin] = */ "Xexamin",
	/* [#exa] = */ "e_g_z_Xa",
	/* [#exagg] = */ "X#esag",	/* e_k_s.aa_j ?? */
	/* [#eye] = */ "XI",
	/* [#fast] = */ "f_ar_Xst",
	/* [#finIt] = */ "XfInIt",
	/* [#four] = */ "f_aw_r",
	/* [#get] = */ "g_e_t",
	/* [#gil] = */ "g_Xil",
	/* [#gn] = */ "n",
	/* [#i'] = */ "XI",
	/* [#item] = */ "ah_i_t_uh_m",
	/* [#laugh] = */ "l_ar_f",
	/* [#libr] = */ "XlIbr",
	/* [#micr] = */ "XmIcr",
	/* [#over] = */ "XOver",
	/* [#ow] = */ "uh_uu",
	/* [#pn] = */ "Xn",
	/* [#prett] = */ "Xprit",
	/* [#ps] = */ "Xs",
	/* [#psych] = */ "XsYk",
	/* [#pt] = */ "Xt",
	/* [#pull] = */ "p_u_Xl",
	/* [#read|] = */ "XrEd",
	/* [#row] = */ "r_uh_uu",
	/* [#sch] = */ "s_k",
	/* [#scien] = */ "s_ah_i.uh_n",
	/* [#there] = */ "dh_e_r",
	/* [#x] = */ "Xz",
	/* [$] = */ "d_o_l_uh_r",
	/* [%] = */ "p_uh_r_s_e_n_t",
	/* [&] = */ "aa_n_d",
	/* ['] = */ "k_w_uh_uu_t",
	/* ['#] = */ "a_n_k_w_uh_uu_t",
	/* [(] = */ "b_r_aa_k_i_t",
	/* [)] = */ "a_n_X(",
	/* [*] = */ "aa_s_t_uh_r_i_s_k",
	/* [+] = */ "p_l_a_s",
	/* [,] = */ "k_o_m_uh",
	/* [-] = */ "m_ah_i_n_uh_s",
	/* [.] = */ "p_o_i_n_t",
	/* [_] = */ "s_l_aa_sh",
	/* [0] = */ "z_i_r_uh_uu",
	/* [1] = */ "w_a_n",
	/* [2] = */ "t_uu",
	/* [3] = */ "th_r_ee",
	/* [4] = */ "f_aw_r",
	/* [5] = */ "f_ah_i_v",
	/* [6] = */ "s_i_k_s",
	/* [7] = */ "s_e_v_uh_n",
	/* [8] = */ "e_i_t",
	/* [9] = */ "n_ah_i_n",
	/* [:] = */ "k_uh_uu_l_uh_n",
	/* [;] = */ "s_e_m_i_X:",
	/* [<] = */ "l_e_s_dh_aa_n",
	/* [=] = */ "ee_k_w_uh_l_z",
	/* [>] = */ "g_r_e_i_t_uh_r_dh_aa_n",
	/* [?] = */ "k_w_e_r_i",
	/* [A] = */ "e_i",
	/* [ASIv] = */ "XAsiv",
	/* [ATHe|r] = */ "XaTHer",
	/* [Ad|or] = */ "uh_Xdor",
	/* [Anion] = */ "Xanion",
	/* [Ar] = */ "e_i_Xr",
	/* [Area] = */ "e_i_rXEa",
	/* [E] = */ "ee",
	/* [ETHe|r] = */ "XeTHer",
	/* [Edal] = */ "Xedal",
	/* [Etal] = */ "Xetal",
	/* [Eve|r] = */ "e_v_a",
	/* [I] = */ "ah_i",
	/* [ITHer] = */ "XiTHer",
	/* [Id|or] = */ "Xidor",
	/* [Ity] = */ "Xity",
	/* [It|or] = */ "Xit|or",
	/* [Ive|r] = */ "Xiver",
	/* [O] = */ "uh_uu",
	/* [OTHe|r] = */ "XoTHer",
	/* [S] = */ "Xz",
	/* [SIt] = */ "Xsit",
	/* [SIv] = */ "Xsiv",
	/* [SOn] = */ "Xson",
	/* [SiO] = */ "zh_i_uh",
	/* [Sia] = */ "zh_i_uh",
	/* [Sio] = */ "zh_i_uh",
	/* [Sis] = */ "s_i_z",
	/* [Sm] = */ "z_uh_m",
	/* [Sua] = */ "zh_XUa",
	/* [TH] = */ "dh",
	/* [U] = */ "y_uu",
	/* [Y] = */ "XI",
	/* [YTH|] = */ "i_th",
	/* [ZU] = */ "zh_XU",
	/* [[] = */ "s_k_w_e_r_X(",
	/* [\] = */ "b_aa_k_X_",
	/* []] = */ "s_k_w_e_r_X)",
	/* [^] = */ "a_p_aa_r_uh_uu",
	/* [_] = */ "a_n_d_uh_r_l_ah_i_n",
	/* [`] = */ "k_w_uh_uu_t",
	/* [a] = */ "aa",
	/* [a#] = */ "uh",
	/* [abOve] = */ "uh_b_a_v",
	/* [able|] = */ "XAble",
	/* [adjac] = */ "uh_Xjac",
	/* [ae] = */ "e",
	/* [aeo] = */ "XEo",
	/* [ae|#] = */ "XE",
	/* [ague] = */ "e_i_g_Xe",
	/* [ah#] = */ "o",
	/* [ai] = */ "XA",
	/* [al#] = */ "uh_Xl",
	/* [ald] = */ "aw_l_d",
	/* [alf#] = */ "ar_f",
	/* [alk] = */ "Xawk",
	/* [all#] = */ "Xawl",
	/* [alle|] = */ "Xawle|",
	/* [alls#] = */ "aw_Xls#",
	/* [all|ing] = */ "Xawling",
	/* [alm] = */ "ar_Xm",
	/* [als] = */ "aw_l_Xs",
	/* [alt] = */ "aw_l_Xt",
	/* [al|] = */ "uh_Xl",
	/* [amEte|r] = */ "Xameter",
	/* [answe] = */ "Xanse",
	/* [ao] = */ "XAo",
	/* [ao#] = */ "Xow",
	/* [ar] = */ "ar",
	/* [ara] = */ "aa_Xra",
	/* [archi] = */ "Xarki",
	/* [archy] = */ "Xarky",
	/* [are] = */ "aa_Xre",
	/* [ari] = */ "aa_Xri",
	/* [aro] = */ "aa_Xro",
	/* [arou] = */ "uh_Xrou",
	/* [arr] = */ "aa_Xr",
	/* [arrow] = */ "aa_r_uh_uu",
	/* [ary] = */ "e_i_r_i",
	/* [as#] = */ "uh_Xs#",
	/* [aste|] = */ "XAste|",
	/* [au] = */ "Xaw",
	/* [aw] = */ "aw",
	/* [awA] = */ "uh_XwA",
	/* [awa] = */ "uh_Xwa",
	/* [ay] = */ "XA",
	/* [a|ic] = */ "XAic",
	/* [b] = */ "b",
	/* [bUry] = */ "Xberry",
	/* [bas|ic] = */ "XbAsic",
	/* [bb] = */ "Xb",
	/* [bear] = */ "XbAr",
	/* [beaut] = */ "XbUt",
	/* [begin] = */ "XbEggin",
	/* [beit#] = */ "XbEit#",
	/* [break] = */ "XbrAk",
	/* [broad] = */ "b_r_aw_d",
	/* [bt] = */ "t",
	/* [bush] = */ "b_u_sh",
	/* [c] = */ "k",
	/* [cE] = */ "XsE",
	/* [cI] = */ "XsI",
	/* [cOl|or] = */ "Xcul|or",
	/* [cOm] = */ "Xkum",
	/* [cY] = */ "Xsy",
	/* [cast] = */ "k_aa_Xst",
	/* [ce] = */ "Xse",
	/* [cea] = */ "Xcia",
	/* [cei] = */ "XsE",
	/* [ceo] = */ "Xcio",
	/* [certain] = */ "Xserte|n",
	/* [ch] = */ "ch",	            // changed from t_sh
	/* [change] = */ "XchAnje",
	/* [chang|] = */ "XchAnj",
	/* [charact] = */ "k_e_r_uh_k_t",
	/* [chem] = */ "Xkem",
	/* [che|s#] = */ "t_sh_i_Xs#",
	/* [chor] = */ "Xkor",
	/* [ch|or] = */ "Xk|or",
	/* [ci] = */ "Xsi",
	/* [cia] = */ "sh_i_Xa",
	/* [cie] = */ "sh_i_Xe",
	/* [cio] = */ "sh_i_Xo",
	/* [ck] = */ "k",
	/* [consIde|r] = */ "Xconsider",
	/* [coord] = */ "XcOord",
	/* [countr] = */ "Xkuntr",
	/* [coupl] = */ "k_a_p_uh_l",
	/* [cour] = */ "Xkor",
	/* [creat] = */ "XcrEAt",
	/* [cuit] = */ "k_i_t",
	/* [cy] = */ "s_Xy",
	/* [c|i] = */ "Xsi",
	/* [d] = */ "d",
	/* [d#] = */ "d",
	/* [dU] = */ "d_y_uu",
	/* [dUr] = */ "d_XUr",
	/* [dange] = */ "XdAnje",
	/* [dd] = */ "Xd",
	/* [dead] = */ "Xded",
	/* [death] = */ "Xdeth",
	/* [determIn] = */ "d_i_Xtermin",
	/* [dew] = */ "XdU",
	/* [de|d] = */ "d_i_d",
	/* [discrEtion] = */ "Xdiscretion",
	/* [do|or] = */ "Xdor",
	/* [e] = */ "e",
	/* [e#] = */ "X",
	/* [e'd] = */ "XEd",
	/* [eSIv] = */ "XEsiv",
	/* [ea] = */ "ee",
	/* [eaSUr] = */ "e_zh_XUr",
	/* [eaTHe|r] = */ "XeTHe|r",
	/* [ealth] = */ "Xelth",
	/* [earch] = */ "uh_r_ch",
	/* [earl] = */ "Xerl",
	/* [earn] = */ "Xern",
	/* [earth] = */ "Xerth",
	/* [eau] = */ "XO",
	/* [ecent] = */ "XEcent",
	/* [edIt] = */ "Xedit",
	/* [ee] = */ "XE",
	/* [ei] = */ "XA",
	/* [eiTHe|r] = */ "XITHer",
	/* [eign] = */ "XAn",
	/* [ei|r] = */ "ah_i_uh",
	/* [eo] = */ "XEo",
	/* [er] = */ "er",
	/* [eri] = */ "e_r_Xi",
	/* [err] = */ "er",	/**/
	/* [erre|] = */ "er_r_Xe|",
	/* [er|i] = */ "Xeri",
	/* [es|] = */ "Xs#",
	/* [eu] = */ "Xew",
	/* [ew] = */ "y_uu",
	/* [ey] = */ "XA",
	/* [e|] = */ "X",
	/* [e|ct] = */ "Xect",
	/* [e|d|ly] = */ "i_Xdly",
	/* [e|n] = */ "uh_n",
	/* [e|r] = */ "Xer",
	/* [e|r#] = */ "uh_r",    //changed from "a"
	/* [e|sq] = */ "e_Xsq",
	/* [e|ss] = */ "Xess",
	/* [e|st] = */ "e_Xst",
	/* [e|y] = */ "XE",
	/* [f] = */ "f",
	/* [fATHe|r] = */ "f_ar_XTHer",
	/* [fast] = */ "f_aa_Xst",
	/* [feit] = */ "f_i_Xt",
	/* [ff] = */ "Xf",
	/* [finIt] = */ "Xfinit",
	/* [flowe|r] = */ "f_l_Xower",
	/* [flo|or] = */ "Xflor",
	/* [foot] = */ "f_u_Xt",
	/* [foreign] = */ "f_aw_r_i_n",
	/* [forget] = */ "Xforgget",
	/* [friend] = */ "Xfrend",
	/* [ful] = */ "f_u_Xl",
	/* [g] = */ "g",
	/* [gE] = */ "XajE",
	/* [gI] = */ "XjI",
	/* [gIv] = */ "g_i_v",
	/* [gOne] = */ "Xgon",
	/* [ge] = */ "Xje",
	/* [geous] = */ "j_Xous",
	/* [gg] = */ "g",
	/* [gh] = */ "X",
	/* [gi] = */ "Xji",
	/* [girl] = */ "g_er_l",
	/* [glio] = */ "Xlio",
	/* [good] = */ "g_u_Xd",
	/* [go|ing] = */ "g_uh_uu_i_ng",
	/* [great] = */ "XgrAt",
	/* [grow] = */ "g_r_uh_uu",
	/* [guI] = */ "g_XI",
	/* [gua] = */ "Xgwa",
	/* [guar] = */ "Xgar",
	/* [guess] = */ "g_Xess",
	/* [gue|] = */ "g_Xe|",
	/* [guis] = */ "g_i_Xs",
	/* [gy] = */ "Xjy",
	/* [g|i] = */ "Xji",
	/* [h] = */ "h",
	/* [hOn|or] = */ "Xon|or",
	/* [head] = */ "Xhed",
	/* [heard] = */ "Xherd",
	/* [heart] = */ "Xhart",
	/* [heav] = */ "h_e_v",
	/* [heigh] = */ "XhI",
	/* [hier] = */ "XhIer",
	/* [hood] = */ "h_u_Xd",
	/* [hy] = */ "XhI",
	/* [i] = */ "i",
	/* [iE] = */ "ee",
	/* [iSIv] = */ "XIsiv",
	/* [ible|#] = */ "i_b_uh_l",
	/* [ibly] = */ "i_b_l_i",
	/* [idea] = */ "XIdEa",
	/* [ie] = */ "ee",
	/* [ien] = */ "ee_Xen",
	/* [iet] = */ "XIet",
	/* [ieth] = */ "XEeth",
	/* [ieu] = */ "y_uu",
	/* [ie|st] = */ "i_uh_s_t",
	/* [ifie] = */ "XifIe",
	/* [ify] = */ "XifY",
	/* [igh] = */ "XI",
	/* [ign] = */ "XIn",
	/* [ignA] = */ "i_g_XnA",
	/* [ignI] = */ "i_g_XnI",
	/* [ignO] = */ "i_g_XnO",
	/* [igna] = */ "i_g_Xna",
	/* [igne] = */ "i_g_Xne",
	/* [igne|] = */ "XIne|",
	/* [igni] = */ "i_g_Xni",
	/* [igno] = */ "i_g_Xno",
	/* [igue|] = */ "XEg|e|",
	/* [ild#] = */ "XIld",
	/* [ind] = */ "XInd",
	/* [indI] = */ "XinndI",
	/* [inde] = */ "Xinnde",
	/* [indi] = */ "Xinndi",
	/* [indo] = */ "Xinndo",
	/* [indu] = */ "Xinndu",
	/* [io] = */ "i_Xo",
	/* [ique|] = */ "XEk|e|",
	/* [ir] = */ "uh_r",
	/* [ira] = */ "i_Xra",
	/* [iri] = */ "i_Xri",
	/* [iron] = */ "ah_i_uh_n",
	/* [irr] = */ "i_r",
	/* [ir|i] = */ "i_Xri",
	/* [isfie] = */ "XisfIe",
	/* [isfy] = */ "XisfY",
	/* [itis#] = */ "XItis",
	/* [iu] = */ "i_Xu",
	/* [j] = */ "j",
	/* [jew] = */ "j_uu",
	/* [je|s#] = */ "j_i_Xs#",
	/* [journ] = */ "Xjern",
	/* [k] = */ "k",
	/* [key] = */ "Xke",
	/* [kn] = */ "Xn",
	/* [know] = */ "n_uh_uu",
	/* [knowledg] = */ "Xnowledg",
	/* [l] = */ "l",
	/* [lOv] = */ "Xluv",
	/* [lU] = */ "l_y_uu",
	/* [lUre] = */ "l_XUre",
	/* [label] = */ "XlAbl",
	/* [last] = */ "l_ar_Xst",
	/* [lew] = */ "XlU",
	/* [limIt] = */ "Xlimit",
	/* [ll] = */ "Xl",
	/* [logy] = */ "l_a_Xgy",
	/* [lood] = */ "Xlud",
	/* [low] = */ "l_uh_uu",
	/* [l|l] = */ "Xl",
	/* [m] = */ "m",
	/* [mOne|y] = */ "Xmune|y",
	/* [mOv] = */ "m_uu_v",
	/* [machIn] = */ "m_uh_sh_XEn",
	/* [maech] = */ "Xmek",
	/* [mast] = */ "m_aa_Xst",
	/* [mm] = */ "m",
	/* [mmOn] = */ "m_a_n",
	/* [most] = */ "XmOst",
	/* [n] = */ "n",
	/* [n't] = */ "n_t",
	/* [nAtional] = */ "Xnational",
	/* [nc] = */ "ng_Xc",
	/* [nce] = */ "n_Xce",
	/* [nci] = */ "n_Xci",
	/* [ncy] = */ "n_Xcy",
	/* [nc|N] = */ "Xc|	",	/**/
	/* [ng] = */ "ng",
	/* [ngE] = */ "n_XgE",
	/* [ngU] = */ "ng_XgU",
	/* [nga] = */ "n_Xga",
	/* [nge] = */ "n_Xge",
	/* [nge|] = */ "n_Xge|",
	/* [nge|d] = */ "ng_g_Xe|d",
	/* [nge|r] = */ "ng_g_Xe|r",
	/* [nge|st] = */ "ng_g_Xe|st",
	/* [ngi] = */ "n_Xgi",
	/* [ngl] = */ "ng_Xgl",
	/* [ngo] = */ "ng_Xgo",
	/* [ngu] = */ "ng_g_w",
	/* [ngy] = */ "n_Xgy",
	/* [nk] = */ "ng_Xk",
	/* [nn] = */ "n",
	/* [nowledg] = */ "n_o_l_i_j",
	/* [nx] = */ "ng_Xx",
	/* [o] = */ "o",
	/* [o#] = */ "uh_uu",
	/* [oSIv] = */ "XOsiv",
	/* [oa] = */ "uh_uu",
	/* [obt] = */ "o_b_Xt",	/* here is where the file was chopped off!! */
	/* [oe] = */ "XOe",
	/* [off] = */ "o_Xff",
	/* [oft] = */ "o_Xft",
	/* [ofte|n] = */ "o_Xfe|n",
	/* [oi] = */ "o_i",
	/* [olk] = */ "uh_uu_k",
	/* [olld] = */ "XOld",
	/* [olt] = */ "XOlt",
	/* [om#] = */ "u_m",
	/* [oms#] = */ "u_Xms#",
	/* [on] = */ "uh_n",
	/* [on't] = */ "XOnt",
	/* [ong] = */ "o_Xng",
	/* [ons#] = */ "u_Xns#",
	/* [oo] = */ "uu",
	/* [ook] = */ "u_k",
	/* [or] = */ "o_r",
	/* [orough] = */ "a_r_a",
	/* [orrow] = */ "o_r_uh_uu",
	/* [oss#] = */ "o_Xss",
	/* [other] = */ "a_dh_a",
	/* [ou] = */ "Xow",
	/* [ou#] = */ "Xoo",
	/* [oubl] = */ "a_b_uh_l",
	/* [ough] = */ "a_Xf",
	/* [ought] = */ "aw_t",
	/* [ould] = */ "u_d",
	/* [oulde|] = */ "XOlde|",
	/* [oup] = */ "uu_p",
	/* [ource] = */ "Xorce",
	/* [ous|] = */ "Un_Xs#",
	/* [ous|ly] = */ "uh_Xsly",
	/* [ous|ness] = */ "uh_Xsness",
	/* [ow] = */ "ah_uu",
	/* [oy] = */ "Xoi",
	/* [o|or] = */ "Xoor",
	/* [p] = */ "p",
	/* [ph] = */ "f",
	/* [phe|#] = */ "Xfy#",
	/* [phe|s#] = */ "XfEs#",
	/* [phot] = */ "XfOt",
	/* [place|] = */ "XplAce|",
	/* [plac|i] = */ "XplAci",
	/* [ple|ment] = */ "p_l_uh_Xment",
	/* [plie|] = */ "XplIe",
	/* [post#] = */ "pOst",
	/* [pp] = */ "Xp",
	/* [pp|ly] = */ "XplI",
	/* [prEcious] = */ "Xprecious",
	/* [prOce|d] = */ "XprOcEd",
	/* [prOpe|r] = */ "Xproper",
	/* [prOv] = */ "p_r_uu_v",
	/* [purpOse] = */ "p_er_p_uh_Xse",
	/* [push] = */ "p_u_sh",
	/* [put#] = */ "p_u_t",
	/* [puts#] = */ "p_u_Xts#",
	/* [q] = */ "k",
	/* [qu] = */ "k_Xw",
	/* [que|] = */ "Xke|",
	/* [que|st] = */ "Xquest",
	/* [r] = */ "r",
	/* [rAtional] = */ "Xrational",
	/* [range] = */ "XrAnje",
	/* [rang|i] = */ "Xranji",
	/* [react] = */ "XrEact",
	/* [rew] = */ "r_ah_Xw",
	/* [rew#] = */ "r_uu",
	/* [rh] = */ "Xr",
	/* [rhea] = */ "XrEa",
	/* [rol] = */ "XrOl",
	/* [rolog] = */ "r_Xolog",
	/* [routIn] = */ "XrootEn",
	/* [rr] = */ "Xr",
	/* [ruit] = */ "root",
	/* [s] = */ "s",
	/* [s#] = */ "z_s",
	/* [sOme] = */ "Xsume",
	/* [sU] = */ "Xsoo",
	/* [sUr] = */ "sh_y_uu_Xr",
	/* [said] = */ "Xsed",
	/* [satisfi] = */ "XsatisfI",
	/* [scE] = */ "XcE",
	/* [sce] = */ "Xce",
	/* [sch] = */ "sh",
	/* [sci] = */ "Xci",
	/* [scle|] = */ "Xsle",
	/* [secret] = */ "XsEcret",
	/* [sew] = */ "Xsoo",
	/* [se|s#] = */ "s_i_Xs#",
	/* [sh] = */ "sh",
	/* [she|s#] = */ "sh_i_Xs#",
	/* [shoe] = */ "Xshoo",
	/* [show] = */ "sh_uh_uu",
	/* [siO] = */ "sh_i_uh",
	/* [sia] = */ "sh_i_uh",
	/* [sio] = */ "sh_i_uh",
	/* [snow] = */ "s_n_uh_uu",
	/* [spEciAl] = */ "Xspecial",
	/* [ss] = */ "Xs",
	/* [ss#] = */ "s",
	/* [ssy#] = */ "s_ee",    // changed from "s_i"
	/* [stUdie|] = */ "Xstudie|",
	/* [stUdy] = */ "Xstudy",
	/* [stead] = */ "Xsted",
	/* [stein] = */ "XstIn",
	/* [ste|n] = */ "Xse|n",
	/* [stia] = */ "s_ch_a",
	/* [stio] = */ "s_ch_s",
	/* [stl] = */ "Xsl",
	/* [stood] = */ "s_t_UD",
	/* [suA] = */ "s_w_XA",
	/* [sugg] = */ "Xsug",
	/* [suit] = */ "XsUt",
	/* [sweat] = */ "Xswet",
	/* [sy#] = */ "z_i",
	/* [t] = */ "t",
	/* [t#] = */ "t",	/* ASPIRATION t_h */
	/* [tIv] = */ "Xtiv",
	/* [tU] = */ "t_y_uu",
	/* [tUl] = */ "ch_y_uu_l",
	/* [tUr] = */ "ch_y_uu_r",
	/* [tew] = */ "XtU",
	/* [te|#] = */ "t",	/* ASPIRATION t_h */
	/* [te|d] = */ "t_i_d",
	/* [th] = */ "th",
	/* [thm] = */ "dh_uh_m",
	/* [though#] = */ "XTHo#",
	/* [threat] = */ "thret",
	/* [through] = */ "Th_r_uu",
	/* [throw] = */ "Th_r_uh_uu",
	/* [tiA] = */ "sh_i_XA",
	/* [tiOn] = */ "Xtion",
	/* [tia] = */ "sh_i_uh",
	/* [tien] = */ "sh_i_uh_n",
	/* [tio] = */ "sh_Xo",
	/* [titl] = */ "XtItl",
	/* [togETHe|r] = */ "t_u_g_e_dh_uh",
	/* [tough] = */ "Xtuch",
	/* [toward] = */ "Xtward",
	/* [truth] = */ "t_r_uu_th",
	/* [ts] = */ "t_Xs",
	/* [tt] = */ "Xt",
	/* [ttl] = */ "t_uh_l",
	/* [tua] = */ "ch_Xua",
	/* [tue] = */ "ch_Xue",
	/* [tuo] = */ "ch_Xuo",
	/* [tz] = */ "t_s",
	/* [u] = */ "a",
	/* [u#] = */ "y_uu",
	/* [uA] = */ "XUA",
	/* [uI] = */ "y_uu_",
	/* [uIn] = */ "XUin",
	/* [ua] = */ "XUa",
	/* [ue] = */ "y_uu_Xe",
	/* [ue|] = */ "XUe|",
	/* [ui] = */ "y_uu_i",
	/* [uil] = */ "i_l",
	/* [uo] = */ "XUo",
	/* [ur] = */ "uh_r",
	/* [urrow] = */ "a_r_uh_uu",
	/* [uu] = */ "XUu",
	/* [uy] = */ "XI",
	/* [u|] = */ "XU|",
	/* [v] = */ "v",
	/* [velOp] = */ "v_e_l_uh_p",
	/* [ve|y] = */ "Xvey",
	/* [w] = */ "w",
	/* [wa] = */ "w_Xaw",
	/* [wag] = */ "w_Xag",
	/* [wai] = */ "w_Xai",
	/* [walk] = */ "w_Xalk",
	/* [wang] = */ "w_Xang",
	/* [war] = */ "w_aw_r",
	/* [waste|] = */ "XwAste|",
	/* [wax] = */ "w_Xax",
	/* [way] = */ "w_Xay",
	/* [wh] = */ "h_w",
	/* [whEre] = */ "h_w_e_r",
	/* [whOl] = */ "XhOl",
	/* [what] = */ "h_w_o_t",
	/* [where] = */ "h_w_e_r",
	/* [whith] = */ "w_i_dh",
	/* [whol] = */ "XhOl",
	/* [wood] = */ "w_u_Xd",
	/* [wor] = */ "w_Xer",
	/* [wr] = */ "Xr",
	/* [x] = */ "Xks",
	/* [x#] = */ "k_s",
	/* [y] = */ "Xi",
	/* [y#] = */ "ee",
	/* [yA] = */ "i_XA",
	/* [ya] = */ "i_Xa",
	/* [ye] = */ "i_Xe",
	/* [yi] = */ "i_Xi",
	/* [yo] = */ "i_Xo",
	/* [you] = */ "y_uu",
	/* [young] = */ "y_Xung",
	/* [ys] = */ "Xy#s#",
	/* [z] = */ "z",
	/* [ze|s#] = */ "z_i_Xs#",
	/* [zz] = */ "Xz",
	/* [{] = */ "k_uh_r_l_i_X(",
	/* [|] = */ "X",
	/* [|abl] = */ "uh_b_l",
	/* [|gh] = */ "Xg",
	/* [|post] = */ "pOst",
	/* [|privAte] = */ "XprIvite",
	/* [}] = */ "k_uh_r_l_i_X)",
	/* [~] = */ "t_i_l_d_uh"
};

const pktrie trie[TRIE_NODES] = {
{'!',1,0},{'\"',2,0},{'#',3,92},{'$',46,0},{'%',47,0},{'&',48,0},{'\'',49,33},{'(',51,0},
{')',52,0},{'*',53,0},{'+',54,0},{',',55,0},{'-',56,0},{'.',57,0},{'/',58,0},{'0',59,0},
{'1',60,0},{'2',61,0},{'3',62,0},{'4',63,0},{'5',64,0},{'6',65,0},{'7',66,0},{'8',67,0},
{'9',68,0},{':',69,0},{';',70,0},{'<',71,0},{'=',72,0},{'>',73,0},{'?',74,0},{0,0,0},
{'A',75,155},{0,0,0},{0,0,0},{'#',50,0},{'E',82,168},{'#',123,0},{'A',0,985},{0,0,0},
{'I',87,179},{'I',14,0},{'H',0,27},{'#',125,0},{'#',129,0},{'I',0,50},{'O',93,282},{'I',0,127},
{'H',0,139},{'H',0,152},{'S',95,214},{'T',0,222},{'U',106,0},{'T',0,3},{'S',0,1},{'H',0,163},
{'Y',107,212},{'Z',0,216},{'[',110,0},{'\\',111,0},{']',112,0},{'^',113,0},{'_',114,0},{'`',115,0},
{'a',116,264},{'b',162,301},{'c',174,337},{'d',208,446},{'e',221,564},{'f',261,515},{'g',274,658},{'h',298,581},
{'i',308,632},{'j',352,654},{'k',356,684},{'l',361,719},{'m',374,738},{'n',383,802},{'o',409,831},{'p',450,853},
{'q',470,901},{'r',474,957},{'s',488,1012},{'t',529,1109},{'u',561,1222},{'v',577,1102},{'w',580,1118},{'x',600,1220},
{'y',602,1316},{'z',612,1160},{'{',615,0},{'|',616,1172},{'}',621,0},{'~',622,0},{'#',4,0},{'e',0,15},
{'r',5,0},{'n',6,58},{'I',7,0},{'g',0,32},{'e',0,24},{'n',9,0},{'k',10,0},{'l',0,30},
{'l',0,28},{'w',11,0},{'n',0,21},{'g',0,31},{'o',0,19},{'y',12,0},{'r',0,37},{'e',13,0},
{'U',0,4},{'y',0,48},{'c',15,0},{'u',0,43},{'q',16,0},{'a',0,44},{'s',0,53},{'i',0,45},
{'m',0,47},{'a',18,55},{'n',17,0},{'x',0,57},{'y',0,59},{'g',0,56},{'g',19,0},{'e',20,0},
{'a',0,49},{'t',21,0},{'i',8,0},{'s',0,46},{'I',0,2},{'t',22,0},{'e',0,63},{'u',0,62},
{'i',0,61},{'e',0,65},{'n',0,5},{'m',28,0},{'b',0,72},{'i',0,70},{'o',0,51},{'r',23,0},
{'U',0,20},{'l',25,0},{'n',26,0},{'a',0,67},{'t',24,0},{'g',0,81},{'i',0,88},{'u',0,79},
{'h',29,0},{'r',30,0},{'c',0,82},{'i',0,75},{'a',0,29},{'b',0,60},{'c',0,25},{'e',0,95},
{'e',0,36},{'f',0,64},{'g',0,69},{'r',31,0},{'i',0,188},{'v',0,91},{'w',33,0},{'l',0,83},
{'m',0,78},{'e',0,89},{'o',0,80},{'p',0,100},{'t',0,97},{'r',0,121},{'s',0,129},{'t',0,131},
{'r',32,0},{'n',34,0},{'y',0,119},{'x',45,0},{'t',35,0},{'r',0,101},{'s',36,90},{'t',38,0},
{'u',0,112},{'c',0,115},{'h',37,0},{'l',0,113},{'l',39,0},{'e',0,126},{'a',0,124},{'d',0,102},
{'w',41,0},{'|',40,0},{'\'',27,0},{'c',0,125},{'h',42,0},{'i',0,130},{'e',0,123},{'o',0,106},
{'n',43,0},{'e',0,122},{'h',0,133},{'r',0,136},{'e',44,0},{'S',0,7},{'T',0,9},{'e',0,117},
{'|',0,128},{'r',77,0},{'o',0,134},{'|',0,132},{'v',76,0},{'i',0,138},{'n',79,0},{'r',78,0},
{'o',0,137},{'e',0,154},{'a',81,0},{'T',0,10},{'e',0,135},{'r',83,0},{'d',0,120},{'a',0,150},
{'a',0,153},{'l',84,0},{'|',0,140},{'r',86,0},{'l',85,0},{'e',0,142},{'T',0,16},{'e',0,156},
{'n',0,141},{'|',0,146},{'|',0,162},{'d',0,159},{'r',80,149},{'r',88,0},{'r',89,0},{'y',90,0},
{'o',0,157},{'e',0,158},{'|',0,165},{'o',0,164},{'H',0,180},{'r',91,0},{'d',0,143},{'r',92,0},
{'e',0,167},{'|',0,166},{'r',94,0},{'t',0,160},{'n',98,0},{'v',0,161},{'I',0,172},{'t',96,0},
{'O',99,0},{'v',97,0},{'|',0,169},{'a',104,0},{'O',0,175},{'H',105,0},{'t',0,151},{'T',0,226},
{'v',0,173},{'H',0,176},{'#',117,0},{'|',108,0},{'U',109,0},{'v',0,204},{'O',0,184},{'t',0,66},
{'e',118,0},{'|',119,0},{'a',100,0},{'e',0,182},{'j',0,213},{'a',0,215},{'o',122,0},{'e',124,0},
{'u',0,211},{'c',120,0},{'|',132,0},{'#',131,0},{'E',0,219},{'#',133,0},{'i',0,210},{'w',0,232},
{'o',101,0},{'i',0,218},{'m',103,0},{'|',0,35},{'s',102,0},{'g',134,0},{'#',142,0},{'n',0,223},
{'e',0,206},{'|',0,220},{'u',0,195},{'l',0,207},{'e',140,0},{'r',139,0},{'t',0,228},{'s',0,201},
{'a',144,0},{'h',0,235},{'c',0,234},{'i',145,0},{'e',147,0},{'u',150,0},{'#',154,0},{'o',0,227},
{'i',148,0},{'w',152,0},{'e',0,229},{'i',0,250},{'c',161,0},{'r',0,237},{'o',149,225},{'A',158,0},
{'|',155,0},{'r',151,233},{'|',0,254},{'y',146,0},{'s',0,231},{'y',163,0},{'i',0,261},{'c',164,0},
{'y',153,0},{'b',0,224},{'t',167,0},{'d',0,203},{'e',121,200},{'T',0,205},{'g',0,196},{'h',0,41},
{'i',126,0},{'i',0,266},{'t',0,354},{'l',0,376},{'m',0,248},{'n',0,221},{'o',141,292},{'n',168,0},
{'r',166,0},{'r',143,240},{'s',0,308},{'u',0,247},{'u',156,0},{'e',0,191},{'w',157,287},{'a',159,0},
{'y',160,0},{'U',0,236},{'a',0,263},{'|',0,243},{'#',169,0},{'e',0,294},{'a',0,285},{'k',170,0},
{'g',0,265},{'a',0,303},{'i',0,255},{'s',0,283},{'h',173,0},{'a',0,242},{'b',165,0},{'o',0,297},
{'s',0,293},{'e',0,290},{'d',171,0},{'|',0,298},{'|',0,217},{'E',175,0},{'l',0,280},{'m',178,0},
{'o',0,300},{'I',176,0},{'#',127,0},{'t',180,0},{'a',182,0},{'r',177,0},{'r',0,289},{'O',0,299},
{'t',172,0},{'u',0,286},{'s',0,296},{'a',0,318},{'i',183,0},{'t',0,323},{'i',0,315},{'t',0,246},
{'n',185,0},{'Y',179,0},{'o',184,0},{'g',0,331},{'a',0,321},{'r',0,306},{'n',0,325},{'e',187,0},
{'e',0,336},{'a',0,304},{'r',0,339},{'a',0,338},{'c',0,324},{'e',181,316},{'o',0,343},{'t',189,0},
{'h',186,332},{'i',194,362},{'o',0,333},{'k',198,0},{'m',190,0},{'I',0,352},{'r',192,0},{'o',0,355},
{'s',0,470},{'s',0,373},{'r',0,379},{'d',0,361},{'|',0,350},{'u',0,381},{'|',188,0},{'|',0,328},
{'r',193,0},{'y',206,0},{'a',195,0},{'|',0,334},{'|',0,383},{'e',0,329},{'e',196,0},{'r',199,0},
{'n',0,335},{'o',0,353},{'r',0,368},{'d',200,0},{'a',0,366},{'r',201,0},{'l',202,0},{'u',0,365},
{'o',197,0},{'t',0,356},{'n',0,358},{'d',128,0},{'p',0,363},{'f',0,42},{'r',203,0},{'e',0,372},
{'#',209,0},{'t',204,0},{'k',130,0},{'l',0,281},{'m',135,0},{'i',0,371},{'t',205,0},{'i',207,0},
{'r',211,0},{'n',0,390},{'s',136,0},{'t',137,0},{'g',0,393},{'e',212,0},{'a',0,396},{'d',214,0},
{'m',0,429},{'h',215,0},{'r',0,388},{'|',138,0},{'e',0,385},{'I',0,397},{'d',218,0},{'s',0,407},
{'#',191,0},{'c',0,395},{'n',216,0},{'E',0,399},{'r',0,439},{'i',0,402},{'n',219,0},{'t',0,394},
{'o',0,401},{'t',0,400},{'t',0,405},{'|',0,408},{'w',217,0},{'r',220,0},{'o',0,404},{'d',223,0},
{'I',0,406},{'|',0,403},{'U',0,413},{'v',224,0},{'S',0,438},{'T',0,456},{'r',226,0},{'H',0,428},
{'e',0,409},{'r',227,0},{'U',210,375},{'n',0,423},{'|',0,416},{'t',0,431},{'h',228,0},{'h',229,0},
{'h',232,0},{'e',0,422},{'t',234,0},{'I',0,425},{'t',235,0},{'e',0,430},{'a',0,380},{'c',0,432},
{'T',0,476},{'d',213,0},{'e',0,398},{'H',0,441},{'r',238,0},{'l',0,418},{'i',0,389},{'e',0,443},
{'l',230,0},{'|',0,435},{'n',231,0},{'r',0,445},{'o',0,392},{'r',240,0},{'u',233,0},{'n',239,0},
{'t',0,433},{'i',243,0},{'i',246,0},{'g',0,450},{'#',256,0},{'T',0,510},{'|',245,0},{'c',0,454},
{'d',0,452},{'t',252,0},{'r',244,451},{'l',0,453},{'|',247,0},{'y',253,0},{'q',257,0},{'|',0,464},
{'s',258,0},{'t',259,0},{'n',254,0},{'A',0,482},{'|',0,458},{'H',0,485},{'r',255,530},{'s',0,462},
{'|',0,444},{'e',0,463},{'|',0,474},{'r',262,0},{'t',263,0},{'y',260,0},{'i',0,478},{'s',0,473},
{'n',0,522},{'t',264,0},{'I',0,480},{'t',266,0},{'e',0,484},{'o',0,481},{'#',222,0},{'w',0,496},
{'o',0,492},{'r',267,0},{'\'',0,420},{'o',0,494},{'|',0,490},{'r',268,0},{'r',0,508},{'|',0,488},
{'e',0,509},{'t',269,0},{'g',0,517},{'a',0,477},{'n',270,0},{'i',0,512},{'g',0,503},{'e',0,486},
{'f',265,0},{'e',0,505},{'i',0,521},{'i',0,483},{'t',271,0},{'e',0,518},{'l',0,487},{'d',272,0},
{'v',277,0},{'o',0,493},{'l',273,0},{'n',0,524},{'r',0,514},{'n',0,532},{'s',280,0},{'u',0,519},
{'e',278,0},{'o',0,525},{'l',284,0},{'i',0,528},{'d',286,0},{'a',0,534},{'o',285,0},{'r',0,527},
{'i',0,535},{'u',0,516},{'g',287,0},{'o',0,537},{'n',0,540},{'e',0,541},{'S',0,448},{'w',289,0},
{'o',0,554},{'t',288,0},{'i',297,0},{'I',290,0},{'r',292,0},{'g',0,566},{'d',301,0},{'o',0,529},
{'|',0,536},{'s',0,544},{'s',293,0},{'O',0,556},{'a',225,442},{'s',295,0},{'c',0,437},{'d',0,467},
{'e',236,0},{'n',0,548},{'|',294,0},{'r',299,0},{'i',237,461},{'h',304,0},{'t',302,0},{'|',0,538},
{'e',0,560},{'r',305,0},{'o',241,0},{'a',291,539},{'d',306,0},{'r',242,457},{'s',0,449},{'e',0,543},
{'u',248,0},{'e',0,590},{'w',249,0},{'i',0,547},{'y',250,0},{'i',0,572},{'a',0,589},{'|',251,469},
{'d',300,0},{'I',0,575},{'o',0,577},{'o',0,580},{'v',310,0},{'l',0,595},{'i',0,551},{'e',0,573},
{'|',0,752},{'e',0,602},{'a',313,0},{'h',317,0},{'E',309,0},{'y',307,0},{'r',0,555},{'n',315,0},
{'i',0,608},{'s',0,592},{'v',303,0},{'t',319,0},{'e',320,0},{'t',316,596},{'u',318,0},{'|',329,0},
{'h',322,0},{'e',0,593},{'S',0,617},{'y',312,0},{'|',332,0},{'|',0,591},{'n',323,679},{'d',0,687},
{'y',321,0},{'#',333,0},{'d',334,666},{'u',0,624},{'e',0,604},{'u',0,613},{'E',275,0},{'|',341,0},
{'n',345,0},{'b',0,586},{'I',276,507},{'d',0,597},{'e',314,594},{'f',0,600},{'g',0,609},{'i',347,0},
{'O',0,520},{'f',0,649},{'I',335,0},{'l',0,620},{'e',348,0},{'n',0,623},{'o',340,0},{'A',324,0},
{'q',0,607},{'r',342,681},{'s',0,636},{'t',0,645},{'u',351,0},{'i',0,638},{'#',350,0},{'I',325,0},
{'s',0,716},{'i',0,640},{'e',0,669},{'s',0,722},{'#',354,0},{'O',326,0},{'e',279,523},{'u',0,650},
{'g',281,0},{'h',282,0},{'i',283,526},{'r',0,663},{'o',0,643},{'l',0,531},{'e',336,0},{'y',357,0},
{'o',0,533},{'y',349,0},{'i',337,0},{'r',0,545},{'n',355,0},{'w',359,683},{'u',0,579},{'a',327,0},
{'o',338,0},{'a',343,0},{'y',296,0},{'e',328,588},{'o',0,655},{'|',0,546},{'u',339,0},{'i',330,0},
{'e',0,647},{'i',344,0},{'#',311,0},{'w',353,0},{'e',0,696},{'o',331,0},{'l',0,688},{'o',0,619},
{'|',0,641},{'n',358,670},{'r',346,0},{'d',0,694},{'g',360,0},{'O',0,682},{'r',0,700},{'v',362,0},
{'e',364,0},{'b',0,702},{'e',0,698},{'U',363,685},{'|',0,631},{'l',365,0},{'t',366,0},{'w',367,0},
{'I',0,695},{'m',0,736},{'t',368,0},{'d',371,0},{'g',0,693},{'y',370,0},{'l',373,0},{'a',0,704},
{'O',0,708},{'n',0,721},{'s',0,691},{'e',0,689},{'o',0,712},{'e',0,699},{'|',0,711},{'i',0,701},
{'n',377,0},{'v',376,0},{'l',369,0},{'h',0,846},{'w',372,0},{'o',0,710},{'c',0,729},{'y',375,0},
{'h',378,0},{'c',0,724},{'a',0,735},{'e',0,732},{'O',0,728},{'n',381,0},{'t',379,0},{'s',0,726},
{'\'',0,730},{'t',382,0},{'|',0,707},{'i',0,734},{'o',0,741},{'t',384,0},{'m',380,758},{'a',0,744},
{'o',0,725},{'s',0,723},{'n',0,751},{'l',385,0},{'t',0,739},{'e',387,0},{'N',390,0},{'E',392,0},
{'|',396,761},{'i',388,0},{'t',399,0},{'e',0,763},{'d',397,0},{'l',0,759},{'d',0,762},{'w',0,754},
{'g',407,0},{'#',410,0},{'A',0,737},{'I',0,755},{'f',415,0},{'e',0,747},{'|',0,768},{'U',393,0},
{'v',411,0},{'y',389,0},{'r',398,0},{'s',0,743},{'|',0,777},{'n',417,0},{'d',420,0},{'t',413,0},
{'k',419,0},{'l',0,779},{'t',416,769},{'a',394,0},{'#',423,0},{'t',425,0},{'\'',0,770},{'e',395,733},
{'#',427,0},{'t',421,0},{'k',429,0},{'i',400,0},{'o',0,780},{'g',0,796},{'l',401,0},{'r',0,788},
{'u',0,791},{'o',402,0},{'o',0,783},{'h',431,0},{'c',386,753},{'w',432,0},{'#',433,0},{'u',403,0},
{'g',391,787},{'e',0,797},{'s',0,868},{'y',404,0},{'k',405,0},{'h',0,805},{'r',434,0},{'n',406,0},
{'o',0,745},{'S',0,795},{'#',436,0},{'l',437,0},{'h',438,804},{'d',440,820},{'I',0,715},{'t',439,0},
{'e',0,799},{'x',408,0},{'|',441,0},{'c',0,824},{'e',443,0},{'s',0,819},{'|',444,827},{'a',412,0},
{'b',0,764},{'y',445,0},{'e',0,811},{'e',414,0},{'f',0,767},{'s',446,0},{'l',0,809},{'i',418,0},
{'n',0,830},{'|',0,918},{'l',0,774},{'m',0,940},{'n',424,848},{'o',428,784},{'o',0,835},{'e',0,814},
{'r',430,782},{'s',0,792},{'t',0,806},{'u',435,880},{'r',449,0},{'w',447,0},{'g',426,0},{'y',448,0},
{'#',452,0},{'o',0,842},{'|',0,832},{'#',453,0},{'h',451,843},{'t',454,0},{'c',0,861},{'|',455,0},
{'l',0,871},{'e',0,836},{'s',0,854},{'o',0,866},{'p',460,863},{'m',0,872},{'r',0,920},{'a',0,860},
{'i',456,0},{'u',0,892},{'|',0,857},{'e',0,847},{'e',0,867},{'t',457,0},{'#',422,0},{'i',0,878},
{'n',0,858},{'b',0,808},{'e',0,856},{'|',458,0},{'s',0,870},{'l',0,869},{'g',0,813},{'c',0,886},
{'|',0,864},{'t',0,1034},{'|',0,874},{'l',0,818},{'E',0,885},{'y',461,0},{'i',0,882},{'p',442,0},
{'o',0,879},{'r',0,825},{'s',0,803},{'u',0,883},{'c',0,899},{'s',462,0},{'O',0,898},{'e',0,877},
{'|',0,902},{'d',463,0},{'r',464,0},{'e',0,881},{'|',0,889},{'r',0,897},{'s',0,909},{'t',0,979},
{'p',0,932},{'p',0,903},{'O',0,900},{'e',466,0},{'h',467,0},{'#',468,0},{'s',0,911},{'v',465,0},
{'#',469,0},{'u',471,919},{'|',472,906},{'e',0,895},{'s',0,907},{'A',0,908},{'t',473,0},{'t',0,922},
{'o',0,916},{'n',0,931},{'i',0,914},{'a',0,923},{'g',0,929},{'e',476,0},{'l',475,0},{'i',477,0},
{'s',0,921},{'n',0,926},{'a',0,937},{'c',0,925},{'#',480,0},{'a',482,0},{'o',0,942},{'e',0,941},
{'t',478,0},{'l',483,928},{'I',0,946},{'m',0,949},{'g',484,0},{'t',0,970},{'#',489,0},{'i',0,933},
{'t',487,0},{'e',490,0},{'u',0,930},{'i',0,960},{'|',0,927},{'a',0,924},{'s',0,850},{'n',485,0},
{'w',479,1002},{'e',0,938},{'r',492,0},{'d',493,0},{'h',481,939},{'e',0,948},{'t',0,959},{'i',0,950},
{'s',0,964},{'f',0,962},{'i',494,0},{'o',0,934},{'#',459,0},{'c',0,963},{'r',486,0},{'|',499,0},
{'e',0,965},{'u',0,943},{'e',0,952},{'|',0,968},{'r',0,972},{'#',504,0},{'E',0,988},{'O',507,0},
{'t',500,0},{'s',0,1128},{'s',0,1043},{'e',505,0},{'o',0,983},{'o',0,969},{'c',0,984},{'w',510,0},
{'i',0,6},{'w',501,0},{'O',0,935},{'#',513,0},{'l',511,0},{'s',0,982},{'|',0,967},{'#',514,0},
{'U',491,945},{'a',508,0},{'d',0,998},{'E',495,0},{'e',0,980},{'w',506,0},{'i',0,1000},{'|',515,0},
{'d',517,0},{'n',518,0},{'n',519,0},{'d',523,0},{'a',0,947},{'A',524,0},{'c',0,1031},{'o',509,0},
{'e',0,971},{'U',0,999},{'a',0,1005},{'h',503,974},{'i',0,1001},{'o',0,1008},{'y',516,0},{'g',525,0},
{'e',0,1044},{'n',0,975},{'i',0,996},{'p',0,1010},{'t',526,0},{'#',528,0},{'s',512,1057},{'t',0,1029},
{'u',0,1045},{'e',0,1018},{'w',0,1020},{'e',496,0},{'y',0,1091},{'i',0,1041},{'h',497,0},{'i',498,0},
{'l',522,0},{'a',520,0},{'l',0,961},{'o',0,1007},{'a',0,1027},{'|',0,997},{'t',527,0},{'#',530,0},
{'l',533,0},{'v',531,0},{'#',536,0},{'g',0,1017},{'w',535,0},{'i',0,1009},{'r',534,0},{'o',521,0},
{'u',0,1053},{'|',0,1112},{'m',539,0},{'g',0,1054},{'o',0,1036},{'h',0,1124},{'#',540,0},{'r',0,1060},
{'e',0,1065},{'a',0,1048},{'#',502,0},{'t',541,0},{'g',0,1063},{'u',0,1062},{'h',542,0},{'w',543,0},
{'n',545,0},{'A',544,0},{'o',0,1049},{'g',0,1104},{'E',0,1092},{'n',547,0},{'l',549,0},{'T',0,1107},
{'e',0,1056},{'y',0,1061},{'H',0,1076},{'|',0,1071},{'g',0,1079},{'I',0,1028},{'h',551,0},{'O',0,1059},
{'r',550,0},{'u',0,1078},{'a',0,1075},{'w',0,1090},{'r',0,1093},{'u',0,1080},{'h',553,0},{'l',556,0},
{'d',552,0},{'U',532,1037},{'a',557,0},{'t',0,1087},{'l',570,0},{'n',565,0},{'e',558,0},{'r',0,1094},
{'|',568,0},{'a',546,0},{'e',0,1103},{'w',573,0},{'o',0,1085},{'e',0,1064},{'p',578,0},{'O',0,1095},
{'o',559,0},{'e',0,1030},{'l',0,1129},{'d',537,0},{'h',538,1046},{'i',0,1105},{'a',581,1125},{'o',548,0},
{'y',579,0},{'k',584,0},{'g',585,0},{'o',0,1069},{'t',0,1067},{'h',590,1169},{'r',0,1073},{'s',554,0},
{'t',555,1084},{'u',0,1098},{'|',0,1096},{'g',582,0},{'o',0,1142},{'i',583,0},{'z',560,0},{'r',599,0},
{'l',0,1111},{'e',0,1113},{'n',0,1116},{'t',0,1133},{'|',587,0},{'E',0,1127},{'r',586,0},{'s',0,1120},
{'r',0,1141},{'e',591,0},{'l',592,0},{'r',0,1148},{'x',588,0},{'y',589,0},{'t',593,0},{'O',0,1135},
{'e',594,0},{'t',0,1147},{'h',595,0},{'l',596,0},{'o',0,1154},{'d',597,0},{'#',601,0},{'r',598,0},
{'#',562,0},{'g',610,0},{'n',0,1155},{'u',609,1149},{'e',0,1138},{'|',0,1150},{'#',613,0},{'b',0,1159},
{'s',0,1228},{'a',0,1131},{'l',617,0},{'h',618,0},{'a',0,1166},{'e',0,1130},{'s',0,1161},{'i',0,1163},
{'o',0,1156},{'i',0,1134},{'g',0,1164},{'r',0,1167},{'t',619,0},{'A',0,1170},{'e',620,0},{'o',0,1144},
{'v',0,1213},{'z',614,0},{0,0,0},{'p',0,1162},{0,0,0},{'t',0,1178},{'A',563,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'I',564,1088},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'a',566,0},{0,0,0},
{0,0,0},{0,0,0},{'e',567,1077},{0,0,0},{0,0,0},{0,0,0},{'i',569,1089},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'o',571,0},{0,0,0},{0,0,0},{'r',572,1086},
{0,0,0},{0,0,0},{'u',574,0},{0,0,0},{0,0,0},{0,0,0},{'y',575,0},{0,0,0},
{0,0,0},{'|',576,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'#',603,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'A',604,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{0,0,0},{0,0,0},{'a',605,0},{0,0,0},{0,0,0},{0,0,0},
{'e',606,0},{0,0,0},{0,0,0},{0,0,0},{'i',607,0},{0,0,0},{0,0,0},{0,0,0},
{0,0,0},{0,0,0},{'o',608,1143},{0,0,0},{0,0,0},{0,0,0},{'s',611,0}
};

} /* namespace */

//==============================================================================

namespace GS {
namespace TextParser {
namespace English {

void
ispTrans(char *string, char *result)
{
	int i = 0, term = 0, tmp;
	const char* k;
	char *rc = NULL, tstr[1024], mstr[1024];

	strcpy(tstr, string);
	while (1) {
		if (*string && (trie[INDEX(*string) + i].val == *string)) {
			tmp = trie[INDEX(*string) + i].term_state;
			if (tmp) {
				term = tmp;
				rc = string + 1;
			}
			i = trie[INDEX(*string++) + i].next_org;
			if (i) continue;
		}

		if (!term) {
			*result = 0;
			return;
		}

		strcpy(mstr, rc);
		rc = mstr;
		k = m_string[term - 1];

		while (*k && (*k != 'X')) {
			*result++ = *k++;
		}

		string = tstr;

		if (*k) {
			k++;
		} else {
			*result++ = '_';
		}

		while (*k) {
			*string++ = *k++;
		}

		while (*rc) {
			*string++ = *rc++;
		}

		*string = 0;
		string = tstr;
		term = i = 0;
	}
}

} /* namespace English */
} /* namespace TextParser */
} /* namespace GS */
