# Awesome Static Web Site Generators

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome) [![Changelog Feed](https://mozorg.cdn.mozilla.net/media/img/trademarks/feed-icon-14x14.png)](https://github.com/myles/awesome-static-generators/commits/master/README.md.atom)

A static web site generator is an application that takes plain text files and compiles them to HTML files.

<!--lint disable alphabetize-lists-->

*   [Awesome Static Web Site Generators](#awesome-static-web-site-generators)
    *   [Blogs](#blogs)
    *   [CMS](#cms)
    *   [Documentation](#documentation)
    *   [Science](#science)
    *   [Marketing](#marketing)
    *   [Frameworks](#frameworks)
    *   [Photography](#photography)
    *   [Single Page](#single-page)
    *   [Tools](#tools)
    *   [Wikis](#wikis)
    *   [Helpful Tools and Services](#helpful-tools-and-services)
        *   [Web Hosts](#web-hosts)
    *   [Other Lists of Static Web Site Generators](#other-lists-of-static-web-site-generators)
    *   [Related Awesome](#related-awesome)
    *   [Static Web Site Generators in Other Awesome Lists](#static-web-site-generators-in-other-awesome-lists)

<!--lint enable alphabetize-lists-->

### Blogs

*   [11ty](https://www.11ty.io/) - Eleventy is a simpler static site generator. - `#JavaScript` `#Node.js`
*   [ABlog](http://ablog.readthedocs.org/) - A Sphinx extension that converts any documentation or personal website project into a full-fledged blog. - `#Python`
*   [Adduce](https://adduce.vale.rocks) - A versatile static site generator that handles both blogs and standard pages. - `#Rust`
*   [Ata's SSG](http://github.com/atas/ssg) - A PHP-based blog-aware vanilla-HTML static site generator for GitHub Pages with markdown support.
*   [Aurora](https://github.com/capjamesg/aurora) - An extensible, Python-based static site generator with support for jinja2 and markdown templates. - `#Python`
*   [BashBlog](https://github.com/cfenollosa/bashblog) - A single Bash script to create blogs. - `#Bash`
*   [Blag](https://github.com/venthur/blag) - blag is a blog-aware, static site generator -- it uses Markdown and is written in Python. - `#Python`
*   [BlazorStatic](https://github.com/tesar-tech/BlazorStatic) - Use ASP.NET Blazor to generate static pages. - `#.NET` `#C#`
*   [BlogC++](https://code.rosaelefanten.org/blogcpp/) - A static blog generator, written in C++17. - `#C++`
*   [Bloggrify](https://bloggrify.com/) - A static blog generator using Markdown, built on top of Nuxt-Content. - `#Vue.js` `#Markdown` 
*   [Cobalt](https://cobalt-org.github.io) - A Rust static site generator. - `#Rust`
*   [Coleslaw](https://github.com/coleslaw-org/coleslaw) - Flexible blog and site generator with a lot of plugins. - `#CommonLisp`
*   [CommonMark Blog for Laravel](https://github.com/spekulatius/laravel-commonmark-blog) - Static generator to use with Laravel projects. Uses CommonMark and FrontMatter to generate and publish files in the `public`-folder. Supports articles as well as listing pages `#PHP`
*   [Franklin](https://franklinjl.org/) - A static site generator written in Julia that is primarily intended for technical blogging. - `#Julia`
*   [Gitfolio](https://github.com/imfunniee/gitfolio) - A portfolio website where you could showcase your work + a blog that will help you spread your ideas into real world. - `#Node.js`
*   [Gozer](https://github.com/dannyvankooten/gozer) - Simple & fast static site generator in a single static binary. - `#Go` `#Golang`
*   [Hexo](https://github.com/hexojs/hexo) - A fast, simple & powerful blog framework. - `#JavaScript` `#Node.js`
*   [Hyde](https://github.com/hyde/hyde) - `#Python`
*   [HydePHP](https://github.com/hydephp/hyde) - Elegant and powerful static site generator with rich support for blogs, documentation sites, and more using Markdown and/or Blade - `#PHP` `#Laravel`
*   [Jamify Gatsby](https://www.jamify.org/) - Publish flaring fast blogs with Gatsby and Ghost. - `#JavaScript` `#React` `#Gastby`
*   [Jamify NextJS](https://github.com/styxlab/next-cms-ghost) - Publish flaring fast blogs with Next.js and Ghost. - `#JavaScript` `#React` `#Next.js`
*   [Jekyll](https://github.com/jekyll/jekyll) - Jekyll is a simple, blog-aware, static site generator perfect for personal, project, or organization sites. - `#Ruby`
*   [Journey](https://github.com/kabukky/journey) - `#Go`
*   [Makesite](https://github.com/sunainapai/makesite) - Simple, lightweight, and magic-free static site/blog generator (< 130 lines) for Python coders `#Python`
*   [mkws](https://mkws.sh) - simple static site generator `#sh`
*   [Nikola](https://getnikola.com/) - `#Python`
*   [Octopress](https://github.com/imathis/octopress) - Similar to Jekyll but where everything you need is already setup. - `#Ruby` `#Jekyll`
*   [Orchid Posts](https://orchid.netlify.app) - Add Jekyll-like blogging functionality to your Orchid site. - `#Orchid` `#Java` `#Kotlin`
*   [Pelican](https://github.com/getpelican/pelican) - Uses Markdown or ReST for content and Jinja2 for themes. - `#Python`
*   [PRPL](https://prpl.dev) - A modular static site generator built for longevity - `#TypeScript` `#JavaScript` `#Node.js`
*   [Qgoda](http://www.qgoda.net/) - Arbitrary taxonomies and cross-links, multi-lingua. - `#Perl`
*   [Quartz](https://quartz.jzhao.xyz/) - Batteries-included extensible Markdown renderer for your digital garden, complete with GH Pages integration and RSS. - `#TypeScript` `#Node.js`
*   [Sake](https://github.com/williamd1k0/sake) - A simple static site generator built with make. - `#make` `#Jinja2`
*   [Serum](https://dalgona.github.io/Serum/) - Serum is a static website generator written in Elixir Programming Language. - `#Elixir`
*   [Sphido](https://sphido.cz) - A rocket 🚀 fast, lightweight, static site generator `#Node.js`
*   [Spress](https://github.com/spress/Spress/) - `#PHP`
*   [Stapy](https://www.stapy.net) - Works without any additional package and without command line on Windows. - `#Python`
*   [Static](https://github.com/nakkaya/static) - Supports org-mode and markdown. - `#Clojure`
*   [Statocles](http://preaction.me/statocles/) - Markdown, code highlighting etc. ' `#Perl`
*   [Tinkerer](https://github.com/vladris/tinkerer) - `#Python`
*   [WP2Static](https://github.com/leonstafford) - WordPress static site generator for security, performance and cost benefits
*   [Xlog](https://xlog.emadelsaid.com/) - Personal knowledge management application with focus on enriching markdown files and surfacing implicit links between pages.

### CMS

*   [Arise](https://ari.se.net) - A 90s-web inspired Bash static site generator designed around slow-moving stable dependencies, modular page hierarchy, and cloud-native CI deployment. - `#Bash`
*   [Datenstrom Yellow](https://datenstrom.se/yellow/) - For people who make small websites. - `#PHP`
*   [Lektor](https://www.getlektor.com/) - An easy to use static CMS and blog engine. - `#Python`
*   [Primo](https://primo.so) - An all-in-one static site builder. - `#Svelte` `#Electron`
*   [Publii](http://getpublii.com/) - Easy-to-use desktop app to generate static websites. - `#JavaScript` `#Electron`
*   [Tipe](https://tipe.io/) - An easy to use API-first CMS engine to generate static sites. - `#JavaScript`
*   [Wordmogul](https://wordmogul.com) - Minimalistic blogging platform with ZIP export of .md files (GUI for Hugo/Jekyll). - `#Go` `#Golang`

### Documentation

*   [Docnado](https://heinventions.github.io/docnado-site) - A rapid documentation tool that will blow you away; batteries and style included. - `#Python` `#Jinja2`
*   [DocPad](https://github.com/docpad/docpad) - `#JavaScript` `#CoffeeScript` `#Node.js`
*   [Docsify](https://docsify.js.org/) - A magical documentation site generator. `#JavaScript` `#Node.js`
*   [Doctave](https://github.com/Doctave/doctave) - A batteries-included developer documentation site generator. - `#Rust`
*   [Docusaurus](https://docusaurus.io/) - Easy to maintain open source documentation websites. - `#JavaScript` `#React`
*   [MkDocs](https://www.mkdocs.org/) - Write your docs in Markdown and configure the generator with a single YAML configuration file. - `#Python`
*   [Orchid Javadoc](https://orchid.run/plugins/orchidjavadoc) - Create beautiful Javadocs for your project within your Orchid site. - `#Orchid` `#Java` `#Kotlin`
*   [Slate](https://github.com/lord/slate) - `#Ruby`
*   [Sphinx](http://sphinx-doc.org/) - `#Python`

### Science

*   [Curvenote](https://curvenote.com/docs/web) - Build scientific and technical websites for books, preprints, papers and reports using MyST Markdown and Jupyter Notebooks - `#Node.js`

### Marketing

*   [Milou](https://github.com/Tsukumogami-Software/milou) - Create beautiful and informative press kits to showcase your company and products to the medias - `#Node.js`

### Code Playground

*   [CodeStage](https://github.com/shi-yan/codestage) - A static site generator to create javascript playgrounds / interactive demos.

### Frameworks

*   [Assemble](http://assemble.io/) - `#JavaScript` `#Node.js`
*   [Astro](https://docs.astro.build/) - Framework agnostic static site generator with component-level support for partial hydration on page load, page idle, component visible or none. - `#JavaScript` `#Node.Js` `#React.js` `#Vue.js` `#Svelte.js`
*   [Blurry](https://github.com/blurry-dev/blurry) - Blurry is a schema-first, plugin-enabled static site generator. Markdown front matter directly to Schema.org types, so your content is SEO-friendly and rich results-ready out of the box. - `#Python`
*   [Bridgetown](https://www.bridgetownrb.com/) - A next-generation, progressive site generator & fullstack framework, powered by Ruby. - `#Ruby`
*   [Cactus](https://github.com/koenbok/Cactus) - `#Python`
*   [Capri](https://capri.build/) - Static site generator based on Vite with partial hydration for a variety of frameworks. - `#TypeScript` `#React.js` `#Preact` `#Solid` `#Vue` `#Svelte`
*   [Capro](https://github.com/xy2z/capro) - Flexible PHP8 static site generator, using Blade template engine. - `#PHP` `#Blade`
*   [coil](https://github.com/badosu/coil) - `#elixir`
*   [Complexity](http://complexity.readthedocs.org/en/latest/) - For those who like to work in HTML. - `#Python`
*   [ConstexprJS](https://amokfa.github.io/posts/constexprjs.html) - Evaluate and struo JS in your website ahead of time. - `#JavaScript`
*   [Cuttlebelle](https://cuttlebelle.com/) - The react static site generator that separates editing and code concerns. - `#JavaScript` `#Node.js` `#React.js`
*   [Dewar](https://github.com/tfpk/dewar) - A flask-like static site generator. - `#Python`
*   [Elder.js](https://elderguide.com/tech/elderjs/) - An opinionated, SEO focused, static site generator for Svelte.js. - `#JavaScript` `#Node.js` `#Svelte.js`
*   [Flask-Frozen](https://github.com/SimonSapin/Frozen-Flask) - Freezes a Flask application into a set of static files. - `#Python` `#Flask`
*   [Gaiden](https://github.com/kobo/gaiden) - A tool that makes it easy to create documentation with Markdown. - `#Groovy`
*   [Gatsby](https://github.com/gatsbyjs/gatsby) - `#JavaScript` `#Node.js` `#React.js`
*   [Goldsmith](https://github.com/FooSoft/goldsmith) - Fast and simple pipeline-based static site generator, extensible via plugins. `#Go`
*   [Grain](https://github.com/sysgears/grain) - `#Groovy`
*   [Gridsome](https://gridsome.org) - Vue.js-powered, modern site generator for building the fastest possible websites for any Headless CMS, APIs or Markdown-files. - `#Vue.js` `#JavaScript`
*   [Hakyll](https://github.com/jaspervdj/hakyll) - Hakyll is a Haskell library for generating static sites, mostly aimed at small-to-medium sites and personal blogs. It is written in a very configurable way and uses an xmonad-like DSL for configuration. - `#Haskell`
*   [Harp](http://harpjs.com/) - `#JavaScript` `#Node.js`
*   [Hugo](https://github.com/spf13/hugo) - It is optimized for speed, easy use and configurability. - `#Go`
*   [îles](https://iles.pages.dev) - Generates static sites with islands of interactivity - `#Vue`, `#Preact`, `#Svelte`, `#Solid`
*   [JBake](https://github.com/jbake-org/jbake) `#Java`
*   [LambdaPad](https://github.com/gar1t/lambdapad) - `#Erlang`
*   [m4-bakery](https://github.com/datagrok/makebakery) - `#make` `#m4`
*   [Metalsmith](https://github.com/segmentio/metalsmith) - An extremely simple, pluggable static site generator. - `#JavaScript` `#Node.js`
*   [Middleman](https://github.com/middleman/middleman) - Middleman is a static site generator using all the shortcuts and tools in modern web development. - `#Ruby`
*   [nanoc](https://github.com/nanoc/nanoc) - Flexible support for small personal to large corporate web sites. - `#Ruby`
*   [Nuxt.js](https://nuxtjs.org/) - Versatile vue-based framework for server-side-rendered, static and traditional single page applications.
*   [obelisk](https://github.com/BennyHallett/obelisk) - `#elixir`
*   [Orchid](https://orchid.netlify.com/) - A beautiful and truly unique documentation engine and static site generator. - `#Java` `#Kotlin`
*   [Pagegen](http://pagegen.phnd.net/) - `#Python`
*   [Phenomic](https://phenomic.io/) - Modern static website generator based on the React and Webpack ecosystem. - `#Javascript` `#Node.js` `#React.js`
*   [Publish](https://github.com/JohnSundell/Publish) - enables entire websites to be built using Swift, and supports themes, plugins and tons of other powerful customization options - `#Swift`
*   [Quarto](https://quarto.org/) - An open-source scientific and technical publishing system with literate programming in multiple languages.
*   [React Static](https://github.com/nozzle/react-static) - A progressive static-site framework for React. - `#React.js`
*   [Scully](https://github.com/scullyio/scully) - The Static Site Generator for Angular apps. - `#TypeScript` `#Angular`
*   [Sculpin](https://sculpin.io/) - `#PHP`
*   [Silssig](https://gitlab.com/olfek/silssig) - Dart powered static site generator for GitHub/GitLab pages and other similar services with support for markdown. - `#Dart`
*   [Sitegen](https://github.com/leafo/sitegen) - `#Lua` `#MoonScript`
*   [Slides](https://designmodo.com/slides/) - `#JavaScript`
*   [Soupault](https://soupault.app/) - A static site framework and post-processor that works with HTML element trees and can automatically manipulate them. - `#Lua` `#OCaml`
*   [Styx](https://styx-static.github.io/styx-site/) - The Purely Functional Static Site Generator. - `#Nix`
*   [SvelteKit](https://kit.svelte.dev/) - SvelteKit is a framework for building web applications of all sizes, with a beautiful development experience and flexible filesystem-based routing. - `#JavaScript` `#TypeScript` `#Svelte`
*   [Tags](https://github.com/braceio/tags) - `#Python`
*   [Urubu](http://urubu.jandecaluwe.com/) - `#Python`
*   [VuePress](https://vuepress.vuejs.org/) - Vue.js powered static site generator. - `#JavaScript`
*   [webgen](http://webgen.gettalong.org/) - `#Ruby`
*   [Wintersmith](https://github.com/jnordberg/wintersmith) - `#JavaScript` `#Node.js`
*   [wmk](https://github.com/bk/wmk) - Flexible and versatile, uses Mako templates - `#Python`
*   [yst](https://github.com/jgm/yst) - Powered by YAML. - `#Haskell`
*   [Zola](https://www.getzola.org) - Rust powered static site generator - `#Rust`

### Photography

*   [Expose](https://github.com/Jack000/Expose) - For photoessays. - `#Bash`
*   [foto](https://github.com/waynezhang/foto) - Yet another another publishing tool for minimalist photographers. - `#Go` `#Golang`
*   [Prosopopee](https://github.com/Psycojoker/prosopopee/) A static website generator to make beautiful customizable pictures galleries that tell a story  - `#Python`
*   [Sigal](https://sigal.readthedocs.org/en/latest/) - `#Python`

### Single Page

*   [CMS.js](https://github.com/chrisdiana/cms.js) - A fully client-side, JavaScript Markdown site generator. - `#JavaScript`
*   [Flatdoc](http://ricostacruz.com/flatdoc/) - A small JavaScript file that fetches Markdown files and renders them as full pages. - `#JavaScript`

### Tools

*   [zs](https://git.mills.io/prologic/zs) - an extremely minimal static site generator. - `#Go`

### Wikis

*   [GitBook](https://github.com/GitbookIO/gitbook) - Modern documentation format and toolchain using Git and Markdown. - `#GitBook`
*   [Gollum](https://github.com/gollum/gollum) - Gollum is a simple wiki system built on top of Git. - `#Ruby`
*   [ikiwiki](https://ikiwiki.info/) - `#Perl`
*   [mdBook](https://github.com/rust-lang/mdBook) - Create book from markdown files. Like Gitbook but implemented in Rust. - `#Rust`
*   [Orchid Wiki](https://orchid.run/wiki/learn/tutorials/how-to-document-kotlin#wiki) - A Gitbook-like wiki for your Orchid site. - `#Orchid` `#Java` `#Kotlin`

## Helpful Tools and Services

*   [Cloud 66](https://www.cloud66.com/) - Builds and deploys static websites to your own cloud account. 
*   [Formspree](http://www.formspree.io/) - Adds functional forms to your static web sites.
*   [git-annex](http://git-annex.branchable.com/tips/setup_a_public_repository_on_a_web_site/) - Configure git-annex for a public repository for a static web site.
*   [JAMStack Themes](https://jamstackthemes.dev/) - A collection of themes filterable by static site generator and CMS support.
*   [Statichunt](https://statichunt.com/) - An open sources directory of 700+ free themes and resources for static site generators submitted by the community.

### Web Hosts

*   [AWS S3](http://aws.amazon.com/s3/)
*   [Azure Static Web Apps](https://docs.microsoft.com/en-us/azure/static-web-apps/)
*   [GitLab Pages](https://about.gitlab.com/product/pages/)
*   [Kinsta Static Site Hosting](https://kinsta.com/static-site-hosting/)
*   [Netlify](https://www.netlify.com/)
*   [Surge](https://surge.sh/)
*   [Vercel](https://vercel.com)

## Other Lists of Static Web Site Generators

*   [Beginner’s Guide to Static Site Generators](https://bejamas.io/blog/static-site-generators/)
*   [Best Static Site Generators in 2019](https://snipcart.com/blog/choose-best-static-site-generator)
*   [HeadlessCMS](https://headlesscms.org/)
*   [Static Site Generators](http://staticsitegenerators.net/)
*   [StaticGen](https://www.staticgen.com/)

## Related Awesome

Awesome lists that help you with your new static web site.

*   [Awesome Bootstrap](https://github.com/therebelrobot/awesome-bootstrap) - A curated list of free Bootstrap themes.
*   [Awesome HTML5](https://github.com/diegocard/awesome-html5)
*   [Awesome Images](https://github.com/heyalexej/awesome-images) - A curated list of amazingly awesome free (stock) photo resources.
*   [Awesome Static Hosting Providers](https://github.com/b-long/awesome-static-hosting) - A collection of awesome static hosting providers and related resources.
*   [Awesome Static Website Services](https://github.com/aharris88/awesome-static-website-services) - A curated list of awesome static websites services
*   [Creative Commons Media](https://github.com/shime/creative-commons-media) - A curated list of resources that provide media licensed under Creative Commons licenses.
*   [Frontend Development](https://github.com/dypsilon/frontend-dev-bookmarks)

## Static Web Site Generators in Other Awesome Lists

*   [forhappy/awesome-lua - Static Site Generator](https://github.com/forhappy/awesome-lua#static-site-generator)
*   [h4cc/awesome-elixir - Static Page Generation](https://github.com/h4cc/awesome-elixir#static-page-generation)
*   [kdabir/awesome-groovy - Static Web](https://github.com/kdabir/awesome-groovy#static-web)
*   [markets/awesome-ruby - Static Site Generators](https://github.com/markets/awesome-ruby#static-site-generation)
*   [Sdogruyol/awesome-ruby - Static Page Generation](https://github.com/Sdogruyol/awesome-ruby#static-page-generation)
*   [sindresorhus/awesome-nodejs - Static Site Generators](https://github.com/sindresorhus/awesome-nodejs#static-site-generators)
*   [vinta/awesome-python - Static Site Generators](https://github.com/vinta/awesome-python#static-site-generator)
*   [ziadoz/awesome-php - Static Site Generators](https://github.com/ziadoz/awesome-php#static-site-generators)
