﻿// <auto-generated />
using System;
using EmployeeApi.Contexts;
using Microsoft.EntityFrameworkCore;
using Microsoft.EntityFrameworkCore.Infrastructure;
using Microsoft.EntityFrameworkCore.Metadata;
using Microsoft.EntityFrameworkCore.Migrations;
using Microsoft.EntityFrameworkCore.Storage.ValueConversion;

namespace EmployeeApi.Migrations
{
    [DbContext(typeof(EmployeeContext))]
    [Migration("20210117022701_ModifySomeOfData")]
    partial class ModifySomeOfData
    {
        protected override void BuildTargetModel(ModelBuilder modelBuilder)
        {
#pragma warning disable 612, 618
            modelBuilder
                .UseIdentityColumns()
                .HasAnnotation("Relational:MaxIdentifierLength", 128)
                .HasAnnotation("ProductVersion", "5.0.2");

            modelBuilder.Entity("EmployeeApi.Entities.Department", b =>
                {
                    b.Property<Guid>("DepartmentId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("uniqueidentifier");

                    b.Property<string>("DepartmentName")
                        .HasColumnType("nvarchar(max)");

                    b.Property<string>("Headquarter")
                        .HasColumnType("nvarchar(max)");

                    b.Property<Guid?>("ManagerEmployeeId")
                        .HasColumnType("uniqueidentifier");

                    b.Property<Guid>("ManagerId")
                        .HasColumnType("uniqueidentifier");

                    b.HasKey("DepartmentId");

                    b.HasIndex("ManagerEmployeeId");

                    b.ToTable("Departments");

                    b.HasData(
                        new
                        {
                            DepartmentId = new Guid("12345677-2ba9-473a-a40f-e38cb54f9b35"),
                            DepartmentName = "Distribution department",
                            Headquarter = "Alexandria",
                            ManagerId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b35")
                        },
                        new
                        {
                            DepartmentId = new Guid("12345678-2ba9-473a-a40f-e38cb54f9b35"),
                            DepartmentName = "Marketing department",
                            Headquarter = "Cairo",
                            ManagerId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b36")
                        });
                });

            modelBuilder.Entity("EmployeeApi.Entities.Employee", b =>
                {
                    b.Property<Guid>("EmployeeId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("uniqueidentifier");

                    b.Property<DateTimeOffset>("DateOfBirth")
                        .HasColumnType("datetimeoffset");

                    b.Property<string>("Email")
                        .IsRequired()
                        .HasColumnType("nvarchar(max)");

                    b.Property<string>("FirstName")
                        .IsRequired()
                        .HasMaxLength(50)
                        .HasColumnType("nvarchar(50)");

                    b.Property<string>("JobTitle")
                        .IsRequired()
                        .HasColumnType("nvarchar(max)");

                    b.Property<string>("LastName")
                        .IsRequired()
                        .HasMaxLength(50)
                        .HasColumnType("nvarchar(50)");

                    b.Property<string>("PhoneNumber")
                        .IsRequired()
                        .HasMaxLength(15)
                        .HasColumnType("nvarchar(15)");

                    b.Property<Guid>("departmentId")
                        .HasColumnType("uniqueidentifier");

                    b.Property<string>("picUrl")
                        .IsRequired()
                        .HasColumnType("nvarchar(max)");

                    b.Property<double>("salary")
                        .HasColumnType("float");

                    b.HasKey("EmployeeId");

                    b.HasIndex("departmentId");

                    b.ToTable("Employees");

                    b.HasData(
                        new
                        {
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b35"),
                            DateOfBirth = new DateTimeOffset(new DateTime(1964, 7, 5, 0, 0, 0, 0, DateTimeKind.Unspecified), new TimeSpan(0, 3, 0, 0, 0)),
                            Email = "First@gmail.com",
                            FirstName = "sameh",
                            JobTitle = "accountant",
                            LastName = "soltan",
                            PhoneNumber = "01200012010",
                            departmentId = new Guid("12345677-2ba9-473a-a40f-e38cb54f9b35"),
                            picUrl = "http://f.com",
                            salary = 5000.0
                        },
                        new
                        {
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b36"),
                            DateOfBirth = new DateTimeOffset(new DateTime(1977, 7, 1, 0, 0, 0, 0, DateTimeKind.Unspecified), new TimeSpan(0, 3, 0, 0, 0)),
                            Email = "Ali@gmail.com",
                            FirstName = "Ali",
                            JobTitle = "Engineer",
                            LastName = "Hassan",
                            PhoneNumber = "01200012010",
                            departmentId = new Guid("12345678-2ba9-473a-a40f-e38cb54f9b35"),
                            picUrl = "http://AliEng.com",
                            salary = 8000.0
                        },
                        new
                        {
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b37"),
                            DateOfBirth = new DateTimeOffset(new DateTime(1989, 1, 4, 0, 0, 0, 0, DateTimeKind.Unspecified), new TimeSpan(0, 2, 0, 0, 0)),
                            Email = "M@gmail.com",
                            FirstName = "Mohsen",
                            JobTitle = "HR",
                            LastName = "salman",
                            PhoneNumber = "01200012010",
                            departmentId = new Guid("12345677-2ba9-473a-a40f-e38cb54f9b35"),
                            picUrl = "http://MOHSEN.com",
                            salary = 4000.0
                        },
                        new
                        {
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b38"),
                            DateOfBirth = new DateTimeOffset(new DateTime(1978, 4, 5, 0, 0, 0, 0, DateTimeKind.Unspecified), new TimeSpan(0, 2, 0, 0, 0)),
                            Email = "So@gmail.com",
                            FirstName = "Salama",
                            JobTitle = "Developer",
                            LastName = "ahmed",
                            PhoneNumber = "01200012010",
                            departmentId = new Guid("12345678-2ba9-473a-a40f-e38cb54f9b35"),
                            picUrl = "http://salama.com",
                            salary = 2000.0
                        });
                });

            modelBuilder.Entity("EmployeeApi.Entities.EmployeeProject", b =>
                {
                    b.Property<Guid>("Id")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("uniqueidentifier");

                    b.Property<Guid>("EmployeeId")
                        .HasColumnType("uniqueidentifier");

                    b.Property<Guid>("ProjectId")
                        .HasColumnType("uniqueidentifier");

                    b.HasKey("Id");

                    b.HasIndex("EmployeeId");

                    b.HasIndex("ProjectId");

                    b.ToTable("EmployeeProjects");

                    b.HasData(
                        new
                        {
                            Id = new Guid("00000001-0000-0000-0000-000000000000"),
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b35"),
                            ProjectId = new Guid("d28888e9-1111-1111-a401-e38cb54f9b36")
                        },
                        new
                        {
                            Id = new Guid("00000002-0000-0000-0000-000000000000"),
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b35"),
                            ProjectId = new Guid("d28888e9-1111-1111-a401-e38cb54f9b36")
                        },
                        new
                        {
                            Id = new Guid("00000003-0000-0000-0000-000000000000"),
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b36"),
                            ProjectId = new Guid("d28888e9-1111-1111-a402-e38cb54f9b36")
                        },
                        new
                        {
                            Id = new Guid("00000004-0000-0000-0000-000000000000"),
                            EmployeeId = new Guid("d28888e9-2ba9-473a-a40f-e38cb54f9b37"),
                            ProjectId = new Guid("d28888e9-1111-1111-a402-e38cb54f9b36")
                        });
                });

            modelBuilder.Entity("EmployeeApi.Entities.Project", b =>
                {
                    b.Property<Guid>("ProjectId")
                        .ValueGeneratedOnAdd()
                        .HasColumnType("uniqueidentifier");

                    b.Property<double>("Budget")
                        .HasColumnType("float");

                    b.Property<double>("Profit")
                        .HasColumnType("float");

                    b.Property<string>("ProjectName")
                        .IsRequired()
                        .HasColumnType("nvarchar(max)");

                    b.HasKey("ProjectId");

                    b.ToTable("Projects");

                    b.HasData(
                        new
                        {
                            ProjectId = new Guid("d28888e9-1111-1111-a401-e38cb54f9b36"),
                            Budget = 50000.0,
                            Profit = 10000.0,
                            ProjectName = "E-commerce"
                        },
                        new
                        {
                            ProjectId = new Guid("d28888e9-1111-1111-a402-e38cb54f9b36"),
                            Budget = 8000.0,
                            Profit = 1500.0,
                            ProjectName = "Database design"
                        });
                });

            modelBuilder.Entity("EmployeeApi.Entities.Department", b =>
                {
                    b.HasOne("EmployeeApi.Entities.Employee", "Manager")
                        .WithMany()
                        .HasForeignKey("ManagerEmployeeId");

                    b.Navigation("Manager");
                });

            modelBuilder.Entity("EmployeeApi.Entities.Employee", b =>
                {
                    b.HasOne("EmployeeApi.Entities.Department", "department")
                        .WithMany("Employees")
                        .HasForeignKey("departmentId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("department");
                });

            modelBuilder.Entity("EmployeeApi.Entities.EmployeeProject", b =>
                {
                    b.HasOne("EmployeeApi.Entities.Employee", "employee")
                        .WithMany("employeeProjects")
                        .HasForeignKey("EmployeeId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.HasOne("EmployeeApi.Entities.Project", "project")
                        .WithMany("employeeProjects")
                        .HasForeignKey("ProjectId")
                        .OnDelete(DeleteBehavior.Cascade)
                        .IsRequired();

                    b.Navigation("employee");

                    b.Navigation("project");
                });

            modelBuilder.Entity("EmployeeApi.Entities.Department", b =>
                {
                    b.Navigation("Employees");
                });

            modelBuilder.Entity("EmployeeApi.Entities.Employee", b =>
                {
                    b.Navigation("employeeProjects");
                });

            modelBuilder.Entity("EmployeeApi.Entities.Project", b =>
                {
                    b.Navigation("employeeProjects");
                });
#pragma warning restore 612, 618
        }
    }
}
