<div align="center">
<img src="https://github.com/mpcgt/saguenay/blob/main/src/assets/images/logo/saguenay_white_letters.png?raw=true" alt="Logo" />
  <br /><br />
<img src="https://github.com/mpcgt/saguenay/blob/main/src/assets/images/image_readme.png?raw=true" alt="Saguenay" />

# Your network, your world. 🌍
The **Saguenay social network** is a **dynamic platform** that enables users to **create and join groups** based on their **varied interests**, such as **sports**, **art**, the **environment** and **much more**. By bringing together people who share the same **passions**, the network fosters **exchange** and **interaction** within the **community**.

**English** · [Français](./src/locales/fr/README.md) · [Español](./src/locales/es/README.md) · [Official Site](https://saguenay.vercel.app/) · [Help (Beta)](https://help.saguenay.vercel.app) · [Code of Conduct](./CODE_OF_CONDUCT.md) · [License](./LICENSE.md) 

**Share Saguenay with your family and friends!**
[![Facebook](https://img.shields.io/badge/Facebook-%231877F2.svg?style=for-the-badge&logo=Facebook&logoColor=white)](https://www.facebook.com/sharer/sharer.php?u=https://saguenay.vercel.app/) [![X](https://img.shields.io/badge/X-%23000000.svg?style=for-the-badge&logo=X&logoColor=white)](https://x.com/intent/tweet?url=https://saguenay.vercel.app/&text=Try%20Saguenay,%20the%20open-source%20social%20network,%20free%20of%20ads%20and%20weird%20trackers.%20%F0%9F%98%8E) [![Pinterest](https://img.shields.io/badge/Pinterest-%23E60023.svg?style=for-the-badge&logo=Pinterest&logoColor=white)](https://pinterest.com/pin/create/button/?url=https://saguenay.vercel.app/&media=&description=Try%20Saguenay,%20the%20open-source%20social%20network,%20free%20of%20ads%20and%20weird%20trackers.%20%F0%9F%98%8E) [![LinkedIn](https://img.shields.io/badge/linkedin-%230077B5.svg?style=for-the-badge&logo=linkedin&logoColor=white)](https://www.linkedin.com/shareArticle?mini=true&url=https://saguenay.vercel.app/) [![Gmail](https://img.shields.io/badge/Gmail-D14836?style=for-the-badge&logo=gmail&logoColor=white)](mailto:?&subject=Try%20Saguenay,%20the%20open-source%20social%20network,%20free%20of%20ads%20and%20weird%20trackers.%20%F0%9F%98%8E&cc=&bcc=&body=https://saguenay.vercel.app/%0ATry%20Saguenay,%20the%20open-source%20social%20network,%20free%20of%20ads%20and%20weird%20trackers.%20%F0%9F%98%8E)
</div>

> \[!IMPORTANT]
>
> **Star Us**, You will receive all release notifications from GitHub without any delay ⭐️

## ✨ **Features**
* **Discovery:** Allows you to **discover new or recommended content**. *This can include **suggestions for friends**, **groups** or **publications based** on the **user's preferences and interests**.
* **Groups:** Takes you to a section where you can see the **groups you belong to**, or **explore new group**s. Groups are often created around **shared interests or communities**.
* **Saved:** *Displays content that the user has **tagged or saved** for **future reference**. This can **include publications, links or articles**.
* **Messages:** Keeps you up **to date on Saguenay news**. It displays **relevant news**, **updates** or **events taking place**, to keep users **up to date** with what's going on around them.
* **Profile:** *Directs to the **user's personal profile**. This page displays **user information** such as **name**, **photo**, **bio**, **publications**, and **other personal information**.
* **Settings:** Allows you to **modify application** or **user account settings***. This typically includes **privacy preferences***, **notifications***, and **other personalization options**.
* **About:** Provides information about the **site**, such as its **mission**. This is often a place **to learn more** about the platform's **goals**.
* **Help:** **Offers help** and **support to users**. This may include **FAQs**, **support articles**, or **ways to contact technical support to solve problems**.

*Currently under development

> ✨ more features will be added when Saguenay evolve.

  
> \[!TIP]
>
> You can see the progress of the Saguenay website development [in this link](https://github.com/users/mpcgt/projects/6)

## 💻 **Technologies used**
* **Front-end:** [React](https://react.dev), [TypeScript](https://www.typescriptlang.org/), [TailwindCSS](https://tailwindui.com/)
* **Back-end:** [Node.js](https://nodejs.org) & [Vite](https://vite.dev/)
* **Database:** [Supabase](https://supabase.com/)
* **Hosting:** [Vercel](https://vercel.com)
* **AI:** [MistralAI](https://mistral.ai/)

## ⚡ **Performance**

<img src="https://github.com/mpcgt/saguenay/blob/main/src/assets/images/perf.png?raw=true" alt="Performance" />

## ⌨️ **Clone**
Clone it for local development:

```fish
$ git clone https://github.com/mpcgt/saguenay.git
$ cd saguenay
$ npm install
$ npm run dev
```
> \[!NOTE]
>
> When you go to clone, there will be several files missing (.gitignore) such as :
>
> - [x] Database configuration and dependencies (you'll have to configure these yourself).
> - [x] Dependencies, you can install modules with NPM (look in the import at the beginning of each file).

> [!CAUTION]
> IMEDIATELY replace the Saguenay images/logo with your own images (whatever you like).

## 📨 **Contact**
* **GitHub** : [GitHub](https://github.com/mpcgt/saguenay/discussions/new/choose)
* **Email** : [Email](mailto:sgn.ntwk@gmail.com)

## 📜 **LICENSE**
This project is [GNU General Public License v3.0](./LICENSE.md) licensed.