<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Illuminate\Database\Schema\Grammars; use Illuminate\Support\Fluent; use Illuminate\Database\Connection; use Illuminate\Database\Schema\Blueprint; class MySqlGrammar extends Grammar { protected $modifiers = array('Unsigned', 'Charset', 'Collate', 'Nullable', 'Default', 'Increment', 'Comment', 'After', 'First'); protected $serials = array('bigInteger', 'integer', 'mediumInteger', 'smallInteger', 'tinyInteger'); public function compileTableExists() { return 'select * from information_schema.tables where table_schema = ? and table_name = ?'; } public function compileColumnExists() { return 'select column_name as `column_name` from information_schema.columns where table_schema = ? and table_name = ?'; } public function compileCreate(Blueprint $KC3bN, Fluent $xSRI7, Connection $jhk99) { goto UunUh; ce5g2: $Ry27s .= ' table ' . $this->wrapTable($KC3bN) . " ({$tIV0x})"; goto dGDi6; Kikl1: if (isset($KC3bN->engine)) { $Ry27s .= ' engine = ' . $KC3bN->engine; } goto BvI6Z; f4FZP: $Ry27s = $KC3bN->temporary ? 'create temporary' : 'create'; goto ce5g2; dGDi6: $Ry27s = $this->compileCreateEncoding($Ry27s, $jhk99, $KC3bN); goto Kikl1; UunUh: $tIV0x = implode(', ', $this->getColumns($KC3bN)); goto f4FZP; BvI6Z: return $Ry27s; goto LYVpV; LYVpV: } protected function compileCreateEncoding($Ry27s, Connection $jhk99, Blueprint $KC3bN) { goto TO5Ln; TO5Ln: if (isset($KC3bN->charset)) { $Ry27s .= ' default character set ' . $KC3bN->charset; } elseif (!is_null($xKAeT = $jhk99->getConfig('charset'))) { $Ry27s .= ' default character set ' . $xKAeT; } goto bjQJm; elSiA: return $Ry27s; goto bJFU7; bjQJm: if (isset($KC3bN->collation)) { $Ry27s .= ' collate ' . $KC3bN->collation; } elseif (!is_null($Qtbvj = $jhk99->getConfig('collation'))) { $Ry27s .= ' collate ' . $Qtbvj; } goto elSiA; bJFU7: } public function compileAdd(Blueprint $KC3bN, Fluent $xSRI7) { goto T0llQ; S_JBr: $tIV0x = $this->prefixArray('add', $this->getColumns($KC3bN)); goto qGH3s; T0llQ: $Y2RbY = $this->wrapTable($KC3bN); goto S_JBr; qGH3s: return 'alter table ' . $Y2RbY . ' ' . implode(', ', $tIV0x); goto ATEw7; ATEw7: } public function compilePrimary(Blueprint $KC3bN, Fluent $xSRI7) { $xSRI7->name(null); return $this->compileKey($KC3bN, $xSRI7, 'primary key'); } public function compileUnique(Blueprint $KC3bN, Fluent $xSRI7) { return $this->compileKey($KC3bN, $xSRI7, 'unique'); } public function compileIndex(Blueprint $KC3bN, Fluent $xSRI7) { return $this->compileKey($KC3bN, $xSRI7, 'index'); } protected function compileKey(Blueprint $KC3bN, Fluent $xSRI7, $gJGJ7) { goto GQvP5; Hnw7F: return "alter table {$Y2RbY} add {$gJGJ7} `{$xSRI7->index}`({$tIV0x})"; goto p7AHH; My4F6: $Y2RbY = $this->wrapTable($KC3bN); goto Hnw7F; GQvP5: $tIV0x = $this->columnize($xSRI7->columns); goto My4F6; p7AHH: } public function compileDrop(Blueprint $KC3bN, Fluent $xSRI7) { return 'drop table ' . $this->wrapTable($KC3bN); } public function compileDropIfExists(Blueprint $KC3bN, Fluent $xSRI7) { return 'drop table if exists ' . $this->wrapTable($KC3bN); } public function compileDropColumn(Blueprint $KC3bN, Fluent $xSRI7) { goto Bl_00; Bl_00: $tIV0x = $this->prefixArray('drop', $this->wrapArray($xSRI7->columns)); goto x00xk; x00xk: $Y2RbY = $this->wrapTable($KC3bN); goto GlXMa; GlXMa: return 'alter table ' . $Y2RbY . ' ' . implode(', ', $tIV0x); goto DsJrI; DsJrI: } public function compileDropPrimary(Blueprint $KC3bN, Fluent $xSRI7) { return 'alter table ' . $this->wrapTable($KC3bN) . ' drop primary key'; } public function compileDropUnique(Blueprint $KC3bN, Fluent $xSRI7) { $Y2RbY = $this->wrapTable($KC3bN); return "alter table {$Y2RbY} drop index `{$xSRI7->index}`"; } public function compileDropIndex(Blueprint $KC3bN, Fluent $xSRI7) { $Y2RbY = $this->wrapTable($KC3bN); return "alter table {$Y2RbY} drop index `{$xSRI7->index}`"; } public function compileDropForeign(Blueprint $KC3bN, Fluent $xSRI7) { $Y2RbY = $this->wrapTable($KC3bN); return "alter table {$Y2RbY} drop foreign key `{$xSRI7->index}`"; } public function compileRename(Blueprint $KC3bN, Fluent $xSRI7) { $wZ0QM = $this->wrapTable($KC3bN); return "rename table {$wZ0QM} to " . $this->wrapTable($xSRI7->to); } protected function typeChar(Fluent $xiZoD) { return "char({$xiZoD->length})"; } protected function typeString(Fluent $xiZoD) { return "varchar({$xiZoD->length})"; } protected function typeText(Fluent $xiZoD) { return 'text'; } protected function typeMediumText(Fluent $xiZoD) { return 'mediumtext'; } protected function typeLongText(Fluent $xiZoD) { return 'longtext'; } protected function typeBigInteger(Fluent $xiZoD) { return 'bigint'; } protected function typeInteger(Fluent $xiZoD) { return 'int'; } protected function typeMediumInteger(Fluent $xiZoD) { return 'mediumint'; } protected function typeTinyInteger(Fluent $xiZoD) { return 'tinyint'; } protected function typeSmallInteger(Fluent $xiZoD) { return 'smallint'; } protected function typeFloat(Fluent $xiZoD) { return $this->typeDouble($xiZoD); } protected function typeDouble(Fluent $xiZoD) { if ($xiZoD->total && $xiZoD->places) { return "double({$xiZoD->total}, {$xiZoD->places})"; } return 'double'; } protected function typeDecimal(Fluent $xiZoD) { return "decimal({$xiZoD->total}, {$xiZoD->places})"; } protected function typeBoolean(Fluent $xiZoD) { return 'tinyint(1)'; } protected function typeEnum(Fluent $xiZoD) { return 'enum(\'' . implode('\', \'', $xiZoD->allowed) . '\')'; } protected function typeJson(Fluent $xiZoD) { return 'text'; } protected function typeJsonb(Fluent $xiZoD) { return 'text'; } protected function typeDate(Fluent $xiZoD) { return 'date'; } protected function typeDateTime(Fluent $xiZoD) { return 'datetime'; } protected function typeDateTimeTz(Fluent $xiZoD) { return 'datetime'; } protected function typeTime(Fluent $xiZoD) { return 'time'; } protected function typeTimeTz(Fluent $xiZoD) { return 'time'; } protected function typeTimestamp(Fluent $xiZoD) { goto m3jUG; m3jUG: if ($xiZoD->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto Kg2bx; fuTGF: return 'timestamp'; goto t4XGa; Kg2bx: if (!$xiZoD->nullable && $xiZoD->default === null) { return 'timestamp default 0'; } goto fuTGF; t4XGa: } protected function typeTimestampTz(Fluent $xiZoD) { goto Qx93k; rNWYj: if (!$xiZoD->nullable && $xiZoD->default === null) { return 'timestamp default 0'; } goto H1cw3; Qx93k: if ($xiZoD->useCurrent) { return 'timestamp default CURRENT_TIMESTAMP'; } goto rNWYj; H1cw3: return 'timestamp'; goto T8Nwc; T8Nwc: } protected function typeBinary(Fluent $xiZoD) { return 'blob'; } protected function typeUuid(Fluent $xiZoD) { return 'char(36)'; } protected function modifyUnsigned(Blueprint $KC3bN, Fluent $xiZoD) { if ($xiZoD->unsigned) { return ' unsigned'; } } protected function modifyCharset(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->charset)) { return ' character set ' . $xiZoD->charset; } } protected function modifyCollate(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->collation)) { return ' collate ' . $xiZoD->collation; } } protected function modifyNullable(Blueprint $KC3bN, Fluent $xiZoD) { return $xiZoD->nullable ? ' null' : ' not null'; } protected function modifyDefault(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->default)) { return ' default ' . $this->getDefaultValue($xiZoD->default); } } protected function modifyIncrement(Blueprint $KC3bN, Fluent $xiZoD) { if (in_array($xiZoD->type, $this->serials) && $xiZoD->autoIncrement) { return ' auto_increment primary key'; } } protected function modifyFirst(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->first)) { return ' first'; } } protected function modifyAfter(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->after)) { return ' after ' . $this->wrap($xiZoD->after); } } protected function modifyComment(Blueprint $KC3bN, Fluent $xiZoD) { if (!is_null($xiZoD->comment)) { return ' comment "' . $xiZoD->comment . '"'; } } protected function wrapValue($ib3B9) { if ($ib3B9 === '*') { return $ib3B9; } return '`' . str_replace('`', '``', $ib3B9) . '`'; } }