@extends($_viewFrame)

@section('pageTitleMain'){{$asset['title']}}@endsection
@section('pageKeywords'){{$asset['title']}}@endsection
@section('pageDescription'){{$asset['description']?$asset['description']:$asset['title']}}@endsection

{!! \ModStart\ModStart::js('asset/common/timeago.js') !!}
{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
{!! \ModStart\ModStart::js('asset/common/clipboard.js') !!}
{!! \ModStart\ModStart::style('.pb-res-asset-page img{width:100%;min-height:200px;}') !!}

@section('bodyContent')

    <div class="ub-container">
        <div class="ub-breadcrumb">
            <a href="{{modstart_web_url('res')}}">资源</a>
            @foreach($asset['_categoryChain'] as $category)
                <a href="{{\Module\Res\Util\UrlUtil::category($category)}}">{{$category['title']}}</a>
            @endforeach
        </div>
        <div class="">
            <div class="row">
                <div class="col-md-8">
                    <div class="tw-bg-white tw-p-3 tw-rounded margin-bottom">
                        @if(in_array($asset['verifyStatus'],[
                            \Module\Res\Type\ResAssetVerifyStatus::VERIFY_REJECT,
                            \Module\Res\Type\ResAssetVerifyStatus::VERIFYING,
                        ]))
                            <div class="ub-alert warning">
                                当前资源状态为 <b>{{\ModStart\Core\Type\TypeUtil::name(\Module\Res\Type\ResAssetVerifyStatus::class,$asset['verifyStatus'])}}</b>，只有您自己可以看到该资源
                            </div>
                        @endif
                        @if($asset['convertStatus']==\Module\Res\Type\ResAssetConvertStatus::PROCESS_SUCCESS)
                            @if($asset['previewType']==\Module\Res\Type\ResAssetPreviewType::IMAGES)
                                <div class="tw-bg-gray-200 tw-border-2 tw-border-solid tw-border-gray-200 tw-rounded">
                                    @foreach($asset['previewData']['images'] as $index=>$pagePreview)
                                        <div class="pb-res-asset-page tw-bg-white tw-mb-2 tw-min-h-10">
                                            <img src="@asset('vendor/Res/image/loading.svg')" data-src="{{\ModStart\Core\Assets\AssetsUtil::fix($pagePreview)}}" alt="{{$asset['title']}}第{{$index+1}}页" />
                                        </div>
                                    @endforeach
                                </div>
                            @else
                                @include('module::Res.View.pc.res.inc.previewEmpty')
                            @endif
                        @else
                            @include('module::Res.View.pc.res.inc.previewEmpty')
                        @endif
                        <div class="row margin-top">
                            <div class="col-md-8">
                                <div class="tw-inline-block">@include('module::Vendor.View.public.shareButtons')</div>
                            </div>
                            <div class="col-md-4 tw-text-right">
                                <div class="tw-flex-1 tw-leading-10">
                                    @if(modstart_module_enabled('MemberFav'))
                                        @include('module::MemberFav.View.inc.favBtn',['biz'=>\Module\Res\Core\ResMemberFavBiz::NAME,'bizId'=>$asset['id']])
                                    @endif
                                    @if(modstart_module_enabled('MemberLike'))
                                        @include('module::MemberLike.View.inc.likeBtn',['biz'=>\Module\Res\Core\ResMemberLikeBiz::NAME,'bizId'=>$asset['id']])
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                    @if(modstart_config('Res_DownloadTip'))
                        <div class="ub-panel margin-bottom">
                            <div class="head">
                                <div class="title">下载提示</div>
                            </div>
                            <div class="body">
                                <div class="ub-html lg">
                                    {!! modstart_config('Res_DownloadTip') !!}
                                </div>
                            </div>
                        </div>
                    @endif
                    @if(modstart_module_enabled('MemberRate'))
                        <div class="margin-bottom">
                            @include('module::MemberRate.View.inc.rate',['biz'=>\Module\Res\Core\ResMemberRateBiz::NAME,'bizId'=>$asset['id']])
                        </div>
                    @endif
                </div>
                <div class="col-md-4">
                    <div class="tw-px-3 tw-bg-white tw-rounded margin-bottom tw-py-3">
                        <h1 class="tw-break-all">
                            {{$asset['title']}}
                        </h1>
                        <div class="tw-text-gray-500 tw-my-2">
                            @if(!empty($asset['tags']))
                                @foreach($asset['tags'] as $t)
                                    <a href="{{\Module\Res\Util\UrlUtil::search($t)}}"
                                       class="tw-bg-gray-100 tw-rounded tw-inline-block tw-px-2 tw-text-gray-800">{{$t}}</a>
                                @endforeach
                            @endif
                        </div>
                        @if(!empty($asset['fileExt']))
                            <div class="ub-pair">
                                <div class="name">
                                    <i class="iconfont icon-file"></i> 格式
                                </div>
                                <div class="value">
                                    {{ strtoupper($asset['fileExt']) }}
                                </div>
                            </div>
                        @endif
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-download"></i> 下载
                            </div>
                            <div class="value">
                                {{ empty($asset['downloadCount']) ? '0' : $asset['downloadCount'] }}
                            </div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-time"></i> 时间
                            </div>
                            <div class="value">
                                {{ date('Y-m-d',strtotime($asset['created_at'])) }}
                            </div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-eye"></i> 浏览
                            </div>
                            <div class="value">
                                {{ empty($asset['viewCount']) ? '0' : $asset['viewCount'] }}
                            </div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-star"></i> 收藏
                            </div>
                            <div class="value">
                                {{empty($asset['favoriteCount'])?0:$asset['favoriteCount']}}
                            </div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-heart-alt"></i> 喜欢
                            </div>
                            <div class="value">
                                {{empty($asset['likeCount'])?0:$asset['likeCount']}}
                            </div>
                        </div>
                        <div class="ub-pair">
                            <div class="name">
                                <i class="iconfont icon-magic-wand"></i> 评分
                            </div>
                            <div class="value">
                                {{empty($asset['rateAvg'])?'-':sprintf('%.1f',$asset['rateAvg']/10.0)}}
                            </div>
                        </div>
                        @if($asset['freeStatus']==\Module\Res\AssetAccess\Type\FreeStatus::FREE)
                            <div>
                                免费资源
                            </div>
                        @else
                            <div class="ub-pair">
                                <div class="name">
                                    <i class="iconfont icon-cny"></i> 价格
                                </div>
                                <div class="value">
                                    @if($asset['creditStatus']==\Module\Res\AssetAccess\Type\CreditStatus::ENABLE)
                                        {{$asset['creditCost']}}积分
                                    @endif
                                    @if($asset['creditStatus']==\Module\Res\AssetAccess\Type\CreditStatus::ENABLE && $asset['moneyStatus']==\Module\Res\AssetAccess\Type\MoneyStatus::ENABLE)
                                        或
                                    @endif
                                    @if($asset['moneyStatus']==\Module\Res\AssetAccess\Type\MoneyStatus::ENABLE)
                                        ￥{{$asset['moneyCost']}}
                                    @endif
                                </div>
                            </div>
                        @endif
                        <div class="tw-py-3 ub-text-muted">
                            本资源由
                            <a href="{{modstart_web_url('res/member-'.$asset['memberUserId'])}}" target="_blank">{{$asset['_memberUser']['nickname']}}</a>
                            于
                            <time datetime="{{$asset['created_at']}}"></time>
                            上传分享
                        </div>
                        <div id="ResDownloadContainer"
                             data-hash="{{$asset['hash']}}">
                            <div class="data-container"></div>
                        </div>
                        {!! \ModStart\ModStart::js('asset/vendor/vue.js') !!}
                        {!! \ModStart\ModStart::js('asset/vendor/element-ui/index.js') !!}
                        {!! \ModStart\ModStart::js('vendor/Res/entry/download.js') !!}
                        @if(modstart_module_enabled('Ad'))
                            {!! \Module\Ad\View\AdView::simple('Res_DocContent') !!}
                        @endif
                    </div>
                    @if(!empty($asset['description']))
                        <div class="ub-panel">
                            <div class="head">
                                <div class="title">
                                    资源介绍
                                </div>
                            </div>
                            <div class="body">
                                <div class="ub-html">
                                    {!! \ModStart\Core\Util\HtmlUtil::text2html($asset['description']) !!}
                                </div>
                            </div>
                        </div>
                    @endif
                    <div class="ub-panel">
                        <div class="head">
                            <div class="title">
                                推荐资源
                            </div>
                        </div>
                        <div class="body">
                            @include('module::Res.View.pc.res.inc.itemsList',['records'=>$recommendAssets])
                        </div>
                    </div>
                    <div class="ub-panel">
                        <div class="head">
                            <div class="title">
                                最新资源
                            </div>
                        </div>
                        <div class="body">
                            @include('module::Res.View.pc.res.inc.itemsList',['records'=>$latestAssets])
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
