@extends($_viewFrame)

@section('pageTitleMain'){{$category?$category['title']:'资源列表'}}@endsection
@section('pageKeywords'){{$category?$category['title']:'资源列表'}}@endsection
@section('pageDescription'){{$category?$category['desc']:'资源列表'}}@endsection

{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
@section('bodyContent')

    <div class="ub-container margin-top margin-bottom">

        <div class="row">
            <div class="col-md-9">

                <div class="ub-nav-group">
                    @foreach($categoryChain as $catIndex=>$catItem)
                        <div class="group">
                            @if($catIndex==0)
                                <div class="label">
                                    <div class="text"><i class="iconfont icon-category"></i> 分类</div>
                                </div>
                            @endif
                            <div class="items">
                                <a href="{{modstart_web_url('res/list'.($catItem['pid']?'-'.$catItem['pid']:''))}}"
                                   class="@if($catItem['id']<=0) active @endif">全部</a>
                                @foreach($catItem['_items'] as $item)
                                    <a href="{{\Module\Res\Util\UrlUtil::category($item)}}"
                                       class="@if($catItem['id']==$item['id']) active @endif"
                                    >{{$item['title']}}</a>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                    @foreach($catGroups as $group)
                        <div class="group">
                            <div class="label">
                                <div class="text">
                                    <i class="{{$group['icon']}}"></i>
                                    {{$group['title']}}
                                </div>
                            </div>
                            <div class="items">
                                <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['catIds'=>$group['_urlCatIds']])}}"
                                   class="{{\ModStart\Core\Util\ArrayUtil::hasAny($group['_catIds'],$catIds)?'':'active'}}">全部</a>
                                @foreach($group['_cats'] as $cat)
                                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['catIds'=>$cat['_urlCatIds']])}}"
                                       class="{{in_array($cat['id'],$catIds)?'active':''}}"
                                    >{{$cat['title']}}</a>
                                @endforeach
                            </div>
                        </div>
                    @endforeach
                    @if(!empty($extList))
                        <div class="group">
                            <div class="label">
                                <div class="text">
                                    <i class="iconfont icon-file"></i>
                                    格式
                                </div>
                            </div>
                            <div class="items">
                                <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['ext'=>null])}}"
                                   class="{{$ext?'':'active'}}">全部</a>
                                @foreach($extList as $extItem)
                                    <a href="?{{\ModStart\Core\Input\Request::mergeQueries(['ext'=>$extItem['k']])}}"
                                       class="{{$ext==$extItem['k']?'active':''}}"
                                    >{{strtoupper($extItem['k'])}}</a>
                                @endforeach
                            </div>
                        </div>
                    @endif
                </div>
                <div class="tw-p-4 tw-bg-white tw-rounded margin-top">
                    @include('module::Res.View.pc.res.inc.items',['records'=>$records])
                    <div class="ub-page">
                        {!! $pageHtml !!}
                    </div>
                </div>
            </div>
            <div class="col-md-3">

                <div class="ub-content-box margin-bottom">
                    <a href="{{modstart_web_url('member_res/upload')}}" class="btn btn-lg btn-primary btn-block btn-round">
                        <i class="iconfont icon-upload"></i>
                        上传素材
                    </a>
                </div>

                @if(modstart_module_enabled('Ad'))
                    <div class="margin-bottom">
                        {!! \Module\Ad\View\AdView::simple('Res_DocListRight') !!}
                    </div>
                @endif
                <div class="ub-panel margin-bottom">
                    <div class="head">
                        <div class="title">
                            热门关注
                        </div>
                    </div>
                    <div class="body">
                        @include('module::Res.View.pc.res.inc.itemsList',['records'=>$hottestAssets])
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
