@extends($_viewFrame)

@section('pageTitle'){{modstart_config('siteName').' | '.modstart_config('siteSlogan')}}@endsection
@section('pageDescription'){{modstart_config('siteDescription')}}@endsection
@section('pageKeywords'){{modstart_config('siteKeywords')}}@endsection

@section('headAppend')
    @parent
    <style type="text/css">
        .pb-home-banner{
            position: relative;
        }
        .pb-home-banner .ub-search-block{
            position: absolute;
            left: 0;
            right: 0;
            bottom: 0;
            top: 0;
            z-index: 100;
            background: rgba(0,0,0,0.1);
            display: flex;
            flex-direction: column;
            justify-content: center;
            pointer-events: none;
        }
        .pb-home-banner .ub-search-block .content-container .box-content{
            pointer-events: auto;
        }
    </style>
@endsection

{!! \ModStart\ModStart::js('asset/common/lazyLoad.js') !!}
@section('bodyContent')

    <div class="pb-home-banner">
        {!! \Module\Banner\View\BannerView::basic('ResHome',null,'4-1') !!}
        <div class="ub-search-block">
            <div class="content-container">
                <div class="title">
                    {{modstart_config('Res_Slogan','一站式资源管理中心')}}
                </div>
                <div class="form">
                    <form action="{{\Module\Res\Util\UrlUtil::search()}}" method="get">
                        <div class="box box-content">
                            <input type="text" name="keywords" class="form form-lg" placeholder="输入关键词搜索内容"/>
                            <button type="submit" class="btn btn-lg"><i class="iconfont icon-search"></i> 搜索</button>
                        </div>
                        @if(modstart_module_enabled('HotSearch'))
                            <div class="box-content tw-text-center tw-mt-4 tw-text-white tw-mx-20">
                                热门搜索：
                                @foreach(\Module\HotSearch\Util\HotSearchUtil::hotKeywords() as $hotKeywords)
                                    <a href="{{\Module\Res\Util\UrlUtil::search($hotKeywords['keywords'])}}"
                                       class="tw-text-white tw-rounded-3xl tw-bg-black tw-bg-opacity-30 tw-px-4 tw-leading-6 tw-inline-block hover:tw-text-white"
                                    >{{$hotKeywords['keywords']}}</a>
                                @endforeach
                            </div>
                        @endif
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="tw-p-3 tw-shadow-lg tw-bg-white tw--mt-2 margin-bottom">
        <div class="ub-container tw-text-center">
            <i class="iconfont icon-image ub-text-primary"></i>
            当前总素材
            <span class="tw-font-bold ub-text-primary">
                {{number_format(\Module\Res\Util\ResAssetUtil::getTotal())}}
            </span>
            个
            &nbsp;&nbsp;&nbsp;&nbsp;
            <i class="iconfont icon-vip ub-text-primary"></i>
            VIP专享
            <span class="tw-font-bold ub-text-primary">
                {{number_format(\Module\Res\Util\ResAssetUtil::getVipTotal())}}
            </span>
            个
            &nbsp;&nbsp;&nbsp;&nbsp;
            <a href="{{modstart_web_url('member_res/upload')}}" class="ub-text-primary">
                <i class="iconfont icon-upload"></i>
                我来上传素材
            </a>
        </div>
    </div>

    <div class="ub-container margin-bottom">
        <div class="ub-content-box">
            <div class="row">
                @foreach(\Module\Res\Util\ResCategoryUtil::categoryTree() as $c)
                    @if(!empty($c['_child']) && !empty($c['showHome']))
                        <div class="col-md-3">
                            <div class="ub-nav-category">
                                <a class="group-title" href="{{\Module\Res\Util\UrlUtil::category($c)}}">
                                    <span class="ub-cover-1-1 tw-w-5 tw-bg-gray-200 tw-rounded tw-align-middle"
                                          style="display:inline-block;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($c['cover'])}})"></span>
                                    {{$c['title']}}
                                </a>
                                <div class="group-list">
                                    @foreach($c['_child'] as $cc)
                                        @if(!empty($cc['showHome']))
                                            <a class="item"
                                               href="{{\Module\Res\Util\UrlUtil::category($cc)}}">{{$cc['title']}}</a>
                                        @endif
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>

    <div class="ub-container margin-bottom">

        <div class="row">
            <div class="col-md-9">
                @foreach(\Module\Res\Util\ResCategoryUtil::categoryTree() as $c)
                    @if($c['showHome'])
                        <div class="ub-content-box margin-bottom">
                            <div class="tw-flex">
                                <div class="tw-flex-grow">
                                    <a class="tw-text-gray-600" href="{{\Module\Res\Util\UrlUtil::category($c['id'])}}">
                                        <div class="ub-cover-1-1 tw-w-5 tw-bg-gray-200 tw-rounded tw-align-middle"
                                             style="display:inline-block;background-image:url({{\ModStart\Core\Assets\AssetsUtil::fix($c['cover'])}})"></div>
                                        {{$c['title']}}
                                    </a>
                                    <div class="tw-inline-block tw-text-sm ub-text-tertiary tw-pl-2">
                                        {{$c['desc']}}
                                    </div>
                                </div>
                                <div>
                                    <a href="{{\Module\Res\Util\UrlUtil::category($c['id'])}}" class="ub-text-muted">
                                        更多
                                        <i class="iconfont icon-angle-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div>
                            <div class="row">
                                @foreach(\Module\Res\Util\ResAssetUtil::listCategoryRecommendLatest($c['id']) as $record)
                                    <div class="col-md-2 col-4">
                                        @include('module::Res.View.pc.res.inc.itemCover')
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    @endif
                @endforeach
            </div>
            <div class="col-md-3">

                @if(modstart_module_enabled('Ad'))
                    {!! \Module\Ad\View\AdView::simple('ResHomeRight') !!}
                @endif

                @if(modstart_module_enabled('News'))
                    {!! \Module\News\View\NewsView::latest() !!}
                @endif

                <div class="ub-panel">
                    <div class="head">
                        <div class="title">
                            <i class="iconfont icon-time ub-text-primary"></i>
                            最新上传
                        </div>
                    </div>
                    <div class="body">
                        @include('module::Res.View.pc.res.inc.itemsList',['records'=>$latestRecords])
                    </div>
                </div>

            </div>
        </div>
    </div>

    <div class="ub-container">
        {!! \Module\Partner\View\PartnerView::simple('resHome') !!}
    </div>

@endsection
