<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Res\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Admin\Layout\AdminPage; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\FileUtil; use ModStart\Data\DataManager; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use ModStart\Widget\TextDialogRequest; use Module\Member\Util\MemberVipUtil; use Module\Res\AssetAccess\Type\CreditStatus; use Module\Res\AssetAccess\Type\FreeStatus; use Module\Res\AssetAccess\Type\MoneyStatus; use Module\Res\AssetAccess\Type\VipStatus; use Module\Res\Core\ResTagManagerBiz; use Module\Res\Job\ResAssetProcessJob; use Module\Res\Type\ResAssetConvertStatus; use Module\Res\Type\ResAssetFileType; use Module\Res\Type\ResAssetVerifyStatus; use Module\Res\Util\ResAssetUtil; class ResAssetController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $lZifj) { $lZifj->init('res_asset')->field(function ($lZifj) { $lZifj->id('id', 'ID'); $lZifj->type('verifyStatus', '审核状态')->type(ResAssetVerifyStatus::class); $lZifj->type('convertStatus', '转换状态')->type(ResAssetConvertStatus::class); $lZifj->switch('isRecommend', '推荐')->optionsYesNo()->gridEditable(true); $lZifj->select('categoryId', '分类')->optionModelTree('res_category'); $lZifj->text('title', '标题')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { switch ($pZ_lR->renderMode()) { case FieldRenderMode::DETAIL: case FieldRenderMode::GRID: return AutoRenderedFieldValue::make('<a href="' . modstart_web_url('res/' . $jIWZA->hash) . '" target="_blank">' . htmlspecialchars($jIWZA->title) . '</a>'); } return null; }); $lZifj->tags('tags', '标签')->serializeAsColonSeparated()->editable(false); $lZifj->radio('freeStatus', '付费')->optionType(FreeStatus::class)->defaultValue(FreeStatus::FREE)->listable(true)->when('=', FreeStatus::FEE, function ($lZifj) { $lZifj->radio('vipStatus', 'VIP特权')->optionType(VipStatus::class)->defaultValue(VipStatus::DISABLE)->when('=', VipStatus::ENABLE, function ($lZifj) { $lZifj->checkbox('vipIds', 'VIP')->options(MemberVipUtil::mapTitle()); }); $lZifj->radio('creditStatus', '积分购买')->optionType(CreditStatus::class)->defaultValue(CreditStatus::DISABLE)->when('=', CreditStatus::ENABLE, function ($lZifj) { $lZifj->number('creditCost', '积分')->defaultValue(0); }); $lZifj->radio('moneyStatus', '现金购买')->optionType(MoneyStatus::class)->defaultValue(MoneyStatus::DISABLE)->when('=', MoneyStatus::ENABLE, function ($lZifj) { $lZifj->decimal('moneyCost', '现金')->defaultValue(0); }); }); $lZifj->display('_count', '访问/评论/评分')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { $AZvp2 = array(); $AZvp2[] = intval($jIWZA->viewCount); $AZvp2[] = intval($jIWZA->commentCount); $AZvp2[] = intval($jIWZA->rateAvg); return AutoRenderedFieldValue::make(join(' / ', $AZvp2)); })->listable(true)->showable(true); $lZifj->display('_countBase', '下载/喜欢/收藏')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { $Aj5L2 = '<span class="hover:tw-bg-gray-100 tw-px-1 tw-inline-block" data-tip-popover="真实">%d</span>+<span class="hover:tw-bg-gray-100 tw-px-1 tw-inline-block" data-tip-popover="虚拟">%d</span>'; $AZvp2 = array(); $AZvp2[] = sprintf($Aj5L2, intval($jIWZA->downloadCount), intval($jIWZA->downloadCountBase)); $AZvp2[] = sprintf($Aj5L2, intval($jIWZA->likeCount), intval($jIWZA->likeCountBase)); $AZvp2[] = sprintf($Aj5L2, intval($jIWZA->favoriteCount), intval($jIWZA->favoriteCountBase)); return AutoRenderedFieldValue::make(join(' / ', $AZvp2)); })->listable(true)->showable(true)->tip('前端显示数据为虚拟数据+真实数据'); $lZifj->number('downloadCountBase', '下载虚拟数量')->editable(true)->showable(false)->listable(false); $lZifj->number('favoriteCountBase', '收藏虚拟数量')->editable(true)->showable(false)->listable(false); $lZifj->number('likeCountBase', '喜欢虚拟数量')->editable(true)->showable(false)->listable(false); $lZifj->display('created_at', L('Created At')); $lZifj->display('updated_at', L('Updated At')); })->repositoryFilter(function (RepositoryFilter $bu01d) { $bu01d->where('isDeleted', false); })->gridFilter(function (GridFilter $bu01d) { $bu01d->eq('id', L('ID')); $bu01d->like('title', L('Title')); $bu01d->eq('verifyStatus', '状态')->select(ResAssetVerifyStatus::class); $bu01d->eq('convertStatus', '转换状态')->select(ResAssetConvertStatus::class); $bu01d->has('categoryId', '分类')->cascaderModel('res_category'); })->canBatchSelect(true)->canBatchDelete(true)->batchOperatePrepend(join('', array('<button class="btn" data-batch-dialog-operate="' . modstart_admin_url('res_asset/batch_edit') . '"><i class="iconfont icon-edit"></i> 批量编辑</button>', '<button class="btn" data-batch-operate="' . modstart_admin_url('res_asset/verify_pass') . '"><i class="iconfont icon-check"></i> 审核通过</button>', '<button class="btn" data-batch-operate="' . modstart_admin_url('res_asset/verify_reject') . '"><i class="iconfont icon-close"></i> 审核拒绝</button>', '<button class="btn" data-batch-operate="' . modstart_admin_url('res_asset/convert_retry') . '"><i class="iconfont icon-refresh"></i> 转换重试</button>')))->hookItemOperateRendering(function (ItemOperate $zCZzC) { $zCZzC->getField()->width(300)->gridFixed('right'); $jIWZA = $zCZzC->item(); $zCZzC->prepend(TextDialogRequest::primary('替换文件', action('\\' . __CLASS__ . '@replaceFile', array('_id' => $zCZzC->item()->id)))); switch ($jIWZA->convertStatus) { case ResAssetConvertStatus::WAIT_PROCESS: case ResAssetConvertStatus::PROCESSING: case ResAssetConvertStatus::PROCESS_FAIL: $zCZzC->prepend(TextAjaxRequest::warning('转换重试', action('\\' . __CLASS__ . '@convertRetry', array('_id' => $zCZzC->item()->id)))); break; case ResAssetConvertStatus::PROCESS_SUCCESS: $zCZzC->prepend(TextAjaxRequest::warning('重新转换', action('\\' . __CLASS__ . '@convertRetry', array('_id' => $zCZzC->item()->id)))); break; } switch ($jIWZA->verifyStatus) { case ResAssetVerifyStatus::VERIFYING: goto CDo1d; aBrcW: $zCZzC->prepend(TextAjaxRequest::danger('审核拒绝', action('\\' . __CLASS__ . '@verifyReject', array('_id' => $zCZzC->item()->id)))); goto fTskI; CDo1d: $zCZzC->prepend(TextAjaxRequest::success('审核通过', action('\\' . __CLASS__ . '@verifyPass', array('_id' => $zCZzC->item()->id)))); goto aBrcW; fTskI: break; goto WqMQM; WqMQM: } })->hookDeleted(function (Form $yZTO2) { $yZTO2->item()->each(function ($jIWZA) { if (modstart_module_enabled('TagManager')) { ResTagManagerBiz::deleteTags($jIWZA->tags); } }); })->canAdd(false)->pageJumpEnable(true)->title('资源管理'); } public function batchEdit(AdminDialogPage $JcqUq) { goto JWzAA; wUUHr: $yZTO2->switch('changeRecommendEnable', '修改推荐')->optionsYesNo()->when(true, function (Form $yZTO2) { $yZTO2->switch('isRecommend', '推荐')->optionsYesNo(); }); goto IRsQx; MK8cu: $yZTO2->showReset(false)->showSubmit(false)->formClass('wide'); goto EoNB2; JWzAA: $yZTO2 = Form::make(''); goto MK8cu; EoNB2: $yZTO2->switch('changeCategoryEnable', '修改分类')->optionsYesNo()->when(true, function (Form $yZTO2) { $yZTO2->select('categoryId', '分类')->optionModelTree('res_category'); }); goto nUIoU; CKMvm: return $JcqUq->body($yZTO2)->pageTitle('批量编辑')->handleForm($yZTO2, function (Form $yZTO2) { $U8wjN = $yZTO2->dataForming(); $CQYv7 = CRUDUtil::ids(); BizException::throwsIfEmpty('ID为空', $CQYv7); AdminPermission::demoCheck(); $chyCL = array(); if ($U8wjN['changeCategoryEnable']) { $chyCL['categoryId'] = $U8wjN['categoryId']; } if ($U8wjN['changeTagEnable']) { $chyCL['tags'] = $U8wjN['tags']; } if ($U8wjN['changeRecommendEnable']) { $chyCL['isRecommend'] = $U8wjN['isRecommend']; } if ($U8wjN['viewCountEnable']) { $chyCL['viewCount'] = $U8wjN['viewCount']; } if (!empty($chyCL)) { ModelUtil::model('res_asset')->whereIn('id', $CQYv7)->update($chyCL); } return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto rhfTW; nUIoU: $yZTO2->switch('changeTagEnable', '修改标签')->optionsYesNo()->when(true, function (Form $yZTO2) { $yZTO2->tags('tags', '标签')->serializeAsColonSeparated(); }); goto wUUHr; IRsQx: $yZTO2->switch('viewCountEnable', '修改浏览量')->optionsYesNo()->when(true, function (Form $yZTO2) { $yZTO2->number('viewCount', '浏览量'); }); goto CKMvm; rhfTW: } public function delete() { goto Mzn7b; VGfrS: return Response::redirect(CRUDUtil::jsGridRefresh()); goto qSqYB; Mzn7b: AdminPermission::demoCheck(); goto SMUFt; SMUFt: foreach (CRUDUtil::ids() as $ULYbu) { ModelUtil::update('res_asset', $ULYbu, array('isDeleted' => true)); } goto VGfrS; qSqYB: } public function convertRetry() { goto wGk86; wGk86: AdminPermission::demoCheck(); goto noUIm; oIsk3: return Response::json(0, '转换重试请求完成', null, CRUDUtil::jsGridRefresh()); goto JugFV; noUIm: foreach (CRUDUtil::ids() as $ULYbu) { ResAssetUtil::doConvertRetry($ULYbu); } goto oIsk3; JugFV: } public function replaceFile(AdminDialogPage $JcqUq) { goto uDw8F; p_rGf: BizException::throwsIfEmpty('资源不存在', $lpVAI); goto gdoLL; uDw8F: $lpVAI = ResAssetUtil::get(CRUDUtil::id()); goto p_rGf; ZiP70: return $JcqUq->pageTitle('替换文件')->body($yZTO2)->handleForm($yZTO2, function (Form $yZTO2) use($lpVAI) { AdminPermission::demoCheck(); $U8wjN = $yZTO2->dataForming(); $chyCL = array('fileType' => $U8wjN['fileType'], 'fileUrl' => null, 'fileContent' => null, 'fileSize' => 0, 'fileMd5' => null, 'fileExt' => null); BizException::throwsIfEmpty('请选择资源类型', $chyCL['fileType']); switch ($chyCL['fileType']) { case ResAssetFileType::FILE: goto JTYxs; STPPm: $chyCL['fileMd5'] = $Tbn6c['data']['data']['md5']; goto Y6d4i; JTYxs: $Tbn6c = DataManager::storeTempDataByPath($U8wjN['file']); goto N_9Ak; SAAGQ: break; goto c4ut0; Y6d4i: $chyCL['fileExt'] = FileUtil::extension($chyCL['fileUrl']); goto SAAGQ; VFBwf: $chyCL['fileSize'] = $Tbn6c['data']['data']['size']; goto STPPm; kYx8V: $chyCL['fileUrl'] = $Tbn6c['data']['fullPath']; goto VFBwf; N_9Ak: if (Response::isError($Tbn6c)) { return Response::generateError($Tbn6c['msg']); } goto kYx8V; c4ut0: case ResAssetFileType::TEXT: goto ga_W2; ga_W2: $chyCL['fileContent'] = $U8wjN['fileContent']; goto Kwtq6; Kwtq6: BizException::throwsIfEmpty('请输入资源内容', $chyCL['fileContent']); goto Vgwgr; Vgwgr: break; goto kzybl; kzybl: } $chyCL['convertStatus'] = ResAssetConvertStatus::WAIT_PROCESS; ResAssetUtil::update($lpVAI['id'], $chyCL); ResAssetProcessJob::create($lpVAI['id'], Request::domainUrl()); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto iFxLM; AYFMu: $yZTO2->showSubmit(false)->showReset(false); goto ZiP70; rJkS2: $yZTO2->radio('fileType', '资源类型')->optionType(ResAssetFileType::class)->when('=', ResAssetFileType::FILE, function ($lZifj) { $lZifj->fileTemp('file', '重新上传文件')->autoSave(false); })->when('=', ResAssetFileType::TEXT, function ($lZifj) { $lZifj->textarea('fileContent', '资源内容'); }); goto AYFMu; b1PTh: $yZTO2->display('_from', '资源名称')->value($lpVAI['title'])->addable(true); goto rJkS2; gdoLL: $yZTO2 = Form::make(''); goto b1PTh; iFxLM: } public function verifyPass() { goto q1Goy; q1Goy: AdminPermission::demoCheck(); goto QymvW; nhr5j: ResAssetUtil::clearCache(); goto fnIUa; fnIUa: return Response::json(0, null, null, CRUDUtil::jsGridRefresh()); goto P1MaS; QymvW: foreach (CRUDUtil::ids() as $ULYbu) { ResAssetUtil::docVerifyPass($ULYbu); } goto nhr5j; P1MaS: } public function verifyReject() { goto czk9J; czk9J: AdminPermission::demoCheck(); goto s1yov; re6dR: return Response::json(0, null, null, CRUDUtil::jsGridRefresh()); goto V4D18; s1yov: foreach (CRUDUtil::ids() as $ULYbu) { ResAssetUtil::doVerifyReject($ULYbu); } goto PVSYC; PVSYC: ResAssetUtil::clearCache(); goto re6dR; V4D18: } public function verifyList(AdminPage $JcqUq) { goto oSelu; UTs9N: $gwmIt->disableCUD(); goto pUYa2; ryESq: return $JcqUq->pageTitle('资源审核')->body($gwmIt); goto KeG8w; oSelu: $gwmIt = $this->grid(); goto UTs9N; GtVfO: CRUDUtil::registerGridResource($gwmIt, '\\' . __CLASS__); goto Dmrae; Dmrae: if (Request::isPost()) { return $gwmIt->request(); } goto ryESq; pUYa2: $gwmIt->repositoryFilter(function (RepositoryFilter $bu01d) { $bu01d->where('verifyStatus', ResAssetVerifyStatus::VERIFYING); }); goto GtVfO; KeG8w: } public function select(AdminDialogPage $JcqUq) { goto P_yFb; T1rfu: CRUDUtil::registerGridResource($gwmIt, '\\' . __CLASS__); goto xlBXn; lVAXF: $gwmIt->disableItemOperate(); goto T1rfu; zeU4b: return $JcqUq->pageTitle('选择资源')->body($gwmIt); goto aYIbZ; x2KTQ: $gwmIt->canMultiSelectItem(true); goto lVAXF; c9wor: $gwmIt->disableCUD(); goto x2KTQ; xlBXn: if (Request::isPost()) { return $gwmIt->request(); } goto zeU4b; P_yFb: $gwmIt = $this->grid(); goto c9wor; aYIbZ: } }