<?php
 namespace Payment\Common\Cmb; use GuzzleHttp\Client; use Payment\Common\BaseData; use Payment\Common\BaseStrategy; use Payment\Common\CmbConfig; use Payment\Common\PayException; use Payment\Config; abstract class CcbBaseStrategy implements BaseStrategy { protected $config; protected $reqData; public function __construct(array $config) { try { $this->config = new CcbConfig($config); } catch (PayException $e) { throw $e; } } public function handle(array $data) { $buildClass = $this->getBuildDataClass(); try { $this->reqData = new $buildClass($this->config, $data); } catch (PayException $e) { throw $e; } $this->reqData->setSign(); $data = $this->reqData->getData(); return $this->retData($data); } protected function retData(array $ret) { $json = json_encode($ret, JSON_UNESCAPED_UNICODE); $reqData = [ 'url' => $this->config->getewayUrl, 'name' => CcbConfig::REQ_FILED_NAME, 'value' => $json, ]; return $reqData; } protected function sendReq($json) { $client = new Client([ 'timeout' => '10.0' ]); $options = [ 'body' => $json, 'http_errors' => false ]; $response = $client->request('POST', $this->config->getewayUrl, $options); if ($response->getStatusCode() != '200') { throw new PayException('网络发生错误，请稍后再试curl返回码：' . $response->getReasonPhrase()); } $body = $response->getBody()->getContents(); $data = json_decode($body, true); $flag = $this->verifySign($data); if (!$flag) { throw new PayException('微信返回数据被篡改。请检查网络是否安全！'); } $rspData = $data['rspData']; if ($rspData['rspCode'] !== CmbConfig::SUCC_TAG) { throw new PayException('招商返回错误提示：' . $rspData['rspMsg']); } return $rspData; } protected function getTradeStatus($status) { switch ($status) { case '0': return Config::TRADE_STATUS_SUCC; case '1': case '2': case '4': case '7': case '8': default: return Config::TRADE_STATUS_FAILD; } } protected function verifySign(array $retData) { return true; } } 