<?php
namespace Payment\Common; use Payment\Utils\ArrayUtil; use Payment\Utils\StrUtil; final class AliConfig extends ConfigInterface { public $getewayUrl; public $appId; public $method; public $format = 'JSON'; public $returnUrl; public $charset = 'UTF-8'; public $timestamp; public $version = '1.0'; public $rsaPrivateKey; public $rsaAliPubKey; protected function initConfig(array $config) { $config = ArrayUtil::paraFilter($config); $this->getewayUrl = 'https://openapi.alipay.com/gateway.do'; if (isset($config['use_sandbox']) && $config['use_sandbox'] === true) { $this->getewayUrl = 'https://openapi.alipaydev.com/gateway.do'; } else { $this->useSandbox = false; } if (key_exists('app_id', $config) && is_numeric($config['app_id'])) { $this->appId = $config['app_id']; } else { throw new PayException('支付宝应用ID错误，请检查'); } if (key_exists('notify_url', $config)) { $this->notifyUrl = $config['notify_url']; } if (key_exists('return_url', $config)) { $this->returnUrl = $config['return_url']; } if (key_exists('sign_type', $config) && in_array($config['sign_type'], ['RSA', 'RSA2'])) { $this->signType = $config['sign_type']; } else { throw new PayException('目前支付宝仅支持RSA2和RSA，推荐使用RSA2'); } if (key_exists('ali_public_key', $config) && ! empty($config['ali_public_key'])) { $this->rsaAliPubKey = StrUtil::getRsaKeyValue($config['ali_public_key'], 'public'); } else { throw new PayException('请提供支付宝对应的rsa公钥'); } if (empty($this->rsaAliPubKey)) { throw new PayException('支付宝公钥生成错误，如果你使用的是文件方式配置，建议修改为字符串设置'); } if (key_exists('rsa_private_key', $config) && ! empty($config['rsa_private_key'])) { $this->rsaPrivateKey = StrUtil::getRsaKeyValue($config['rsa_private_key'], 'private'); } else { throw new PayException('请提供商户的rsa私钥文件'); } if (empty($this->rsaPrivateKey)) { throw new PayException('支付宝rsa私钥生成错误，如果你使用的是文件方式配置，建议修改为字符串设置'); } $this->timestamp = date('Y-m-d H:i:s', time()); if (key_exists('limit_pay', $config) && is_array($config['limit_pay'])) { $this->limitPay = implode(',', $config['limit_pay']); } if (key_exists('return_raw', $config)) { $this->returnRaw = filter_var($config['return_raw'], FILTER_VALIDATE_BOOLEAN); } } } 