<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\PayCenter\Admin\Controller; use Illuminate\Routing\Controller; use Illuminate\Support\Facades\Log; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Response; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextAjaxRequest; use Module\PayCenter\Biz\PayCenterBiz; use Module\PayCenter\Events\OrderPayedEvent; use Module\PayCenter\Type\PayOrderStatus; use Module\PayCenter\Type\PayType; class PayOrderController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $lZifj) { $lZifj->init('pay_order')->field(function ($lZifj) { $lZifj->id('id', '结算ID'); $lZifj->select('biz', '业务')->options(PayCenterBiz::allMap()); $lZifj->text('bizId', '业务订单ID'); $lZifj->type('status', '状态')->type(PayOrderStatus::class); $lZifj->type('payType', '支付类型')->type(PayType::class); $lZifj->currency('feeTotal', '金额'); $lZifj->text('body', '内容'); $lZifj->display('created_at', L('Created At')); $lZifj->display('updated_at', L('Updated At'))->listable(false); })->gridFilter(function (GridFilter $bu01d) { $bu01d->eq('id', '结算ID'); $bu01d->eq('biz', '业务')->select(PayCenterBiz::allMap()); $bu01d->eq('status', '状态')->select(PayOrderStatus::class); $bu01d->eq('payType', '支付类型')->select(PayType::class); })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $zCZzC) { $jIWZA = $zCZzC->item(); switch ($jIWZA->status) { case PayOrderStatus::PAYED: goto x9IbT; x9IbT: $zCZzC->push(TextAjaxRequest::danger('退款', action('\\' . __CLASS__ . '@refund', array('_id' => $jIWZA->id)), '确定标记退款？<br />标记退款后，需要手动在支付宝/微信等三方支付平台人工处理退款')); goto iKlrG; iKlrG: if (!$jIWZA->eventNotified) { $zCZzC->push(TextAjaxRequest::danger('重新触发事件', action('\\' . __CLASS__ . '@fireEvent', array('_id' => $jIWZA->id)), '确定重新触发支付？')); } goto B2Kj0; B2Kj0: break; goto vgnrt; vgnrt: } })->disableCUD()->title('全部订单'); } public function refund() { goto tD0in; F58bf: $ULYbu = CRUDUtil::id(); goto WHZn0; txJDI: ModelUtil::update('pay_order', $HsIf6['id'], array('status' => PayOrderStatus::REFUND_SUCCESS)); goto xX_9F; tqGwP: BizException::throwsIfEmpty('订单不存在', $HsIf6); goto PAGow; PAGow: BizException::throwsIf('订单状态错误', $HsIf6['status'] != PayOrderStatus::PAYED); goto txJDI; xX_9F: return Response::redirect(CRUDUtil::jsGridRefresh()); goto R3E1g; WHZn0: $HsIf6 = ModelUtil::get('pay_order', $ULYbu); goto tqGwP; tD0in: AdminPermission::demoCheck(); goto F58bf; R3E1g: } public function fireEvent() { goto IBwtG; l4olP: $u17bI->biz = $HsIf6['biz']; goto YBQHC; uuQ_1: Log::info('PayCenter.FireEventFromAdmin.OrderPayedEvent - ' . json_encode($u17bI, JSON_UNESCAPED_UNICODE)); goto OtS1m; OgaVL: BizException::throwsIf('订单状态错误', $HsIf6['status'] != PayOrderStatus::PAYED); goto SksTn; SksTn: $u17bI = new OrderPayedEvent(); goto l4olP; BZtLk: $u17bI->order = $HsIf6; goto DWE6u; OtS1m: ModelUtil::update('pay_order', $HsIf6['id'], array('eventNotified' => true)); goto oSiOi; NijQW: $ULYbu = CRUDUtil::id(); goto fXK8Q; IBwtG: AdminPermission::demoCheck(); goto NijQW; fXK8Q: $HsIf6 = ModelUtil::get('pay_order', $ULYbu); goto H7Dtw; DWE6u: EventUtil::fire($u17bI); goto uuQ_1; YBQHC: $u17bI->bizId = $HsIf6['bizId']; goto BZtLk; H7Dtw: BizException::throwsIfEmpty('订单不存在', $HsIf6); goto OgaVL; oSiOi: return Response::redirect(CRUDUtil::jsGridRefresh()); goto z1Z2M; z1Z2M: } }