<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($ULYbu) { return ModelUtil::get('member_user', array('id' => $ULYbu)); } public static function getCached($ULYbu) { return Cache::remember('MemberUser:' . $ULYbu, 60, function () use($ULYbu) { return self::get($ULYbu); }); } public static function processDefault(&$g3uu_) { goto Ag8hR; uoRhq: if (empty($g3uu_['avatarBig'])) { $g3uu_['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto VwCJT; RVd4U: if (empty($g3uu_['avatarMedium'])) { $g3uu_['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto uoRhq; if72H: if (empty($g3uu_['avatar'])) { $g3uu_['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto RVd4U; Ag8hR: if (empty($g3uu_)) { return; } goto NZk4K; NZk4K: if (empty($g3uu_['nickname'])) { $g3uu_['nickname'] = $g3uu_['username']; } goto if72H; VwCJT: } private static function processBasicFields($YSy0e) { goto t85AX; tPfNL: return $YSy0e; goto jQGk2; t85AX: $XrF4c = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto s3RM3; s3RM3: if (null === $YSy0e) { $YSy0e = $XrF4c; } else { goto iokEM; RvIIy: foreach ($YSy0e as $kEhTf) { if ('<basic>' == $kEhTf) { $dzN_m = array_merge($dzN_m, $XrF4c); } else { $dzN_m[] = $kEhTf; } } goto vYZd3; iokEM: $dzN_m = array(); goto RvIIy; vYZd3: $YSy0e = $dzN_m; goto WVkLf; WVkLf: } goto tPfNL; jQGk2: } public static function fixAvatar($UCNYd) { return AssetsUtil::fixFullOrDefault($UCNYd, 'asset/image/avatar.svg'); } public static function getBasic($ULYbu, $YSy0e = null) { goto o0H7q; o0H7q: $YSy0e = self::processBasicFields($YSy0e); goto QgYBF; hH8zB: $jIWZA['avatar'] = self::fixAvatar($jIWZA['avatar']); goto jHjKD; QgYBF: $jIWZA = self::get($ULYbu); goto AdelN; rJQEV: return $nV1c1; goto pUbiH; vDMgp: foreach ($YSy0e as $l1fQo) { if (isset($jIWZA[$l1fQo])) { $nV1c1[$l1fQo] = $jIWZA[$l1fQo]; } else { $nV1c1[$l1fQo] = null; } } goto rJQEV; jHjKD: $nV1c1 = array(); goto vDMgp; AdelN: if (empty($jIWZA)) { return null; } goto aWlcN; aWlcN: if (empty($jIWZA['nickname'])) { $jIWZA['nickname'] = $jIWZA['username']; } goto hH8zB; pUbiH: } public static function listViewName($CQYv7) { goto YbXqv; YbXqv: $fHGBD = array(); goto KSrGg; TxMeE: foreach ($qwTRL as $g3uu_) { $fHGBD[] = self::viewName($g3uu_); } goto GOrfz; KSrGg: $qwTRL = ModelUtil::allIn('member_user', 'id', $CQYv7); goto TxMeE; GOrfz: return $fHGBD; goto Xh_K6; Xh_K6: } public static function listUsers($CQYv7) { return ModelUtil::allIn('member_user', 'id', $CQYv7); } public static function convertOneToBasic($g3uu_) { return array('id' => $g3uu_['id'], 'username' => $g3uu_['username'], 'nickname' => empty($g3uu_['nickname']) ? $g3uu_['username'] : $g3uu_['nickname'], 'created_at' => $g3uu_['created_at'], 'signature' => isset($g3uu_['signature']) ? $g3uu_['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($g3uu_['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($qwTRL) { return array_map(function ($jIWZA) { return array('id' => $jIWZA['id'], 'username' => $jIWZA['username'], 'nickname' => empty($jIWZA['nickname']) ? $jIWZA['username'] : $jIWZA['nickname'], 'created_at' => $jIWZA['created_at'], 'signature' => isset($jIWZA['signature']) ? $jIWZA['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($jIWZA['avatar'], 'asset/image/avatar.svg')); }, $qwTRL); } public static function listUsersBasic($CQYv7) { return self::convertToBasic(self::listUsers($CQYv7)); } public static function getViewName($ULYbu) { return self::viewName(self::get($ULYbu)); } public static function viewName($g3uu_) { goto rtC0k; nod7r: if (!empty($g3uu_['username'])) { return $g3uu_['username']; } goto LogV5; rtC0k: if ($g3uu_ && is_numeric($g3uu_)) { return self::getViewName($g3uu_); } goto QOp_K; QOp_K: if (empty($g3uu_)) { return '-'; } goto QjndF; QjndF: if (!empty($g3uu_['nickname'])) { return $g3uu_['nickname']; } goto nod7r; LogV5: return "ID-{$g3uu_['id']}"; goto ohu8m; ohu8m: } public static function update($ULYbu, $U8wjN) { return ModelUtil::update('member_user', array('id' => $ULYbu), $U8wjN); } public static function updateBasicWithUniqueCheck($ULYbu, $U8wjN) { goto QOAw0; gubKj: return Response::generate(0, 'ok'); goto cCqka; BboJr: self::update($ULYbu, $U8wjN); goto gubKj; J9IUY: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $pZ_lR => $KML2b) { if (isset($U8wjN[$pZ_lR])) { goto w8aaK; WD2Li: if (count($pRqvo) == 1) { if ($pRqvo[0]['id'] != $ULYbu) { return Response::generate(-1, $KML2b . '重复'); } } goto wz15D; tD_3U: $pRqvo = ModelUtil::all('member_user', array($pZ_lR => $U8wjN[$pZ_lR])); goto Gl6Fs; w8aaK: if (empty($U8wjN[$pZ_lR])) { $U8wjN[$pZ_lR] = null; continue; } goto tD_3U; Gl6Fs: if (count($pRqvo) > 1) { return Response::generate(-1, $KML2b . '重复'); } goto WD2Li; wz15D: } } goto BboJr; QOAw0: if (empty($U8wjN)) { return Response::generate(0, 'ok'); } goto J9IUY; cCqka: } public static function login($ypwo8 = '', $VaTf5 = '', $dRXuh = '', $azAb3 = '') { goto YrTzL; dHQXM: MemberUserLoginAttemptEvent::fire($g3uu_['id'], Request::ip(), AgentUtil::getUserAgent()); goto Bd0fc; ze9rd: $ypwo8 = trim($ypwo8); goto ipCy0; ipCy0: if (!($dRXuh || $VaTf5 || $ypwo8)) { return Response::generate(-1, '所有登录字段均为空'); } goto Nwa7Z; y9TgM: if ($dRXuh) { if (!FormatUtil::isEmail($dRXuh)) { return Response::generate(-3, '邮箱格式不正确'); } $xAO9M = array('email' => $dRXuh); } else { if ($VaTf5) { if (!preg_match('/(^1[0-9]{10}$)/', $VaTf5)) { return Response::generate(-4, '手机格式不正确'); } $xAO9M = array('phone' => $VaTf5); } else { if ($ypwo8) { if (strpos($ypwo8, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $xAO9M = array('username' => $ypwo8); } } } goto wgOxw; gQkbx: $VaTf5 = trim($VaTf5); goto ze9rd; hIgIT: return Response::generateSuccessData($g3uu_); goto TZmRH; Nwa7Z: if (!$azAb3) { return Response::generate(-2, '密码为空'); } goto y9TgM; Bd0fc: if ($g3uu_['password'] != EncodeUtil::md5WithSalt($azAb3, $g3uu_['passwordSalt'])) { MemberUserLoginFailedEvent::fire($g3uu_['id'], $g3uu_['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto vOhiy; wgOxw: $g3uu_ = ModelUtil::get('member_user', $xAO9M); goto U835n; vOhiy: switch ($g3uu_['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto hIgIT; U835n: if (empty($g3uu_)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto dHQXM; YrTzL: $dRXuh = trim($dRXuh); goto gQkbx; TZmRH: } public static function autoSetUsernameNickname($KJqKC, $vJn1r) { goto BTIHl; ZTinz: self::suggestUsernameNickname($KJqKC, $vJn1r, $Rryfn); goto e0ug0; uyCat: if (preg_match('/\\{.*\\}/', $vJn1r)) { goto pgGsV; pgGsV: $g3uu_ = self::get($KJqKC); goto gh6c2; gh6c2: $PcqTW = array('{Phone}' => $g3uu_['phone'], '{Phone4}' => substr($g3uu_['phone'], 7), '{Uid}' => $g3uu_['id']); goto w7J1X; MbNgN: $Rryfn = 0; goto QAh7l; w7J1X: $vJn1r = str_replace(array_keys($PcqTW), array_values($PcqTW), $vJn1r); goto MbNgN; QAh7l: } goto ZTinz; BTIHl: $Rryfn = 6; goto uyCat; e0ug0: } public static function getSuggestUsernameNickname($d42Om) { goto jGnJ4; jGnJ4: $vJn1r = $d42Om . Str::random(1); goto OpBm3; T6S56: return $vJn1r . Str::random(10); goto UiiDH; OpBm3: for ($NAFuY = 0; $NAFuY < 20; $NAFuY++) { $nMLLk = ModelUtil::model('member_user')->where(array('username' => $vJn1r))->orWhere(array('nickname' => $vJn1r))->first(); if (empty($nMLLk)) { return $vJn1r; } $vJn1r = $vJn1r . Str::random(1); } goto T6S56; UiiDH: } private static function suggestUsernameNickname($KJqKC, $nX0hz = '用户', $Rryfn = 6) { goto amQFZ; JEi_T: ModelUtil::update('member_user', $KJqKC, array('username' => $vJn1r, 'nickname' => $vJn1r)); goto ALsEB; amQFZ: if ($Rryfn > 0) { $vJn1r = $nX0hz . RandomUtil::string($Rryfn); } else { $vJn1r = $nX0hz; } goto rGysQ; rGysQ: for ($NAFuY = 0; $NAFuY < 20; $NAFuY++) { $nMLLk = ModelUtil::model('member_user')->where(array('username' => $vJn1r))->orWhere(array('nickname' => $vJn1r))->first(); if (empty($nMLLk)) { break; } $vJn1r = $vJn1r . Str::random(1); } goto JEi_T; ALsEB: } public static function registerId($ULYbu, $U8wjN = array()) { $g3uu_ = ModelUtil::insert('member_user', array_merge(array('id' => $ULYbu, 'status' => MemberStatus::NORMAL, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false), $U8wjN)); return Response::generate(0, 'ok', $g3uu_); } public static function registerUsername($ypwo8) { return self::register($ypwo8, '', '', '', true); } public static function registerUsernameQuick($ypwo8) { goto JHow1; JHow1: $lyRty = $ypwo8; goto fV8LP; fV8LP: for ($NAFuY = 0; $NAFuY < 10; $NAFuY++) { $Tbn6c = self::register($lyRty, '', '', '', true); if ($Tbn6c['code']) { $lyRty = $lyRty . Str::random(1); } else { return $Tbn6c; } } goto d5but; d5but: return Response::generateError('注册失败'); goto jcnjs; jcnjs: } public static function register($ypwo8 = '', $VaTf5 = '', $dRXuh = '', $azAb3 = '', $LgdYB = false) { goto aOdoS; GUolM: $c5MY8 = Str::random(16); goto V116m; vAZij: $ypwo8 = trim($ypwo8); goto ykqvJ; aOdoS: $dRXuh = trim($dRXuh); goto x1rKA; dN7AE: return Response::generate(0, 'ok', $g3uu_); goto tmXf8; x1rKA: $VaTf5 = trim($VaTf5); goto vAZij; YO_7x: if ($ypwo8) { goto lKRTl; pTSP4: if (Str::contains($ypwo8, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto sSdmi; REhkS: if (strlen($ypwo8) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto pTSP4; lKRTl: $Tbn6c = self::uniqueCheck('username', $ypwo8); goto xTSVa; xTSVa: if ($Tbn6c['code']) { return $Tbn6c; } goto REhkS; sSdmi: if (preg_match('/^[0-9]{11}$/', $ypwo8)) { return Response::generate(-1, '用户名不能为纯数字'); } goto nM2nb; nM2nb: } else { $ypwo8 = null; } goto nMHVi; V116m: $g3uu_ = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $ypwo8, 'email' => $dRXuh, 'phone' => $VaTf5, 'password' => $LgdYB ? null : EncodeUtil::md5WithSalt($azAb3, $c5MY8), 'passwordSalt' => $LgdYB ? null : $c5MY8, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto dN7AE; zqYxH: if ($VaTf5) { $Tbn6c = self::uniqueCheck('phone', $VaTf5); if ($Tbn6c['code']) { return $Tbn6c; } } else { $VaTf5 = null; } goto YO_7x; M8MIB: if ($dRXuh) { $Tbn6c = self::uniqueCheck('email', $dRXuh); if ($Tbn6c['code']) { return $Tbn6c; } } else { $dRXuh = null; } goto zqYxH; ykqvJ: if (!($dRXuh || $VaTf5 || $ypwo8)) { return Response::generate(-1, '所有注册字段均为空'); } goto M8MIB; nMHVi: if (!$LgdYB) { if (empty($azAb3) || strlen($azAb3) < 6) { return Response::generate(-3, '密码不合法'); } } goto GUolM; tmXf8: } public static function uniqueCheck($EpKdG, $fo71I, $ONivA = 0) { goto TRuFL; wpOoM: if (empty($g3uu_)) { return Response::generate(0, 'ok'); } goto nkM0g; TRuFL: $fo71I = trim($fo71I); goto apESC; nkM0g: $OV0sC = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto z6xtm; z6xtm: if ($ONivA == $g3uu_['id']) { return Response::generate(0, 'ok'); } goto P6LyQ; apESC: switch ($EpKdG) { case 'email': if (!FormatUtil::isEmail($fo71I)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $fo71I)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($fo71I, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $EpKdG); } goto b2tTn; P6LyQ: return Response::generate(-2, $OV0sC[$EpKdG] . '已经被占用'); goto fX28g; b2tTn: $g3uu_ = ModelUtil::get('member_user', array($EpKdG => $fo71I)); goto wpOoM; fX28g: } public static function getByUsername($ypwo8) { return ModelUtil::get('member_user', array('username' => $ypwo8)); } public static function getByEmail($dRXuh) { return ModelUtil::get('member_user', array('email' => $dRXuh)); } public static function getByPhone($VaTf5) { return ModelUtil::get('member_user', array('phone' => $VaTf5)); } public static function changeNickname($KJqKC, $etgIw) { goto o0q4q; fkB9E: return Response::generate(0, 'ok'); goto PJf3P; o0q4q: $Tbn6c = self::uniqueCheck('nickname', $etgIw, $KJqKC); goto UNX7N; zg7yP: ModelUtil::update('member_user', $KJqKC, array('nickname' => $etgIw)); goto fkB9E; UNX7N: if (Response::isError($Tbn6c)) { return $Tbn6c; } goto zg7yP; PJf3P: } public static function changePassword($KJqKC, $GnHgq, $HHy_D = null, $plHDd = false) { goto ReVVK; Kr2eQ: $g3uu_ = ModelUtil::get('member_user', array('id' => $KJqKC)); goto pwT0t; i2k09: $c5MY8 = Str::random(16); goto AQQ_U; ReVVK: if (!$plHDd && empty($HHy_D)) { return Response::generate(-1, '旧密码不能为空'); } goto Kr2eQ; p6vOh: if (empty($GnHgq)) { return Response::generate(-1, '新密码为空'); } goto dQOTh; K8Vyv: return Response::generate(0, 'ok'); goto dWEPC; dQOTh: if (!$plHDd && EncodeUtil::md5WithSalt($HHy_D, $g3uu_['passwordSalt']) != $g3uu_['password']) { return Response::generate(-1, '旧密码不正确'); } goto i2k09; pwT0t: if (empty($g3uu_)) { return Response::generate(-1, '用户不存在'); } goto p6vOh; AQQ_U: ModelUtil::update('member_user', array('id' => $g3uu_['id']), array('passwordSalt' => $c5MY8, 'password' => EncodeUtil::md5WithSalt($GnHgq, $c5MY8))); goto K8Vyv; dWEPC: } public static function setAvatar($N2Bvr, $JDN8L, $KUm6i = 'jpg') { goto L9E1S; o7qqf: if (empty($g3uu_)) { return Response::generate(-1, '用户不存在'); } goto pwk2L; nbfNU: $rZpdb = DataManager::upload('image', 'U' . $N2Bvr . '_AvatarMiddle.' . $KUm6i, $PK7rX, null, $cOmA6); goto OJ9Ii; Ps0np: return Response::generateSuccess(); goto rWwjE; nvPCk: $j2Tp6 = (string) Image::make($JDN8L)->resize(50, 50)->encode($KUm6i, 75); goto QCC22; tzdCX: $IIuy3 = (string) Image::make($JDN8L)->resize(400, 400)->encode($KUm6i, 75); goto UgUeH; gwkFO: $Tbn6c = DataManager::upload('image', 'U_' . $N2Bvr . '_Avatar.' . $KUm6i, $j2Tp6, null, $cOmA6); goto JSoX6; JSoX6: if ($Tbn6c['code']) { goto YtyLH; FshjQ: DataManager::deleteById($rZpdb['data']['id']); goto Hpecy; YtyLH: DataManager::deleteById($oRVet['data']['id']); goto FshjQ; Hpecy: if ($oRVet['code']) { return Response::generate(-1, '头像存储失败（' . $Tbn6c['msg'] . '）'); } goto rg9je; rg9je: } goto cYi_U; E1fgq: $oRVet = DataManager::upload('image', 'U' . $N2Bvr . '_AvatarBig.' . $KUm6i, $IIuy3, null, $cOmA6); goto caE6s; L9E1S: if (!in_array($KUm6i, array('jpg', 'jpeg', 'png', 'gif'))) { return Response::generate(-1, '图片格式不正确'); } goto Glos7; pwk2L: if (empty($JDN8L)) { return Response::generate(-1, '图片数据为空'); } goto tzdCX; UgUeH: $PK7rX = (string) Image::make($JDN8L)->resize(200, 200)->encode($KUm6i, 75); goto nvPCk; QCC22: $cOmA6 = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto E1fgq; caE6s: if ($oRVet['code']) { return Response::generate(-1, '头像存储失败（' . $oRVet['msg'] . '）'); } goto nbfNU; Glos7: $g3uu_ = self::get($N2Bvr); goto o7qqf; cYi_U: self::update($g3uu_['id'], array('avatarBig' => $oRVet['data']['fullPath'], 'avatarMedium' => $rZpdb['data']['fullPath'], 'avatar' => $Tbn6c['data']['fullPath'])); goto Ps0np; OJ9Ii: if ($rZpdb['code']) { DataManager::deleteById($oRVet['data']['id']); if ($oRVet['code']) { return Response::generate(-1, '头像存储失败（' . $rZpdb['msg'] . '）'); } } goto gwkFO; rWwjE: } public static function findUsers($gCzHa) { goto VLxvc; Htg8A: return $VrDg_; goto yndP4; VLxvc: if (empty($gCzHa)) { return array(); } goto fyuyx; KWEAs: $qwTRL = ModelUtil::model('member_user')->whereIn('id', $gCzHa)->get(); goto NxusS; fyuyx: $VrDg_ = array(); goto KWEAs; NxusS: foreach ($qwTRL as &$YZcOo) { $VrDg_[$YZcOo->id] = $YZcOo->toArray(); } goto Htg8A; yndP4: } public static function filterUserIds($gCzHa) { goto fdAQ6; l5vmN: $PcqTW = array(); goto WH4Bt; fdAQ6: if (empty($gCzHa)) { return array(); } goto l5vmN; WH4Bt: $qwTRL = ModelUtil::model('member_user')->whereIn('id', $gCzHa)->get(array('id')); goto Jh41s; OplkF: return array_keys($PcqTW); goto ZXImG; Jh41s: foreach ($qwTRL as &$YZcOo) { $PcqTW[$YZcOo->id] = true; } goto OplkF; ZXImG: } public static function mergeMemberUsers(&$sX2oK, $qX_R2 = 'memberUserId', $HVxZR = '_memberUser') { ModelUtil::join($sX2oK, $qX_R2, $HVxZR, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$sX2oK, $qX_R2 = 'memberUserId', $HVxZR = '_memberUser', $YSy0e = null) { $YSy0e = self::processBasicFields($YSy0e); if (is_array($sX2oK)) { ModelUtil::join($sX2oK, $qX_R2, $HVxZR, 'member_user', 'id'); foreach ($sX2oK as $kEhTf => $y2Ltn) { goto gQXem; n6sR9: $g3uu_ = ArrayUtil::keepKeys($y2Ltn[$HVxZR], $YSy0e); goto vLoqH; at6zk: $sX2oK[$kEhTf][$HVxZR] = $g3uu_; goto uc0hI; leELM: if (empty($g3uu_['avatar'])) { $g3uu_['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $g3uu_['avatar'] = AssetsUtil::fixFull($g3uu_['avatar']); } goto at6zk; vLoqH: if (empty($g3uu_['nickname'])) { $g3uu_['nickname'] = $g3uu_['username']; } goto leELM; gQXem: if (empty($y2Ltn[$HVxZR])) { continue; } goto n6sR9; uc0hI: } } else { ModelUtil::joinItems($sX2oK, $qX_R2, $HVxZR, 'member_user', 'id'); foreach ($sX2oK as $jIWZA) { goto Pn4kd; xhHw2: $jIWZA->{$HVxZR} = $g3uu_; goto f3g4V; Pn4kd: if (empty($jIWZA->{$HVxZR})) { continue; } goto L8i2y; zKbMF: if (empty($g3uu_['nickname'])) { $g3uu_['nickname'] = $g3uu_['username']; } goto xrl6A; L8i2y: $g3uu_ = ArrayUtil::keepKeys($jIWZA->{$HVxZR}, $YSy0e); goto zKbMF; xrl6A: if (empty($g3uu_['avatar'])) { $g3uu_['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $g3uu_['avatar'] = AssetsUtil::fixFull($g3uu_['avatar']); } goto xhHw2; f3g4V: } } } public static function insert($U8wjN) { return ModelUtil::insert('member_user', $U8wjN); } public static function getIdByOauth($LqvE5, $r1oS5) { goto jkd4X; hdj22: return intval($Kwhgm['memberUserId']); goto yjFqN; uNG2V: if (empty($Kwhgm)) { return 0; } goto hdj22; jkd4X: $Kwhgm = ModelUtil::get('member_oauth', array('type' => $LqvE5, 'openId' => $r1oS5)); goto uNG2V; yjFqN: } public static function getIdByOauthAndCheck($LqvE5, $r1oS5) { goto H4QvG; thD0_: MemberUtil::forgetOauth($LqvE5, $r1oS5); goto Xcxo_; H4QvG: $KJqKC = self::getIdByOauth($LqvE5, $r1oS5); goto q3v15; q3v15: if (self::get($KJqKC)) { return $KJqKC; } goto thD0_; Xcxo_: return 0; goto pZ3kz; pZ3kz: } public static function getOauthOpenId($KJqKC, $LqvE5) { goto HQmX3; bmLSi: if (empty($Kwhgm)) { return null; } goto QtKvL; QtKvL: return $Kwhgm['openId']; goto u_owY; HQmX3: $xAO9M = array('memberUserId' => $KJqKC, 'type' => $LqvE5); goto qH8YG; qH8YG: $Kwhgm = ModelUtil::get('member_oauth', $xAO9M); goto bmLSi; u_owY: } public static function getOauth($KJqKC, $LqvE5) { $xAO9M = array('memberUserId' => $KJqKC, 'type' => $LqvE5); return ModelUtil::get('member_oauth', $xAO9M); } public static function listOauths($KJqKC) { return ModelUtil::all('member_oauth', array('memberUserId' => $KJqKC), array('*'), array('type', 'asc')); } public static function putOauth($KJqKC, $LqvE5, $r1oS5, $K1Wao = array()) { goto kVIa8; VqHGq: $Kwhgm = ModelUtil::get('member_oauth', $xAO9M); goto J_Hle; J_Hle: $chyCL = array_merge(array('openId' => $r1oS5), $K1Wao); goto z3mL4; dcyhn: LockUtil::release($OK3CU); goto G0HDz; z3mL4: if (empty($Kwhgm)) { ModelUtil::delete('member_oauth', array('type' => $LqvE5, 'openId' => $r1oS5)); ModelUtil::insert('member_oauth', array_merge($xAO9M, $chyCL)); } else { if ($Kwhgm['openId'] != $r1oS5) { ModelUtil::update('member_oauth', $Kwhgm['id'], $chyCL); } } goto dcyhn; Nm3GM: $OK3CU = "MemberOauth:{$KJqKC}"; goto QGiTp; kVIa8: $xAO9M = array('memberUserId' => $KJqKC, 'type' => $LqvE5); goto Nm3GM; QGiTp: if (!LockUtil::acquire($OK3CU)) { BizException::throws('正在处理中，请稍后再试'); } goto VqHGq; G0HDz: } public static function forgetOauth($LqvE5, $r1oS5) { ModelUtil::delete('member_oauth', array('type' => $LqvE5, 'openId' => $r1oS5)); } public static function updateNewMessageStatus($KJqKC) { ModelUtil::update('member_user', array('id' => $KJqKC), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $KJqKC, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($KJqKC) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $KJqKC), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $KJqKC)))); } } public static function paginate($JcqUq, $WrYIu, $iNhXN = array()) { return ModelUtil::paginate('member_user', $JcqUq, $WrYIu, $iNhXN); } public static function updateStatus($Pg2_1, $E4DAQ) { goto a0wB0; mAVXs: ModelUtil::model('member_user')->whereIn('id', $Pg2_1)->update(array('status' => $E4DAQ)); goto fRrO7; a0wB0: if (!is_array($Pg2_1)) { $Pg2_1 = array($Pg2_1); } goto y01l3; y01l3: if (empty($Pg2_1)) { return; } goto mAVXs; fRrO7: } public static function delete($KJqKC) { goto YVIDE; BTDOh: ModelUtil::transactionBegin(); goto dZEHU; Z2Zlx: $n16LT['oauth'] = ArrayUtil::keepItemsKeys($j8Fkc, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto jeey9; kZ3yA: BizException::throwsIfEmpty('用户不存在', $g3uu_); goto BTDOh; bhZQx: ModelUtil::update('member_user', $KJqKC, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto ICNo1; I7aca: $j8Fkc = ModelUtil::all('member_oauth', array('memberUserId' => $g3uu_['id'])); goto Z2Zlx; jeey9: ModelUtil::insert('member_deleted', array('id' => $g3uu_['id'], 'username' => $g3uu_['username'], 'phone' => $g3uu_['phone'], 'email' => $g3uu_['email'], 'content' => json_encode($n16LT, JSON_UNESCAPED_UNICODE))); goto bhZQx; dZEHU: $n16LT = array(); goto I7aca; YVIDE: $g3uu_ = self::get($KJqKC); goto kZ3yA; ICNo1: ModelUtil::transactionCommit(); goto xiyQI; xiyQI: } public static function fireLogin($KJqKC) { goto pUx_S; pUx_S: $AZhwp = Request::ip(); goto ZoaJX; giYWZ: ModelUtil::insert('member_login_log', array('memberUserId' => $KJqKC, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($AZhwp, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto f3JSi; ZoaJX: ModelUtil::update('member_user', $KJqKC, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($AZhwp, 20))); goto giYWZ; f3JSi: } }