<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Input; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Response; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserUpdatedEvent; use Module\Member\Support\MemberLoginCheck; use Module\Member\Util\MemberUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Sms\SmsUtil; use Module\Vendor\Support\ResponseCodes; class MemberProfileController extends ModuleBaseController implements MemberLoginCheck { public function nickname() { goto Nr73A; qhNiH: BizException::throwsIfResponseError($Tbn6c); goto lpdvt; b8TB0: $Tbn6c = MemberUtil::changeNickname(MemberUser::id(), $etgIw); goto qhNiH; mJmeQ: if (!CaptchaFacade::check($WZ8dY->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto b8TB0; Nr73A: $WZ8dY = InputPackage::buildFromInput(); goto vAevy; wJ1hH: BizException::throwsIfEmpty('昵称为空', $etgIw); goto mJmeQ; lpdvt: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'nickname')); goto VfO5l; VfO5l: return Response::generate(0, '修改成功', null, '[reload]'); goto b94iu; vAevy: $etgIw = $WZ8dY->getTrimString('nickname'); goto wJ1hH; b94iu: } public function password() { goto vI7MO; NpebA: if ($JTPpg != $HR_HQ) { return Response::generate(-1, '两次新密码输入不一致'); } goto sIYzW; DW8C0: $HR_HQ = $WZ8dY->getTrimString('passwordRepeat'); goto NpebA; JrPAR: if (empty($g3uu_['password'])) { $Tbn6c = MemberUtil::changePassword(MemberUser::id(), $JTPpg, null, true); } else { $Tbn6c = MemberUtil::changePassword(MemberUser::id(), $JTPpg, $VvNfH); } goto A6t21; h7XVB: $VvNfH = $WZ8dY->getTrimString('passwordOld'); goto XnH4K; vI7MO: $WZ8dY = InputPackage::buildFromInput(); goto h7XVB; XnH4K: $JTPpg = $WZ8dY->getTrimString('passwordNew'); goto DW8C0; sIYzW: $g3uu_ = MemberUser::get(); goto JrPAR; A6t21: if ($Tbn6c['code']) { return Response::generate(-1, $Tbn6c['msg']); } goto S8G3q; c2EPu: return Response::generate(0, '修改成功', null, '[reload]'); goto YyxFg; S8G3q: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'password')); goto c2EPu; YyxFg: } public function avatar() { goto mOtVz; o3CX6: $UCNYd = $WZ8dY->getTrimString('avatar'); goto bmTRy; mOtVz: $WZ8dY = InputPackage::buildFromInput(); goto o3CX6; bmTRy: if (empty($UCNYd)) { return Response::generate(-1, '头像内容为空'); } goto y_yQV; y_yQV: switch ($WZ8dY->getTrimString('type')) { case 'cropper': goto kjFTK; zU86h: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto kFOLF; BKO8x: $UCNYd = @base64_decode($UCNYd); goto wrcDb; T803h: $Tbn6c = MemberUtil::setAvatar(MemberUser::id(), $UCNYd, $njnO6); goto F2EYR; kFOLF: return Response::generate(0, '保存成功', null, '[reload]'); goto gm2Vk; F2EYR: if ($Tbn6c['code']) { return $Tbn6c; } goto zU86h; CbvWq: if (Str::startsWith($UCNYd, 'data:image/jpeg;base64,')) { $njnO6 = 'jpg'; $UCNYd = substr($UCNYd, strlen('data:image/jpeg;base64,')); } else { if (Str::startsWith($UCNYd, 'data:image/png;base64,')) { $njnO6 = 'png'; $UCNYd = substr($UCNYd, strlen('data:image/png;base64,')); } } goto vckVz; vckVz: if (empty($njnO6)) { return Response::generate(-1, '头像数据为空'); } goto BKO8x; kjFTK: $njnO6 = null; goto CbvWq; wrcDb: if (empty($UCNYd)) { return Response::generate(-1, '头像内容为空'); } goto T803h; gm2Vk: default: goto AUSBm; WLWv7: if (empty($UCNYd)) { return Response::generate(-1, '读取头像文件失败:-1'); } goto ZHo1t; DoKDT: $UCNYd = FileUtil::safeGetContent($UCNYd); goto BLoD0; BLoD0: if (empty($UCNYd)) { return Response::generate(-1, '读取头像文件失败:-2'); } goto UrymY; XymdX: if ($Tbn6c['code']) { return $Tbn6c; } goto iVdsb; iVdsb: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'avatar')); goto c13WX; UrymY: $Tbn6c = MemberUtil::setAvatar(MemberUser::id(), $UCNYd, $KUm6i); goto XymdX; ZHo1t: $KUm6i = FileUtil::extension($UCNYd); goto bb5OP; AUSBm: $UCNYd = FileUtil::savePathToLocalTemp($UCNYd); goto WLWv7; c13WX: return Response::generate(0, '保存成功', null, '[reload]'); goto M1DkA; bb5OP: if (!in_array($KUm6i, config('data.upload.image.extensions'))) { return Response::generate(-1, '头像格式不合法'); } goto DoKDT; M1DkA: } goto EtBxF; EtBxF: } public function captchaRaw() { return CaptchaFacade::create('default'); } public function captcha() { $bGmvK = $this->captchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($bGmvK->getOriginalContent()))); } public function email() { goto bnMv4; cRQXO: Session::forget('memberProfileEmail'); goto ujPIw; teCtN: if (Session::get('memberProfileEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto EGh7k; J37G4: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'email')); goto juIXt; qYZue: if ($DLZ20 != Session::get('memberProfileEmailVerify')) { return Response::generate(-1, '验证码不正确'); } goto teCtN; EGh7k: if ($dRXuh != Session::get('memberProfileEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto MH1_k; V5mAE: $DLZ20 = $WZ8dY->getTrimString('verify'); goto cs_Sx; bnMv4: $WZ8dY = InputPackage::buildFromInput(); goto SW5Zy; MH1_k: $V3irA = MemberUtil::getByEmail($dRXuh); goto iGlLq; Rxzab: MemberUtil::update(MemberUser::id(), array('emailVerified' => true, 'email' => $dRXuh)); goto J37G4; U7YNR: Session::forget('memberProfileEmailVerifyTime'); goto cRQXO; SW5Zy: $dRXuh = $WZ8dY->getEmail('email'); goto V5mAE; G_ruo: if (empty($DLZ20)) { return Response::generate(-1, '验证码不能为空'); } goto qYZue; H4xVn: if (!FormatUtil::isEmail($dRXuh)) { return Response::generate(-1, '邮箱格式不正确'); } goto G_ruo; juIXt: Session::forget('memberProfileEmailVerify'); goto U7YNR; cs_Sx: if (empty($dRXuh)) { return Response::generate(-1, '邮箱不能为空'); } goto H4xVn; ujPIw: return Response::generate(0, '修改成功', null, '[reload]'); goto II23D; iGlLq: if (!empty($V3irA)) { if ($V3irA['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($V3irA['id'] == MemberUser::id() && $V3irA['email'] == $dRXuh) { if (!empty($V3irA['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto Rxzab; II23D: } public function emailVerify() { goto EddXk; VzHV0: return Response::generate(0, '验证码发送成功'); goto lMAuT; yZFLx: MailSendJob::create($dRXuh, '验证码', 'verify', array('code' => $DLZ20)); goto VzHV0; Uw5wI: $V3irA = MemberUtil::getByEmail($dRXuh); goto Og71G; K_Ma2: if (empty($dRXuh)) { return Response::generate(-1, '邮箱不能为空'); } goto AkjBv; PEKJD: Session::put('memberProfileEmail', $dRXuh); goto yZFLx; jNvbz: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto Uw5wI; CdTmc: if (Session::get('memberProfileEmailVerifyTime') && $dRXuh == Session::get('memberProfileEmail')) { if (Session::get('memberProfileEmailVerifyTime') + 60 * 10 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto RRfwb; RRfwb: $DLZ20 = rand(100000, 999999); goto MXP66; MXP66: Session::put('memberProfileEmailVerify', $DLZ20); goto iapXU; Og71G: if (!empty($V3irA)) { if ($V3irA['id'] != MemberUser::id()) { return Response::generate(-1, '该邮箱已被其他账户绑定'); } if ($V3irA['id'] == MemberUser::id() && $V3irA['email'] == $dRXuh) { if (!empty($V3irA['emailVerified'])) { return Response::generate(-1, '邮箱未修改，无需重新绑定。'); } } } goto CdTmc; EddXk: $dRXuh = Input::get('target'); goto K_Ma2; AkjBv: if (!FormatUtil::isEmail($dRXuh)) { return Response::generate(-1, '邮箱格式不正确'); } goto jNvbz; iapXU: Session::put('memberProfileEmailVerifyTime', time()); goto PEKJD; lMAuT: } public function phone() { goto XfI93; YkjqO: Session::forget('memberProfilePhoneVerify'); goto f2dc9; aMIhP: if (!FormatUtil::isPhone($VaTf5)) { return Response::generate(-1, '手机格式不正确'); } goto Wjjk5; Eb023: if (!empty($V3irA)) { if ($V3irA['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($V3irA['id'] == MemberUser::id() && $V3irA['phone'] == $VaTf5) { if (!empty($V3irA['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto dpaGd; XfI93: $WZ8dY = InputPackage::buildFromInput(); goto Y22Lg; SrQDp: if (empty($VaTf5)) { return Response::generate(-1, '手机不能为空'); } goto aMIhP; f2dc9: Session::forget('memberProfilePhoneVerifyTime'); goto kejGn; Wjjk5: if (empty($DLZ20)) { return Response::generate(-1, '验证码不能为空'); } goto shUTR; dpaGd: MemberUtil::update(MemberUser::id(), array('phoneVerified' => true, 'phone' => $VaTf5)); goto ZSqwb; shUTR: if ($DLZ20 != Session::get('memberProfilePhoneVerify')) { return Response::generate(-1, '验证码不正确'); } goto ZzU1j; kejGn: Session::forget('memberProfilePhone'); goto MV1X7; Y22Lg: $VaTf5 = $WZ8dY->getPhone('phone'); goto kkVjo; VAz7S: if ($VaTf5 != Session::get('memberProfilePhone')) { return Response::generate(-1, '两次手机不一致'); } goto PnzqS; kkVjo: $DLZ20 = $WZ8dY->getTrimString('verify'); goto SrQDp; PnzqS: $V3irA = MemberUtil::getByPhone($VaTf5); goto Eb023; ZzU1j: if (Session::get('memberProfilePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '验证码已过期'); } goto VAz7S; ZSqwb: EventUtil::fire(new MemberUserUpdatedEvent(MemberUser::id(), 'phone')); goto YkjqO; MV1X7: return Response::generate(0, '修改成功', null, '[reload]'); goto xV1Hw; xV1Hw: } public function phoneVerify() { goto WUyeV; WUyeV: $VaTf5 = Input::get('target'); goto bgD8H; RkNes: return Response::generate(0, '验证码发送成功'); goto z5oeH; Vf_rl: SmsSendJob::create($VaTf5, 'verify', array('code' => $DLZ20)); goto RkNes; zykTn: if (Session::get('memberProfilePhoneVerifyTime') && $VaTf5 == Session::get('memberProfilePhone')) { if (Session::get('memberProfilePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto a1Rvm; bgD8H: if (empty($VaTf5)) { return Response::generate(-1, '手机不能为空'); } goto EyOVQ; vo1C_: $V3irA = MemberUtil::getByPhone($VaTf5); goto QwwRT; pu7iV: Session::put('memberProfilePhone', $VaTf5); goto Vf_rl; NDC5D: Session::put('memberProfilePhoneVerify', $DLZ20); goto jbrvl; QwwRT: if (!empty($V3irA)) { if ($V3irA['id'] != MemberUser::id()) { return Response::generate(-1, '该手机已被其他账户绑定'); } if ($V3irA['id'] == MemberUser::id() && $V3irA['phone'] == $VaTf5) { if (!empty($V3irA['phoneVerified'])) { return Response::generate(-1, '手机号未修改，无需重新绑定。'); } } } goto zykTn; EyOVQ: if (!FormatUtil::isPhone($VaTf5)) { return Response::generate(-1, '手机格式不正确'); } goto m4tye; jbrvl: Session::put('memberProfilePhoneVerifyTime', time()); goto pu7iV; a1Rvm: $DLZ20 = rand(100000, 999999); goto NDC5D; m4tye: if (!CaptchaFacade::check(Input::get('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '图片验证码错误'); } goto vo1C_; z5oeH: } public function oauthUnbind() { goto nngSH; ZJ2bI: $EpKdG = $WZ8dY->getTrimString('type'); goto yw6E6; G0fke: BizException::throwsIfEmpty('授权方式不存在', $J2o_m); goto bklSX; bklSX: $r1oS5 = MemberUtil::getOauthOpenId(MemberUser::id(), $J2o_m->oauthKey()); goto Jv1Hx; yw6E6: $J2o_m = MemberOauth::getOrFail($EpKdG); goto G0fke; Jv1Hx: if ($r1oS5) { MemberUtil::forgetOauth($J2o_m->oauthKey(), $r1oS5); } goto WYkqp; nngSH: $WZ8dY = InputPackage::buildFromInput(); goto ZJ2bI; WYkqp: return Response::generate(0, '解绑成功', null, '[reload]'); goto IoJrk; IoJrk: } public function delete() { goto k2Rwh; suKLM: $g3uu_ = MemberUser::get(); goto m0dDb; UBusb: $o8IuL = $WZ8dY->getTrimString('agree'); goto BmYJH; sDayM: return Response::generate(0, '申请注销成功', null, '[reload]'); goto Ul0C3; de_Gd: $WZ8dY = InputPackage::buildFromInput(); goto UBusb; oywHP: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => time() + TimeUtil::PERIOD_MONTH)); goto sDayM; m0dDb: if ($g3uu_['deleteAtTime'] > 0) { return Response::generateError('账号正在注销中'); } goto de_Gd; BmYJH: BizException::throwsIf('请勾选同意选项', $o8IuL != 'yes'); goto oywHP; k2Rwh: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto suKLM; Ul0C3: } public function deleteRevert() { goto N3l6e; ij6pt: MemberUtil::update(MemberUser::id(), array('deleteAtTime' => 0)); goto wP11O; wP11O: return Response::generate(0, '撤销操作成功', null, '[reload]'); goto O3Qbz; gtQfq: $g3uu_ = MemberUser::get(); goto nOaPV; N3l6e: if (!modstart_config('Member_DeleteEnable', false)) { return Response::generateError('注销账号功能未开启'); } goto gtQfq; nOaPV: if (empty($g3uu_['deleteAtTime'])) { return Response::generateError('账号没有注销操作'); } goto ij6pt; O3Qbz: } }