<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $lZifj) { $lZifj->init('member_user')->field(function ($lZifj) { $lZifj->id('id', 'ID'); MemberAdminList::callGridField($lZifj); $lZifj->display('avatar', '头像')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { $sGyAZ = AssetsUtil::fixOrDefault($jIWZA->avatar, 'asset/image/avatar.svg'); $QKDKl = AssetsUtil::fixOrDefault($jIWZA->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$QKDKl}' class='tw-inline-block' data-image-preview>\n                        <img src='{$sGyAZ}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $lZifj->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { switch ($pZ_lR->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($jIWZA->username), modstart_admin_url('member/show', array('_id' => $jIWZA->id)))->width('90%')->height('90%')->render()); break; } }); $lZifj->text('email', '邮箱'); $lZifj->text('phone', '手机'); $lZifj->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $lZifj->display('_oauth', '授权')->hookRendering(function (AbstractField $pZ_lR, $jIWZA, $aaYHa) { $w62n1 = array(); $zF_Qu = MemberUtil::listOauths($jIWZA->id); foreach ($zF_Qu as $hpFhm) { goto Y4rmo; M8ceS: if (empty($BU2zl)) { $BU2zl = ColorUtil::pick($hpFhm['type']); } goto rZY1W; j5Ri4: $J2o_m = MemberOauth::getByOauthKey($hpFhm['type']); goto LiqOw; Y4rmo: $BU2zl = null; goto bCpa0; bCpa0: $yP0KF = $hpFhm['type']; goto j5Ri4; LiqOw: if ($J2o_m) { $BU2zl = $J2o_m->color(); $yP0KF = $J2o_m->title(); } goto M8ceS; rZY1W: $w62n1[] = '<a style="color:' . $BU2zl . ';" href="javascript:;" data-tip-popover="' . $yP0KF . '"><i class="iconfont icon-dot"></i></a>'; goto y_8D4; y_8D4: } return join('', $w62n1); }); } $lZifj->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $C8ECb = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($C8ECb) { $lZifj->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $xGSm4 = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($xGSm4) { $lZifj->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $lZifj->date('vipExpire', 'VIP过期'); } $lZifj->display('registerIp', '注册IP'); $lZifj->display('created_at', '注册时间'); $lZifj->canBatchSelect(true); $lZifj->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $bu01d) { $bu01d->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $bu01d) { $bu01d->eq('id', L('ID')); $bu01d->like('username', '用户名'); $bu01d->like('email', '邮箱')->autoHide(true); $bu01d->like('phone', '手机')->autoHide(true); $bu01d->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $bu01d->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $bu01d->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $zCZzC) { $jIWZA = $zCZzC->item(); $zCZzC->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $jIWZA->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $JcqUq) { goto xRGtZ; xRGtZ: $yZTO2 = Form::make(''); goto CYEy_; iWvlF: return $JcqUq->pageTitle('创建用户')->body($yZTO2)->handleForm($yZTO2, function (Form $yZTO2) { AdminPermission::demoCheck(); $U8wjN = $yZTO2->dataForming(); $ypwo8 = !empty($U8wjN['username']) ? $U8wjN['username'] : null; $VaTf5 = !empty($U8wjN['phone']) ? $U8wjN['phone'] : null; $dRXuh = !empty($U8wjN['email']) ? $U8wjN['email'] : null; $gkoA3 = ArrayUtil::keepKeys($U8wjN, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $Tbn6c = MemberUtil::register($ypwo8, $VaTf5, $dRXuh, $U8wjN['password']); BizException::throwsIfResponseError($Tbn6c); if (!empty($gkoA3)) { if (isset($gkoA3['vipExpire']) && TimeUtil::isDateEmpty($gkoA3['vipExpire'])) { $gkoA3['vipExpire'] = null; } MemberUtil::update($Tbn6c['data']['id'], $gkoA3); } EventUtil::fire(new MemberUserRegisteredEvent($Tbn6c['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto J0oLs; ZnHHV: $yZTO2->showSubmit(false)->showReset(false); goto iWvlF; nRVOj: $yZTO2->layoutPanel('高级', function (Form $yZTO2) { $yZTO2->text('nickname', '昵称'); $yZTO2->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $yZTO2->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $yZTO2->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $yZTO2->date('vipExpire', 'VIP过期'); } }); goto ZnHHV; CYEy_: $yZTO2->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $yZTO2) { $yZTO2->text('username', '用户名'); $yZTO2->text('phone', '手机'); $yZTO2->text('email', '邮箱'); $yZTO2->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto nRVOj; J0oLs: } public function edit(AdminDialogPage $JcqUq) { goto gYfRx; UA4st: BizException::throwsIfEmpty('用户不存在', $g3uu_); goto BOVNF; gYfRx: $g3uu_ = ModelUtil::get('member_user', CRUDUtil::id()); goto UA4st; BOVNF: if (Request::isPost()) { goto FYCSE; KVKa6: $WZ8dY = InputPackage::buildFromInput(); goto xAgci; xAgci: switch ($WZ8dY->getTrimString('_action')) { case 'itemCellEdit': goto uT8Wg; yCAj5: if (!empty($chyCL)) { MemberUtil::update($g3uu_['id'], $chyCL); } goto AxElJ; AxElJ: return Response::generateSuccess(); goto ghRJD; f1auD: switch ($WZ8dY->getTrimString('column')) { case 'status': $chyCL['status'] = $WZ8dY->getInteger('value'); break; } goto yCAj5; uT8Wg: $chyCL = array(); goto f1auD; ghRJD: } goto OYzpM; FYCSE: AdminPermission::demoCheck(); goto KVKa6; OYzpM: } goto Xl0_I; U0tCC: $yZTO2->layoutPanel('基础', function (Form $yZTO2) { $yZTO2->display('id', '用户ID')->addable(true); $yZTO2->text('username', '用户名'); $yZTO2->text('phone', '手机'); $yZTO2->text('email', '邮箱'); }); goto a_pOu; Xl0_I: $yZTO2 = Form::make(''); goto U0tCC; uIC8S: $yZTO2->showSubmit(false)->showReset(false); goto UvjJh; UvjJh: return $JcqUq->pageTitle('修改信息')->body($yZTO2)->handleForm($yZTO2, function (Form $yZTO2) use($g3uu_) { AdminPermission::demoCheck(); $U8wjN = $yZTO2->dataForming(); $NAa54 = ArrayUtil::keepKeys($U8wjN, array('username', 'phone', 'email')); $gkoA3 = ArrayUtil::keepKeys($U8wjN, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $Tbn6c = MemberUtil::updateBasicWithUniqueCheck($g3uu_['id'], $NAa54); BizException::throwsIfResponseError($Tbn6c); if (isset($gkoA3['vipExpire']) && TimeUtil::isDateEmpty($gkoA3['vipExpire'])) { $gkoA3['vipExpire'] = null; } MemberUtil::update($g3uu_['id'], $gkoA3); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto HO2By; a_pOu: $yZTO2->layoutPanel('高级', function (Form $yZTO2) { $yZTO2->text('nickname', '昵称'); $yZTO2->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $yZTO2->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $yZTO2->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $yZTO2->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto D3pUE; D3pUE: $yZTO2->item($g3uu_)->fillFields(); goto uIC8S; HO2By: } public function select(AdminDialogPage $JcqUq) { goto UebAW; EAaFs: $gwmIt->canSingleSelectItem(true); goto hYbf2; JkGCK: return $JcqUq->pageTitle('选择用户')->body($gwmIt); goto kcNbI; jf7x7: $gwmIt->disableCUD(); goto EAaFs; zcLiC: if (Request::isPost()) { return $gwmIt->request(); } goto JkGCK; hYbf2: CRUDUtil::registerGridResource($gwmIt, '\\' . __CLASS__); goto zcLiC; UebAW: $gwmIt = $this->grid(); goto jf7x7; kcNbI: } public function search() { goto oAF3O; uFql4: $y6j27 = MemberUtil::paginate(1, 10, $iNhXN); goto Hzvfl; Mb2GI: $iNxEa = $WZ8dY->getTrimString('keywords'); goto fUhr1; fUhr1: $iNhXN = array(); goto nHI9G; tHl47: return Response::jsonSuccessData($sX2oK); goto RV9li; nHI9G: $iNhXN['whereOperate'] = array('username', 'like', "%{$iNxEa}%"); goto uFql4; Hzvfl: $sX2oK = array_map(function ($jIWZA) { return array('value' => intval($jIWZA['id']), 'name' => htmlspecialchars(MemberUtil::viewName($jIWZA)), 'avatar' => AssetsUtil::fixOrDefault($jIWZA['avatar'], 'asset/image/avatar.svg')); }, $y6j27['records']); goto tHl47; oAF3O: $WZ8dY = InputPackage::buildFromInput(); goto Mb2GI; RV9li: } public function resetPassword(AdminConfigBuilder $lZifj) { goto DDTQy; oC1AL: $g3uu_ = MemberUtil::get($ULYbu); goto zEAL1; AGv9W: $lZifj->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto N2CKP; N2CKP: if (Request::isPost()) { return $lZifj->formRequest(function (Form $yZTO2) use($g3uu_) { AdminPermission::demoCheck(); $U8wjN = $yZTO2->dataForming(); $Tbn6c = MemberUtil::changePassword($g3uu_['id'], $U8wjN['passwordNew'], null, true); BizException::throwsIfResponseError($Tbn6c); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto UV9uW; TRd84: $lZifj->useDialog(); goto tizfd; UV9uW: return $lZifj; goto CAlw1; tizfd: $lZifj->pageTitle('重置密码'); goto AGv9W; zEAL1: BizException::throwsIfEmpty('用户不存在', $g3uu_); goto TRd84; DDTQy: $ULYbu = CRUDUtil::id(); goto oC1AL; CAlw1: } public function sendMessage(AdminConfigBuilder $lZifj) { goto nEtVa; kkqbG: $lZifj->useDialog(); goto Z92n9; rPRcc: BizException::throwsIfEmpty('用户不存在', $g3uu_); goto kkqbG; Hujlt: return $lZifj; goto X8Zty; rL_Ky: $lZifj->richHtml('content', '消息内容')->required(); goto jz_je; jz_je: if (Request::isPost()) { return $lZifj->formRequest(function (Form $yZTO2) use($g3uu_) { AdminPermission::demoCheck(); $U8wjN = $yZTO2->dataForming(); $Tbn6c = MemberMessageUtil::send($g3uu_['id'], $U8wjN['content']); BizException::throwsIfResponseError($Tbn6c); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto Hujlt; nEtVa: $ULYbu = CRUDUtil::id(); goto wxNp9; wxNp9: $g3uu_ = MemberUtil::get($ULYbu); goto rPRcc; Z92n9: $lZifj->pageTitle('发送消息'); goto rL_Ky; X8Zty: } public function show() { goto LAX05; LAX05: $lpVAI = MemberUtil::get(CRUDUtil::id()); goto dP6pC; byxpf: return view('module::Member.View.admin.memberUser.show', array('record' => $lpVAI, 'showPanelProviders' => $SjCjc)); goto B6VFa; dP6pC: $SjCjc = MemberAdminShowPanelProvider::listAll(); goto byxpf; B6VFa: } public function delete() { goto ymTK_; fVzMO: MemberUtil::delete(CRUDUtil::id()); goto dtCRc; dtCRc: return Response::redirect(CRUDUtil::jsGridRefresh()); goto S2E7S; ymTK_: AdminPermission::demoCheck(); goto fVzMO; S2E7S: } public function statusForbidden() { goto gS2JS; NB1Ve: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto uMI9c; gS2JS: AdminPermission::demoCheck(); goto NB1Ve; uMI9c: return Response::redirect(CRUDUtil::jsGridRefresh()); goto FSMtZ; FSMtZ: } public function export(ExportHandle $J40WC) { $vQNyr = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $J40WC->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($vQNyr)->handleFetch(function ($JcqUq, $WrYIu, $oYeH5, $qOrzw) { $mwwOg = ModelUtil::model('member_user'); $mwwOg = $mwwOg->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($oYeH5 as $DMP8a) { if (!empty($DMP8a['id']['eq'])) { $mwwOg = $mwwOg->where('id', $DMP8a['id']['eq']); } elseif (!empty($DMP8a['status']['eq'])) { $mwwOg = $mwwOg->where('status', $DMP8a['status']['eq']); } elseif (!empty($DMP8a['groupId']['eq'])) { $mwwOg = $mwwOg->where('groupId', $DMP8a['groupId']['eq']); } elseif (!empty($DMP8a['vipId']['eq'])) { $mwwOg = $mwwOg->where('vipId', $DMP8a['vipId']['eq']); } elseif (!empty($DMP8a['username']['like'])) { $mwwOg = $mwwOg->where('username', 'like', '%' . $DMP8a['username']['like'] . '%'); } elseif (!empty($DMP8a['email']['like'])) { $mwwOg = $mwwOg->where('email', 'like', '%' . $DMP8a['email']['like'] . '%'); } elseif (!empty($DMP8a['phone']['like'])) { $mwwOg = $mwwOg->where('phone', 'like', '%' . $DMP8a['phone']['like'] . '%'); } } $nV1c1 = $mwwOg->paginate($WrYIu, array('*'), 'page', $JcqUq)->toArray(); $K938W = array(); foreach ($nV1c1['data'] as $jIWZA) { goto uC5u4; uC5u4: $M0WVk = array(); goto Pk0fT; JGqsf: $M0WVk[] = $jIWZA['created_at']; goto GZ74c; i0eAQ: $K938W[] = $M0WVk; goto uky8V; IDUx3: $M0WVk[] = $jIWZA['realname']; goto sjvxB; sjvxB: $M0WVk[] = $jIWZA['signature']; goto i0eAQ; GZ74c: $M0WVk[] = TypeUtil::name(Gender::class, $jIWZA['gender']); goto IDUx3; MwCm5: $M0WVk[] = $jIWZA['username']; goto qJCFF; LfywZ: $M0WVk[] = $jIWZA['phone']; goto JGqsf; Pk0fT: $M0WVk[] = $jIWZA['id']; goto MwCm5; qJCFF: $M0WVk[] = $jIWZA['email']; goto LfywZ; uky8V: } return array('list' => $K938W, 'total' => $nV1c1['total']); })->performCommon(); } }